/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Expression;
import io.quarkus.qute.Futures;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public class SetSectionHelper
implements SectionHelper {
    private static final String SET = "set";
    private static final String LET = "let";
    private final Map<String, Expression> parameters;

    SetSectionHelper(Map<String, Expression> parameters) {
        this.parameters = parameters;
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        CompletableFuture<ResultNode> result = new CompletableFuture<ResultNode>();
        Futures.evaluateParams(this.parameters, context.resolutionContext()).whenComplete((r, t) -> {
            if (t != null) {
                result.completeExceptionally((Throwable)t);
            } else {
                context.execute(context.resolutionContext().createChild(r, null)).whenComplete((r2, t2) -> {
                    if (t2 != null) {
                        result.completeExceptionally((Throwable)t2);
                    } else {
                        result.complete((ResultNode)r2);
                    }
                });
            }
        });
        return result;
    }

    public static class Factory
    implements SectionHelperFactory<SetSectionHelper> {
        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of(SetSectionHelper.SET, SetSectionHelper.LET);
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.EMPTY;
        }

        @Override
        public SetSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            Map<String, Expression> params = context.getParameters().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> context.parseValue((String)e.getValue())));
            return new SetSectionHelper(params);
        }

        @Override
        public Scope initializeBlock(Scope previousScope, SectionHelperFactory.BlockInfo block) {
            if (block.getLabel().equals("$main")) {
                Scope newScope = new Scope(previousScope);
                for (Map.Entry<String, String> entry : block.getParameters().entrySet()) {
                    Expression expr = block.addExpression(entry.getKey(), entry.getValue());
                    newScope.putBinding(entry.getKey(), expr.collectTypeInfo());
                }
                return newScope;
            }
            return previousScope;
        }
    }
}

