/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Expression;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.MultiResultNode;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Results;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class LoopSectionHelper
implements SectionHelper {
    private static final String DEFAULT_ALIAS = "it";
    private final String alias;
    private final Expression iterable;

    LoopSectionHelper(String alias, Expression iterable) {
        this.alias = "$empty$".equals(alias) ? DEFAULT_ALIAS : alias;
        this.iterable = Objects.requireNonNull(iterable);
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        return context.resolutionContext().evaluate(this.iterable).thenCompose(it -> {
            if (it == null) {
                throw new TemplateException(String.format("Iteration error in template [%s] on line %s: {%s} resolved to null, use {%<s.orEmpty} to ignore this error", this.iterable.getOrigin().getTemplateId(), this.iterable.getOrigin().getLine(), this.iterable.toOriginalString()));
            }
            ArrayList<CompletionStage<ResultNode>> results = new ArrayList<CompletionStage<ResultNode>>(LoopSectionHelper.extractSize(it));
            Iterator<?> iterator = this.extractIterator(it);
            int idx = 0;
            while (iterator.hasNext()) {
                results.add(this.nextElement(iterator.next(), idx++, iterator.hasNext(), context));
            }
            if (results.isEmpty()) {
                return ResultNode.NOOP;
            }
            if (results.size() == 1) {
                return (CompletionStage)results.get(0);
            }
            CompletableFuture result = new CompletableFuture();
            CompletableFuture[] allResults = new CompletableFuture[results.size()];
            idx = 0;
            for (CompletionStage completionStage : results) {
                allResults[idx++] = completionStage.toCompletableFuture();
            }
            CompletableFuture.allOf(allResults).whenComplete((v, t) -> {
                if (t != null) {
                    result.completeExceptionally((Throwable)t);
                } else {
                    result.complete(new MultiResultNode(allResults));
                }
            });
            return result;
        });
    }

    private static int extractSize(Object it) {
        if (it instanceof Collection) {
            return ((Collection)it).size();
        }
        if (it instanceof Map) {
            return ((Map)it).size();
        }
        if (it.getClass().isArray()) {
            return Array.getLength(it);
        }
        if (it instanceof Integer) {
            return (Integer)it;
        }
        return 10;
    }

    private Iterator<?> extractIterator(Object it) {
        if (it instanceof Iterable) {
            return ((Iterable)it).iterator();
        }
        if (it instanceof Iterator) {
            return (Iterator)it;
        }
        if (it instanceof Map) {
            return ((Map)it).entrySet().iterator();
        }
        if (it instanceof Stream) {
            return ((Stream)((Stream)it).sequential()).iterator();
        }
        if (it instanceof Integer) {
            return IntStream.rangeClosed(1, (Integer)it).iterator();
        }
        if (it.getClass().isArray()) {
            int length = Array.getLength(it);
            ArrayList<Object> elements = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                elements.add(Array.get(it, i));
            }
            return elements.iterator();
        }
        String msg = Results.Result.NOT_FOUND.equals(it) ? String.format("Iteration error in template [%s] on line %s: {%s} not found, use {%<s.orEmpty} to ignore this error", this.iterable.getOrigin().getTemplateId(), this.iterable.getOrigin().getLine(), this.iterable.toOriginalString()) : String.format("Iteration error in template [%s] on line %s: {%s} resolved to [%s] which is not iterable", this.iterable.getOrigin().getTemplateId(), this.iterable.getOrigin().getLine(), this.iterable.toOriginalString(), it.getClass().getName());
        throw new TemplateException(msg);
    }

    CompletionStage<ResultNode> nextElement(Object element, int index, boolean hasNext, SectionHelper.SectionResolutionContext context) {
        ResolutionContext child = context.resolutionContext().createChild(new IterationElement(this.alias, element, index, hasNext), null);
        return context.execute(child);
    }

    static class IterationElement
    implements Mapper {
        static final CompletableFuture<Object> EVEN = CompletableFuture.completedFuture("even");
        static final CompletableFuture<Object> ODD = CompletableFuture.completedFuture("odd");
        final String alias;
        final CompletableFuture<Object> element;
        final int index;
        final boolean hasNext;

        public IterationElement(String alias, Object element, int index, boolean hasNext) {
            this.alias = alias;
            this.element = CompletableFuture.completedFuture(element);
            this.index = index;
            this.hasNext = hasNext;
        }

        @Override
        public CompletionStage<Object> getAsync(String key) {
            if (this.alias.equals(key)) {
                return this.element;
            }
            switch (key) {
                case "count": {
                    return CompletableFuture.completedFuture(this.index + 1);
                }
                case "index": {
                    return CompletableFuture.completedFuture(this.index);
                }
                case "indexParity": {
                    return this.index % 2 != 0 ? EVEN : ODD;
                }
                case "hasNext": {
                    return this.hasNext ? Results.TRUE : Results.FALSE;
                }
                case "isOdd": 
                case "odd": {
                    return this.index % 2 == 0 ? Results.TRUE : Results.FALSE;
                }
                case "isEven": 
                case "even": {
                    return this.index % 2 != 0 ? Results.TRUE : Results.FALSE;
                }
            }
            return Results.NOT_FOUND;
        }
    }

    public static class Factory
    implements SectionHelperFactory<LoopSectionHelper> {
        public static final String HINT_ELEMENT = "<loop-element>";
        public static final String HINT_PREFIX = "<loop#";
        private static final String ALIAS = "alias";
        private static final String IN = "in";
        private static final String ITERABLE = "iterable";

        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of("for", "each");
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(ALIAS, "$empty$").addParameter(IN, "$empty$").addParameter(new Parameter(ITERABLE, null, true)).build();
        }

        @Override
        public LoopSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            return new LoopSectionHelper(context.getParameter(ALIAS), context.getExpression(ITERABLE));
        }

        @Override
        public Scope initializeBlock(Scope previousScope, SectionHelperFactory.BlockInfo block) {
            if (block.getLabel().equals("$main")) {
                String iterable = block.getParameters().get(ITERABLE);
                if (iterable == null) {
                    iterable = "this";
                }
                previousScope.setLastPartHint(HINT_ELEMENT);
                Expression iterableExpr = block.addExpression(ITERABLE, iterable);
                previousScope.setLastPartHint(null);
                String alias = block.getParameters().get(ALIAS);
                if (iterableExpr.hasTypeInfo()) {
                    alias = alias.equals("$empty$") ? LoopSectionHelper.DEFAULT_ALIAS : alias;
                    Scope newScope = new Scope(previousScope);
                    newScope.putBinding(alias, alias + HINT_PREFIX + iterableExpr.getGeneratedId() + ">");
                    return newScope;
                }
                Scope newScope = new Scope(previousScope);
                newScope.putBinding(alias, null);
                return newScope;
            }
            return previousScope;
        }
    }
}

