/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.logging.Logger;

public class RenderedResults
implements BiConsumer<TemplateInstance, String>,
Iterable<Map.Entry<String, List<RenderedResult>>> {
    private static final Logger LOG = Logger.getLogger(RenderedResults.class);
    private final ConcurrentMap<String, List<RenderedResult>> idToResults = new ConcurrentHashMap<String, List<RenderedResult>>();
    private final Function<TemplateInstance, String> idExtractor;
    private final AtomicReference<BiPredicate<TemplateInstance, RenderedResult>> filter;

    public RenderedResults() {
        this(new Function<TemplateInstance, String>(){

            @Override
            public String apply(TemplateInstance templateInstance) {
                try {
                    Template template = templateInstance.getTemplate();
                    if (template.isFragment()) {
                        return ((Template.Fragment)template).getOriginalTemplate().getId() + "$" + template.getId();
                    }
                    return templateInstance.getTemplate().getId();
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    public RenderedResults(Function<TemplateInstance, String> keyExtractor) {
        this.idExtractor = Objects.requireNonNull(keyExtractor);
        this.filter = new AtomicReference();
    }

    @Override
    public void accept(TemplateInstance templateInstance, String result) {
        String id = this.idExtractor.apply(templateInstance);
        if (id == null) {
            LOG.warnf("Unable to extract the id from the template instance: %s", (Object)templateInstance.toString());
            return;
        }
        List results = this.idToResults.computeIfAbsent(id, e -> Collections.synchronizedList(new ArrayList()));
        RenderedResult r = new RenderedResult(id, result, LocalDateTime.now());
        BiPredicate<TemplateInstance, RenderedResult> filter = this.filter.get();
        if (filter == null || filter.test(templateInstance, r)) {
            results.add(r);
        }
    }

    public List<RenderedResult> getResults(String templateId) {
        List results = (List)this.idToResults.get(templateId);
        if (results == null || results.isEmpty()) {
            return List.of();
        }
        return List.copyOf(results);
    }

    @Override
    public Iterator<Map.Entry<String, List<RenderedResult>>> iterator() {
        return this.idToResults.entrySet().stream().map(e -> Map.entry((String)e.getKey(), List.copyOf((Collection)e.getValue()))).iterator();
    }

    public void clear() {
        this.idToResults.clear();
    }

    public void remove(Predicate<RenderedResult> predicate) {
        this.idToResults.values().forEach(l -> l.removeIf(predicate));
    }

    public void setFilter(BiPredicate<TemplateInstance, RenderedResult> filter) {
        this.filter.set(filter);
    }

    public String toString() {
        return "RenderedResults [" + (String)(this.idToResults != null ? "idToResults=" + this.idToResults : "") + "]";
    }

    public record RenderedResult(String templateId, String result, LocalDateTime timestamp) {
    }
}

