/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.CompletionStageSupport;
import io.quarkus.qute.ErrorCode;
import io.quarkus.qute.ErrorInitializer;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Evaluator;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ExpressionImpl;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.Resolver;
import io.quarkus.qute.Results;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.WithPriority;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.jboss.logging.Logger;

class EvaluatorImpl
implements Evaluator {
    private static final Logger LOG = Logger.getLogger(EvaluatorImpl.class);
    private final List<ValueResolver> resolvers;
    private final Map<String, NamespaceResolver[]> namespaceResolvers;
    private final boolean strictRendering;
    private final ErrorInitializer initializer;

    EvaluatorImpl(List<ValueResolver> valueResolvers, List<NamespaceResolver> namespaceResolvers, boolean strictRendering, ErrorInitializer errorInitializer) {
        NamespaceResolver[] matching;
        this.resolvers = valueResolvers;
        HashMap<String, NamespaceResolver[]> namespaceResolversMap = new HashMap<String, NamespaceResolver[]>();
        for (NamespaceResolver namespaceResolver : namespaceResolvers) {
            matching = (NamespaceResolver[])namespaceResolversMap.get(namespaceResolver.getNamespace());
            if (matching == null) {
                matching = new NamespaceResolver[]{namespaceResolver};
            } else {
                int newLength = matching.length + 1;
                matching = Arrays.copyOf(matching, newLength);
                matching[newLength - 1] = namespaceResolver;
            }
            namespaceResolversMap.put(namespaceResolver.getNamespace(), matching);
        }
        for (Map.Entry entry : namespaceResolversMap.entrySet()) {
            matching = (NamespaceResolver[])entry.getValue();
            if (matching.length <= 1) continue;
            Arrays.sort(matching, Comparator.comparingInt(WithPriority::getPriority).reversed());
        }
        this.namespaceResolvers = namespaceResolversMap;
        this.strictRendering = strictRendering;
        this.initializer = errorInitializer;
    }

    @Override
    public CompletionStage<Object> evaluate(Expression expression, ResolutionContext resolutionContext) {
        if (expression.isLiteral()) {
            return expression.asLiteral();
        }
        if (expression.hasNamespace()) {
            NamespaceEvalContextImpl context;
            NamespaceResolver[] matching = this.namespaceResolvers.get(expression.getNamespace());
            if (matching == null) {
                return CompletedStage.failure(this.initializer.error("No namespace resolver found for [{namespace}] in expression \\{{expression}\\}").code(Code.NAMESPACE_RESOLVER_NOT_FOUND).argument("namespace", expression.getNamespace()).argument("expression", expression.toOriginalString()).origin(expression.getOrigin()).build());
            }
            List<Expression.Part> parts = expression.getParts();
            Expression.Part part = parts.get(0);
            NamespaceEvalContextImpl namespaceEvalContextImpl = context = part.isVirtualMethod() ? new NamespaceMethodEvalContextImpl(resolutionContext, part, part.asVirtualMethod().getParameters()) : new NamespaceEvalContextImpl(resolutionContext, part);
            if (matching.length == 1) {
                return matching[0].resolve(context).thenCompose(r -> parts.size() > 1 ? this.resolveReference(false, r, parts, resolutionContext, expression, 1) : CompletionStageSupport.toCompletionStage(r));
            }
            return this.resolveNamespace(context, resolutionContext, parts, matching, 0, expression);
        }
        return this.resolveReference(true, resolutionContext.getData(), expression.getParts(), resolutionContext, expression, 0);
    }

    @Override
    public boolean strictRendering() {
        return this.strictRendering;
    }

    private CompletionStage<Object> resolveNamespace(EvalContext context, ResolutionContext resolutionContext, List<Expression.Part> parts, NamespaceResolver[] resolvers, int resolverIndex, Expression expression) {
        NamespaceResolver resolver = resolvers[resolverIndex];
        return resolver.resolve(context).thenCompose(r -> {
            if (Results.isNotFound(r)) {
                int nextIdx = resolverIndex + 1;
                if (nextIdx < resolvers.length) {
                    return this.resolveNamespace(context, resolutionContext, parts, resolvers, nextIdx, expression);
                }
                if (parts.size() > 1) {
                    return this.resolveReference(false, r, parts, resolutionContext, expression, 1);
                }
                if (this.strictRendering) {
                    throw this.propertyNotFound(r, expression);
                }
                return Results.notFound(context);
            }
            if (parts.size() > 1) {
                return this.resolveReference(false, r, parts, resolutionContext, expression, 1);
            }
            return CompletionStageSupport.toCompletionStage(r);
        });
    }

    private CompletionStage<Object> resolveReference(boolean tryParent, Object ref, List<Expression.Part> parts, ResolutionContext resolutionContext, Expression expression, int partIndex) {
        EvalContextImpl evalContext;
        Expression.Part part = parts.get(partIndex);
        EvalContextImpl evalContextImpl = evalContext = tryParent ? new EvalContextImpl(ref, resolutionContext, part) : new TerminalEvalContextImpl(ref, resolutionContext, part);
        if (partIndex + 1 >= parts.size()) {
            return this.resolve(evalContext, null, true, expression, true, partIndex);
        }
        return this.resolve(evalContext, null, true, expression, false, partIndex).thenCompose(r -> this.resolveReference(false, r, parts, resolutionContext, expression, partIndex + 1));
    }

    private CompletionStage<Object> resolve(EvalContextImpl evalContext, Iterator<ValueResolver> resolvers, boolean tryCachedResolver, Expression expression, boolean isLastPart, int partIndex) {
        ValueResolver cached;
        if (tryCachedResolver && (cached = evalContext.getCachedResolver()) != null && cached.appliesTo(evalContext)) {
            return cached.resolve(evalContext).thenCompose(r -> {
                if (Results.isNotFound(r)) {
                    return this.resolve(evalContext, null, false, expression, isLastPart, partIndex);
                }
                return CompletionStageSupport.toCompletionStage(r);
            });
        }
        if (resolvers == null) {
            resolvers = this.resolvers.iterator();
        }
        Resolver applicableResolver = null;
        while (applicableResolver == null && resolvers.hasNext()) {
            ValueResolver next = resolvers.next();
            if (!next.appliesTo(evalContext)) continue;
            applicableResolver = next;
        }
        if (applicableResolver == null) {
            Object notFound;
            ResolutionContext parent = evalContext.resolutionContext.getParent();
            if (parent != null && evalContext.tryParent()) {
                return this.resolve(new EvalContextImpl(parent.getData(), parent, evalContext.part), null, false, expression, isLastPart, partIndex);
            }
            LOG.tracef("Unable to resolve %s", (Object)evalContext);
            if (Results.isNotFound(evalContext.getBase())) {
                notFound = evalContext.getBase();
            } else {
                Expression.Part nextPart = isLastPart ? null : expression.getParts().get(partIndex + 1);
                notFound = nextPart != null && nextPart.isVirtualMethod() && nextPart.asVirtualMethod().getParameters().size() == 1 && nextPart.getName().length() < 3 && (nextPart.getName().equals("?:") || nextPart.getName().equals("or") || nextPart.getName().equals(":")) ? Results.NotFound.EMPTY : Results.NotFound.from(evalContext);
            }
            if (this.strictRendering && isLastPart) {
                throw this.propertyNotFound(notFound, expression);
            }
            return CompletedStage.of(notFound);
        }
        Iterator<ValueResolver> remainingResolvers = resolvers;
        Resolver foundResolver = applicableResolver;
        return applicableResolver.resolve(evalContext).thenCompose(arg_0 -> this.lambda$resolve$4(evalContext, remainingResolvers, expression, isLastPart, partIndex, (ValueResolver)foundResolver, arg_0));
    }

    private TemplateException propertyNotFound(Object result, Expression expression) {
        String propertyMessage = result instanceof Results.NotFound ? ((Results.NotFound)result).asMessage() : "Property not found";
        return this.initializer.error("{prop} in expression \\{{expression}\\}").code(Code.PROPERTY_NOT_FOUND).origin(expression.getOrigin()).arguments(Map.of("prop", propertyMessage, "expression", expression.toOriginalString())).build();
    }

    private /* synthetic */ CompletionStage lambda$resolve$4(EvalContextImpl evalContext, Iterator remainingResolvers, Expression expression, boolean isLastPart, int partIndex, ValueResolver foundResolver, Object r) {
        if (Results.isNotFound(r)) {
            return this.resolve(evalContext, remainingResolvers, false, expression, isLastPart, partIndex);
        }
        evalContext.setCachedResolver(foundResolver.getCachedResolver(evalContext));
        return CompletionStageSupport.toCompletionStage(r);
    }

    static enum Code implements ErrorCode
    {
        PROPERTY_NOT_FOUND,
        NAMESPACE_RESOLVER_NOT_FOUND;


        @Override
        public String getName() {
            return "EVALUATOR_" + this.name();
        }
    }

    static class NamespaceMethodEvalContextImpl
    extends NamespaceEvalContextImpl {
        final List<Expression> params;

        NamespaceMethodEvalContextImpl(ResolutionContext resolutionContext, Expression.Part part, List<Expression> params) {
            super(resolutionContext, part);
            this.params = params;
        }

        @Override
        public List<Expression> getParams() {
            return this.params;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NamespaceMethodEvalContextImpl [name=").append(this.name).append(", params=").append(this.params).append("]");
            return builder.toString();
        }
    }

    static class NamespaceEvalContextImpl
    implements EvalContext {
        final ResolutionContext resolutionContext;
        final ExpressionImpl.PartImpl part;
        final String name;

        NamespaceEvalContextImpl(ResolutionContext resolutionContext, Expression.Part part) {
            this.resolutionContext = resolutionContext;
            this.part = (ExpressionImpl.PartImpl)part;
            this.name = part.getName();
        }

        @Override
        public Object getBase() {
            return null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<Expression> getParams() {
            return Collections.emptyList();
        }

        @Override
        public CompletionStage<Object> evaluate(String value) {
            return this.evaluate(ExpressionImpl.from(value));
        }

        @Override
        public CompletionStage<Object> evaluate(Expression expression) {
            return this.resolutionContext.evaluate(expression);
        }

        @Override
        public Object getAttribute(String key) {
            return this.resolutionContext.getAttribute(key);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NamespaceEvalContextImpl [name=").append(this.name).append("]");
            return builder.toString();
        }
    }

    static class EvalContextImpl
    implements EvalContext {
        final Object base;
        final ResolutionContext resolutionContext;
        final ExpressionImpl.PartImpl part;
        final List<Expression> params;
        final String name;

        EvalContextImpl(Object base, ResolutionContext resolutionContext, Expression.Part part) {
            this.base = base;
            this.resolutionContext = resolutionContext;
            this.part = (ExpressionImpl.PartImpl)part;
            this.name = part.getName();
            this.params = part.isVirtualMethod() ? part.asVirtualMethod().getParameters() : Collections.emptyList();
        }

        @Override
        public Object getBase() {
            return this.base;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<Expression> getParams() {
            return this.params;
        }

        @Override
        public CompletionStage<Object> evaluate(String value) {
            return this.evaluate(ExpressionImpl.from(value));
        }

        @Override
        public CompletionStage<Object> evaluate(Expression expression) {
            return this.resolutionContext.evaluate(expression);
        }

        @Override
        public Object getAttribute(String key) {
            return this.resolutionContext.getAttribute(key);
        }

        ValueResolver getCachedResolver() {
            return this.part.cachedResolver;
        }

        void setCachedResolver(ValueResolver valueResolver) {
            this.part.cachedResolver = valueResolver;
        }

        boolean tryParent() {
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("EvalContextImpl [base=").append(this.base).append(", name=").append(this.name).append(", params=").append(this.params).append("]");
            return builder.toString();
        }
    }

    static class TerminalEvalContextImpl
    extends EvalContextImpl {
        TerminalEvalContextImpl(Object base, ResolutionContext resolutionContext, Expression.Part part) {
            super(base, resolutionContext, part);
        }

        @Override
        boolean tryParent() {
            return false;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TerminalEvalContextImpl [base=").append(this.base).append(", name=").append(this.name).append(", params=").append(this.params).append("]");
            return builder.toString();
        }
    }
}

