/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive;

import java.io.File;

public class FilePart {
    public final File file;
    public final long offset;
    public final long count;

    public FilePart(File file, long offset, long count) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist: " + file);
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("File is not a regular file: " + file);
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("File cannot be read: " + file);
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset (" + offset + ") must be >= 0: " + file);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("Count (" + count + ") must be >= 0: " + file);
        }
        if (offset + count > file.length()) {
            throw new IllegalArgumentException("Offset + count (" + (offset + count) + ") larger than file size (" + file.length() + "): " + file);
        }
        this.file = file;
        this.offset = offset;
        this.count = count;
    }
}

