/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import jakarta.ws.rs.NotAcceptableException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.reactive.common.headers.MediaTypeHeaderDelegate;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.jaxrs.ProvidersImpl;
import org.jboss.resteasy.reactive.server.jaxrs.ResponseBuilderImpl;
import org.jboss.resteasy.reactive.server.mapping.RequestMapper;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class ClassRoutingHandler
implements ServerRestHandler {
    private static final String INVALID_ACCEPT_HEADER_MESSAGE = "The accept header value did not match the value in @Produces";
    private final Map<String, RequestMapper<RuntimeResource>> mappers;
    private final int parameterOffset;

    public ClassRoutingHandler(Map<String, RequestMapper<RuntimeResource>> mappers, int parameterOffset) {
        this.mappers = mappers;
        this.parameterOffset = parameterOffset;
    }

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        String pathParamValue;
        String contentType;
        String remaining;
        RequestMapper.RequestMatch<RuntimeResource> target;
        RequestMapper<RuntimeResource> mapper = this.mappers.get(requestContext.getMethod());
        if (mapper == null) {
            String requestMethod = requestContext.getMethod();
            if (requestMethod.equals("HEAD")) {
                mapper = this.mappers.get("GET");
            } else if (requestMethod.equals("OPTIONS")) {
                HashSet<String> allowedMethods = new HashSet<String>();
                for (String method : this.mappers.keySet()) {
                    if (method == null) continue;
                    allowedMethods.add(method);
                }
                allowedMethods.add("OPTIONS");
                allowedMethods.add("HEAD");
                requestContext.abortWith(Response.ok().allow(allowedMethods).build());
                return;
            }
            if (mapper == null) {
                mapper = this.mappers.get(null);
            }
            if (mapper == null) {
                String remaining2 = this.getRemaining(requestContext);
                for (RequestMapper<RuntimeResource> existingMapper : this.mappers.values()) {
                    if (existingMapper.map(remaining2) == null) continue;
                    throw new NotAllowedException(new ResponseBuilderImpl().status(Response.Status.METHOD_NOT_ALLOWED).build());
                }
                this.throwNotFound(requestContext);
                return;
            }
        }
        if ((target = mapper.map(remaining = this.getRemaining(requestContext))) == null) {
            if (requestContext.getMethod().equals("HEAD") && (mapper = this.mappers.get("GET")) != null) {
                target = mapper.map(remaining);
            }
            if (target == null) {
                for (Map.Entry<String, RequestMapper<RuntimeResource>> entry : this.mappers.entrySet()) {
                    if (entry.getKey() == null || entry.getKey().equals(requestContext.getMethod()) || entry.getValue().map(remaining) == null) continue;
                    throw new NotAllowedException(new ResponseBuilderImpl().status(Response.Status.METHOD_NOT_ALLOWED).build());
                }
                this.throwNotFound(requestContext);
                return;
            }
        }
        if (!((RuntimeResource)target.value).getConsumes().isEmpty() && (contentType = (String)requestContext.getHeader("Content-Type", true)) != null) {
            try {
                if (MediaTypeHelper.getFirstMatch(((RuntimeResource)target.value).getConsumes(), Collections.singletonList(MediaType.valueOf((String)contentType))) == null) {
                    throw new NotSupportedException("The content-type header value did not match the value in @Consumes");
                }
            }
            catch (IllegalArgumentException e) {
                throw new NotSupportedException("The content-type header value did not correspond to a valid media type");
            }
        }
        if (((RuntimeResource)target.value).getProduces() != null) {
            List accepts = (List)requestContext.getHeader("Accept", false);
            if (!accepts.isEmpty()) {
                boolean hasAtLeastOneMatch = false;
                for (int i = 0; i < accepts.size(); ++i) {
                    try {
                        boolean matches = this.acceptHeaderMatches(target, (String)accepts.get(i));
                        if (!matches) continue;
                        hasAtLeastOneMatch = true;
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (!hasAtLeastOneMatch) {
                    throw new NotAcceptableException(INVALID_ACCEPT_HEADER_MESSAGE);
                }
            }
            requestContext.setProducesChecked(true);
        }
        requestContext.restart((RuntimeResource)target.value);
        requestContext.setRemaining(target.remaining);
        for (int i = 0; i < target.pathParamValues.length && (pathParamValue = target.pathParamValues[i]) != null; ++i) {
            requestContext.setPathParamValue(i + this.parameterOffset, pathParamValue);
        }
    }

    private boolean acceptHeaderMatches(RequestMapper.RequestMatch<RuntimeResource> target, String accepts) {
        if (accepts != null && !accepts.equals("*/*")) {
            List<MediaType> acceptsMediaTypes;
            int commaIndex = accepts.indexOf(44);
            boolean multipleAcceptsValues = commaIndex >= 0;
            MediaType[] producesMediaTypes = ((RuntimeResource)target.value).getProduces().getSortedOriginalMediaTypes();
            if (!multipleAcceptsValues && producesMediaTypes.length == 1) {
                MediaType providedMediaType = producesMediaTypes[0];
                return providedMediaType.isCompatible(this.toMediaType(accepts.trim()));
            }
            if (multipleAcceptsValues && producesMediaTypes.length == 1) {
                boolean compatible = false;
                int begin = 0;
                while (true) {
                    String acceptPart;
                    if (producesMediaTypes[0].isCompatible(this.toMediaType((acceptPart = commaIndex == -1 ? accepts.substring(begin) : accepts.substring(begin, commaIndex)).trim()))) {
                        compatible = true;
                        break;
                    }
                    if (commaIndex == -1 || (begin = commaIndex + 1) >= accepts.length() - 1) break;
                    commaIndex = accepts.indexOf(44, begin);
                }
                return compatible;
            }
            if (accepts.contains(",")) {
                String[] parts = accepts.split(",");
                acceptsMediaTypes = new ArrayList<MediaType>(parts.length);
                for (int i = 0; i < parts.length; ++i) {
                    String part = parts[i];
                    acceptsMediaTypes.add(this.toMediaType(part.trim()));
                }
            } else {
                acceptsMediaTypes = Collections.singletonList(this.toMediaType(accepts));
            }
            return MediaTypeHelper.getFirstMatch(Arrays.asList(producesMediaTypes), acceptsMediaTypes) != null;
        }
        return true;
    }

    private MediaType toMediaType(String mediaTypeStr) {
        return MediaTypeHeaderDelegate.parse((String)mediaTypeStr);
    }

    private void throwNotFound(ResteasyReactiveRequestContext requestContext) {
        ProvidersImpl providers = requestContext.getProviders();
        ExceptionMapper<NotFoundException> exceptionMapper = providers.getExceptionMapper(NotFoundException.class);
        if (exceptionMapper == null && requestContext.resumeExternalProcessing()) {
            return;
        }
        requestContext.requireCDIRequestScope();
        throw new NotFoundException("Unable to find matching target resource method");
    }

    private String getRemaining(ResteasyReactiveRequestContext requestContext) {
        return requestContext.getRemaining().isEmpty() ? "/" : requestContext.getRemaining();
    }

    public Map<String, RequestMapper<RuntimeResource>> getMappers() {
        return this.mappers;
    }
}

