/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.r2dbc.mssql.ErrorDetails;
import io.r2dbc.mssql.ExceptionFactory;
import io.r2dbc.mssql.MssqlResult;
import io.r2dbc.mssql.MssqlReturnValues;
import io.r2dbc.mssql.MssqlRow;
import io.r2dbc.mssql.MssqlRowMetadata;
import io.r2dbc.mssql.client.ConnectionContext;
import io.r2dbc.mssql.codec.Codecs;
import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.message.token.AbstractDoneToken;
import io.r2dbc.mssql.message.token.AbstractInfoToken;
import io.r2dbc.mssql.message.token.ColumnMetadataToken;
import io.r2dbc.mssql.message.token.ErrorToken;
import io.r2dbc.mssql.message.token.NbcRowToken;
import io.r2dbc.mssql.message.token.ReturnValue;
import io.r2dbc.mssql.message.token.RowToken;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.OutParameters;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

final class MssqlSegmentResult
implements MssqlResult {
    private static final Logger LOGGER = Loggers.getLogger(MssqlSegmentResult.class);
    public static final boolean DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private final String sql;
    private final ConnectionContext context;
    private final Codecs codecs;
    private final Flux<Result.Segment> segments;

    private MssqlSegmentResult(String sql, ConnectionContext context, Codecs codecs, Flux<Result.Segment> segments) {
        this.sql = sql;
        this.context = context;
        this.codecs = codecs;
        this.segments = segments;
    }

    static MssqlSegmentResult toResult(String sql, ConnectionContext context, Codecs codecs, Flux<Message> messages, boolean expectReturnValues) {
        Assert.requireNonNull(sql, "SQL must not be null");
        Assert.requireNonNull(codecs, "Codecs must not be null");
        Assert.requireNonNull(context, "ConnectionContext must not be null");
        Assert.requireNonNull(messages, "Messages must not be null");
        LOGGER.debug(context.getMessage("Creating new result"));
        return new MssqlSegmentResult(sql, context, codecs, MssqlSegmentResult.toSegments(sql, codecs, messages, expectReturnValues));
    }

    private static Flux<Result.Segment> toSegments(String sql, Codecs codecs, Flux<Message> messages, boolean expectReturnValues) {
        Flux returnValueStream = Flux.empty();
        Flux messageStream = messages;
        if (expectReturnValues) {
            ArrayList returnValues = new ArrayList();
            messageStream = messageStream.doOnNext(message -> {
                if (message instanceof ReturnValue) {
                    returnValues.add((ReturnValue)message);
                }
            }).filter(it -> !(it instanceof ReturnValue));
            returnValueStream = Flux.defer(() -> {
                if (returnValues.size() != 0) {
                    return Flux.just((Object)((Object)new MsqlOutSegment(codecs, returnValues)));
                }
                return Flux.empty();
            });
        }
        AtomicReference metadataRef = new AtomicReference();
        Flux segments = messageStream.handle((message, sink) -> {
            AbstractDoneToken doneToken;
            if (message instanceof AbstractDoneToken && (doneToken = (AbstractDoneToken)message).isAttentionAck()) {
                sink.error((Throwable)((Object)new ExceptionFactory.MssqlStatementCancelled(sql)));
                return;
            }
            if (message.getClass() == ColumnMetadataToken.class) {
                ColumnMetadataToken token = (ColumnMetadataToken)message;
                if (token.hasColumns()) {
                    metadataRef.set(MssqlRowMetadata.create(codecs, token));
                }
                return;
            }
            if (message.getClass() == RowToken.class || message.getClass() == NbcRowToken.class) {
                MssqlRowMetadata rowMetadata = (MssqlRowMetadata)metadataRef.get();
                if (rowMetadata == null) {
                    return;
                }
                sink.next((Object)new MssqlRowSegment(codecs, (RowToken)message, rowMetadata));
                return;
            }
            if (message instanceof AbstractInfoToken) {
                sink.next((Object)MssqlSegmentResult.createMessage(sql, (AbstractInfoToken)message));
                return;
            }
            if (message instanceof AbstractDoneToken && (doneToken = (AbstractDoneToken)message).hasCount()) {
                sink.next((Object)doneToken);
            }
            ReferenceCountUtil.release((Object)message);
        });
        if (expectReturnValues) {
            segments = segments.concatWith((Publisher)returnValueStream);
        }
        return segments;
    }

    @Override
    public Mono<Integer> getRowsUpdated() {
        return this.segments.handle((segment, sink) -> {
            if (segment instanceof Result.UpdateCount) {
                Result.UpdateCount updateCount = (Result.UpdateCount)segment;
                if (DEBUG_ENABLED) {
                    LOGGER.debug(this.context.getMessage("Incoming row count: {}"), new Object[]{updateCount});
                }
                sink.next((Object)updateCount.value());
            }
            if (this.isError((Result.Segment)segment)) {
                sink.error((Throwable)((Result.Message)segment).exception());
                return;
            }
            ReferenceCountUtil.release((Object)segment);
        }).reduce(Long::sum).map(Long::intValue);
    }

    @Override
    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> mappingFunction) {
        Assert.requireNonNull(mappingFunction, "Mapping function must not be null");
        return this.doMap(true, false, readable -> {
            Row row = (Row)readable;
            return mappingFunction.apply(row, row.getMetadata());
        });
    }

    public <T> Flux<T> map(Function<? super Readable, ? extends T> mappingFunction) {
        Assert.requireNonNull(mappingFunction, "Mapping function must not be null");
        return this.doMap(true, true, mappingFunction);
    }

    private <T> Flux<T> doMap(boolean rows, boolean outparameters, Function<? super Readable, ? extends T> mappingFunction) {
        return this.segments.handle((segment, sink) -> {
            if (rows && segment instanceof Result.RowSegment) {
                Result.RowSegment data = (Result.RowSegment)segment;
                Row row = data.row();
                try {
                    sink.next(mappingFunction.apply((Readable)row));
                }
                finally {
                    ReferenceCountUtil.release((Object)data);
                }
                return;
            }
            if (outparameters && segment instanceof Result.OutSegment) {
                Result.OutSegment data = (Result.OutSegment)segment;
                OutParameters outParameters = data.outParameters();
                try {
                    sink.next(mappingFunction.apply((Readable)outParameters));
                }
                finally {
                    ReferenceCountUtil.release((Object)data);
                }
                return;
            }
            if (this.isError((Result.Segment)segment)) {
                sink.error((Throwable)((Result.Message)segment).exception());
                return;
            }
            ReferenceCountUtil.release((Object)segment);
        });
    }

    @Override
    public MssqlResult filter(Predicate<Result.Segment> filter) {
        Assert.requireNonNull(filter, "filter must not be null");
        Flux filteredSegments = this.segments.filter(message -> {
            if (filter.test((Result.Segment)message)) {
                return true;
            }
            ReferenceCountUtil.release((Object)message);
            return false;
        });
        return new MssqlSegmentResult(this.sql, this.context, this.codecs, (Flux<Result.Segment>)filteredSegments);
    }

    @Override
    public <T> Flux<T> flatMap(Function<Result.Segment, ? extends Publisher<? extends T>> mappingFunction) {
        Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
        return this.segments.concatMap(segment -> {
            Publisher result = (Publisher)mappingFunction.apply((Result.Segment)segment);
            if (result == null) {
                return Mono.error((Throwable)new IllegalStateException("The mapper returned a null Publisher"));
            }
            if (result instanceof Mono) {
                return ((Mono)result).doFinally(s -> ReferenceCountUtil.release((Object)segment));
            }
            return Flux.from((Publisher)result).doFinally(s -> ReferenceCountUtil.release((Object)segment));
        });
    }

    private boolean isError(Result.Segment segment) {
        return segment instanceof MssqlMessage && ((MssqlMessage)segment).isError();
    }

    private static Result.Message createMessage(String sql, AbstractInfoToken message) {
        ErrorDetails errorDetails = ExceptionFactory.createErrorDetails(message);
        return new MssqlMessage(message, sql, errorDetails);
    }

    private static class MsqlOutSegment
    extends AbstractReferenceCounted
    implements Result.OutSegment {
        private final MssqlReturnValues returnValues;

        public MsqlOutSegment(Codecs codecs, List<ReturnValue> returnValues) {
            this.returnValues = MssqlReturnValues.toReturnValues(codecs, returnValues);
        }

        public OutParameters outParameters() {
            return this.returnValues;
        }

        public ReferenceCounted touch(Object hint) {
            return this;
        }

        protected void deallocate() {
            this.returnValues.release();
        }
    }

    private static class MssqlRowSegment
    extends AbstractReferenceCounted
    implements Result.RowSegment {
        private final RowToken rowToken;
        private final MssqlRow row;

        public MssqlRowSegment(Codecs codecs, RowToken rowToken, MssqlRowMetadata rowMetadata) {
            this.rowToken = rowToken;
            this.row = MssqlRow.toRow(codecs, this.rowToken, rowMetadata);
        }

        public Row row() {
            return this.row;
        }

        public ReferenceCounted touch(Object hint) {
            return this;
        }

        protected void deallocate() {
            this.rowToken.release();
        }
    }

    static class MssqlMessage
    implements Result.Message {
        private final ErrorDetails errorDetails;
        private final AbstractInfoToken message;
        private final String sql;

        public MssqlMessage(AbstractInfoToken message, String sql, ErrorDetails errorDetails) {
            this.message = message;
            this.sql = sql;
            this.errorDetails = errorDetails;
        }

        public R2dbcException exception() {
            return ExceptionFactory.createException(this.message, this.sql);
        }

        public int errorCode() {
            return (int)this.errorDetails.getNumber();
        }

        public String sqlState() {
            return this.errorDetails.getStateCode();
        }

        public String message() {
            return this.errorDetails.getMessage();
        }

        public boolean isError() {
            return this.message instanceof ErrorToken;
        }
    }
}

