/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.TransactionDescriptor;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.util.Assert;
import java.util.Arrays;
import java.util.Objects;

public final class AllHeaders {
    private final byte[] transactionDescriptor;
    private final int outstandingRequestCount;
    private final int length;

    private AllHeaders(byte[] transactionDescriptor, int outstandingRequestCount) {
        this.transactionDescriptor = transactionDescriptor;
        this.outstandingRequestCount = outstandingRequestCount;
        int totalLength = 4;
        this.length = totalLength += transactionDescriptor.length + 4 + 4 + 2;
    }

    public static AllHeaders transactional(TransactionDescriptor transactionDescriptor, int outstandingRequests) {
        Assert.requireNonNull(transactionDescriptor, "Transaction descriptor must not be null");
        return AllHeaders.transactional(transactionDescriptor.toBytes(), outstandingRequests);
    }

    public static AllHeaders transactional(byte[] transactionDescriptor, int outstandingRequests) {
        Assert.requireNonNull(transactionDescriptor, "Transaction descriptor must not be null");
        return new AllHeaders(transactionDescriptor, outstandingRequests);
    }

    public void encode(ByteBuf buffer) {
        Encode.dword(buffer, this.length);
        Encode.dword(buffer, this.transactionDescriptor.length + 4 + 6);
        Encode.uShort(buffer, 2);
        buffer.writeBytes(this.transactionDescriptor);
        Encode.dword(buffer, this.outstandingRequestCount);
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AllHeaders)) {
            return false;
        }
        AllHeaders that = (AllHeaders)o;
        return this.outstandingRequestCount == that.outstandingRequestCount && this.length == that.length && Arrays.equals(this.transactionDescriptor, that.transactionDescriptor);
    }

    public int hashCode() {
        int result = Objects.hash(this.outstandingRequestCount, this.length);
        result = 31 * result + Arrays.hashCode(this.transactionDescriptor);
        return result;
    }
}

