/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.type;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.tds.ProtocolException;
import io.r2dbc.mssql.message.tds.ServerCharset;
import io.r2dbc.mssql.message.type.AbstractTypeDecoderStrategy;
import io.r2dbc.mssql.message.type.Collation;
import io.r2dbc.mssql.message.type.LengthStrategy;
import io.r2dbc.mssql.message.type.MutableTypeInformation;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TdsDataType;
import io.r2dbc.mssql.message.type.TypeDecoderStrategies;
import io.r2dbc.mssql.message.type.TypeDecoderStrategy;
import io.r2dbc.mssql.message.type.TypeInformation;
import io.r2dbc.mssql.util.Assert;
import java.util.EnumMap;
import java.util.Map;

enum TypeBuilder {
    BIT(TdsDataType.BIT1, TypeDecoderStrategies.create(SqlServerType.BIT, 1, 1, "1".length(), 0)),
    BIGINT(TdsDataType.INT8, TypeDecoderStrategies.create(SqlServerType.BIGINT, 8, Long.toString(Long.MAX_VALUE).length(), "-9223372036854775807".length(), 0)),
    INTEGER(TdsDataType.INT4, TypeDecoderStrategies.create(SqlServerType.INTEGER, 4, Integer.toString(Integer.MAX_VALUE).length(), "-2147483647".length(), 0)),
    SMALLINT(TdsDataType.INT2, TypeDecoderStrategies.create(SqlServerType.SMALLINT, 2, Short.toString((short)Short.MAX_VALUE).length(), "-32767".length(), 0)),
    TINYINT(TdsDataType.INT1, TypeDecoderStrategies.create(SqlServerType.TINYINT, 1, Byte.toString((byte)127).length(), Byte.toString((byte)127).length(), 0)),
    REAL(TdsDataType.FLOAT4, TypeDecoderStrategies.create(SqlServerType.REAL, 4, 7, 13, 0)),
    FLOAT(TdsDataType.FLOAT8, TypeDecoderStrategies.create(SqlServerType.FLOAT, 8, 15, 22, 0)),
    SMALLDATETIME(TdsDataType.DATETIME4, TypeDecoderStrategies.create(SqlServerType.SMALLDATETIME, 4, "yyyy-mm-dd hh:mm".length(), "yyyy-mm-dd hh:mm".length(), 0)),
    DATETIME(TdsDataType.DATETIME8, TypeDecoderStrategies.create(SqlServerType.DATETIME, 8, "yyyy-mm-dd hh:mm:ss.fff".length(), "yyyy-mm-dd hh:mm:ss.fff".length(), 3)),
    SMALLMONEY(TdsDataType.MONEY4, TypeDecoderStrategies.create(SqlServerType.SMALLMONEY, 4, Integer.toString(Integer.MAX_VALUE).length(), "-.2147483647".length(), 4)),
    MONEY(TdsDataType.MONEY8, TypeDecoderStrategies.create(SqlServerType.MONEY, 8, Long.toString(Long.MAX_VALUE).length(), "-.9223372036854775807".length(), 4)),
    BITN(TdsDataType.BITN, new AbstractTypeDecoderStrategy(1){

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            if (1 != Decode.uByte(buffer)) {
                throw ProtocolException.invalidTds("Invalid mutability for BITN");
            }
            BIT.build(typeInfo, buffer);
            typeInfo.lengthStrategy = LengthStrategy.BYTELENTYPE;
        }
    }),
    INTN(TdsDataType.INTN, new AbstractTypeDecoderStrategy(1){

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            int intType = Decode.uByte(buffer);
            switch (intType) {
                case 8: {
                    BIGINT.build(typeInfo, buffer);
                    break;
                }
                case 4: {
                    INTEGER.build(typeInfo, buffer);
                    break;
                }
                case 2: {
                    SMALLINT.build(typeInfo, buffer);
                    break;
                }
                case 1: {
                    TINYINT.build(typeInfo, buffer);
                    break;
                }
                default: {
                    throw ProtocolException.invalidTds(String.format("Unsupported INTN type %s", intType));
                }
            }
            typeInfo.lengthStrategy = LengthStrategy.BYTELENTYPE;
        }
    }),
    DECIMAL(TdsDataType.DECIMALN, TypeDecoderStrategies.decimalNumeric(SqlServerType.DECIMAL)),
    NUMERIC(TdsDataType.NUMERICN, TypeDecoderStrategies.decimalNumeric(SqlServerType.NUMERIC)),
    FLOATN(TdsDataType.FLOATN, TypeDecoderStrategies.bigOrSmall(FLOAT, REAL)),
    MONEYN(TdsDataType.MONEYN, TypeDecoderStrategies.bigOrSmall(MONEY, SMALLMONEY)),
    DATETIMEN(TdsDataType.DATETIMEN, TypeDecoderStrategies.bigOrSmall(DATETIME, SMALLDATETIME)),
    TIME(TdsDataType.TIMEN, TypeDecoderStrategies.temporal(SqlServerType.TIME)),
    DATETIME2(TdsDataType.DATETIME2N, TypeDecoderStrategies.temporal(SqlServerType.DATETIME2)),
    DATETIMEOFFSET(TdsDataType.DATETIMEOFFSETN, TypeDecoderStrategies.temporal(SqlServerType.DATETIMEOFFSET)),
    DATE(TdsDataType.DATEN, new AbstractTypeDecoderStrategy(0){

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            typeInfo.serverType = SqlServerType.DATE;
            typeInfo.lengthStrategy = LengthStrategy.BYTELENTYPE;
            typeInfo.maxLength = 3;
            typeInfo.displaySize = typeInfo.precision = "yyyy-mm-dd".length();
        }
    }),
    BIGBINARY(TdsDataType.BIGBINARY, new AbstractTypeDecoderStrategy(2){

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            typeInfo.lengthStrategy = LengthStrategy.USHORTLENTYPE;
            typeInfo.maxLength = Decode.uShort(buffer);
            if (typeInfo.maxLength > 8000) {
                throw ProtocolException.invalidTds("Max length exceeds short VARBINARY/VARCHAR type");
            }
            typeInfo.precision = typeInfo.maxLength;
            typeInfo.displaySize = 2 * typeInfo.maxLength;
            typeInfo.serverType = 80 == typeInfo.userType ? SqlServerType.TIMESTAMP : SqlServerType.BINARY;
        }
    }),
    BIGVARBINARY(TdsDataType.BIGVARBINARY, new AbstractTypeDecoderStrategy(2){

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            typeInfo.maxLength = Decode.uShort(buffer);
            if (65535 == typeInfo.maxLength) {
                typeInfo.lengthStrategy = LengthStrategy.PARTLENTYPE;
                typeInfo.serverType = SqlServerType.VARBINARYMAX;
                typeInfo.precision = Integer.MAX_VALUE;
                typeInfo.displaySize = Integer.MAX_VALUE;
            } else if (typeInfo.maxLength <= 8000) {
                typeInfo.lengthStrategy = LengthStrategy.USHORTLENTYPE;
                typeInfo.serverType = SqlServerType.VARBINARY;
                typeInfo.precision = typeInfo.maxLength;
                typeInfo.displaySize = 2 * typeInfo.maxLength;
            } else {
                throw ProtocolException.invalidTds("Cannot parse BIGVARBINARY type info");
            }
        }
    }),
    IMAGE(TdsDataType.IMAGE, new AbstractTypeDecoderStrategy(4){

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            typeInfo.lengthStrategy = LengthStrategy.LONGLENTYPE;
            typeInfo.maxLength = Decode.asLong(buffer);
            if (typeInfo.maxLength < 0) {
                throw ProtocolException.invalidTds("Negative IMAGE type length");
            }
            typeInfo.serverType = SqlServerType.IMAGE;
            typeInfo.precision = Integer.MAX_VALUE;
            typeInfo.displaySize = Integer.MAX_VALUE;
        }
    }),
    BIGCHAR(TdsDataType.BIGCHAR, new AbstractTypeDecoderStrategy(7){

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            typeInfo.lengthStrategy = LengthStrategy.USHORTLENTYPE;
            typeInfo.maxLength = Decode.uShort(buffer);
            if (typeInfo.maxLength > 8000) {
                throw ProtocolException.invalidTds(String.format("BIGCHAR max length exceeded: %d", typeInfo.maxLength));
            }
            typeInfo.displaySize = typeInfo.precision = typeInfo.maxLength;
            typeInfo.serverType = SqlServerType.CHAR;
            typeInfo.collation = Collation.decode(buffer);
            typeInfo.charset = typeInfo.collation.getCharset();
        }
    }),
    BIGVARCHAR(TdsDataType.BIGVARCHAR, new AbstractTypeDecoderStrategy(7){

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            typeInfo.maxLength = Decode.uShort(buffer);
            if (65535 == typeInfo.maxLength) {
                typeInfo.lengthStrategy = LengthStrategy.PARTLENTYPE;
                typeInfo.serverType = SqlServerType.VARCHARMAX;
                typeInfo.precision = Integer.MAX_VALUE;
                typeInfo.displaySize = Integer.MAX_VALUE;
            } else if (typeInfo.maxLength <= 8000) {
                typeInfo.lengthStrategy = LengthStrategy.USHORTLENTYPE;
                typeInfo.serverType = SqlServerType.VARCHAR;
                typeInfo.displaySize = typeInfo.precision = typeInfo.maxLength;
            } else {
                throw ProtocolException.invalidTds("Cannot parse BIGVARCHAR type info");
            }
            typeInfo.collation = Collation.decode(buffer);
            typeInfo.charset = typeInfo.collation.getCharset();
        }
    }),
    TEXT(TdsDataType.TEXT, new AbstractTypeDecoderStrategy(9){

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            typeInfo.lengthStrategy = LengthStrategy.LONGLENTYPE;
            typeInfo.maxLength = Decode.asLong(buffer);
            if (typeInfo.maxLength < 0) {
                throw ProtocolException.invalidTds("Negative TEXT type length");
            }
            typeInfo.serverType = SqlServerType.TEXT;
            typeInfo.precision = Integer.MAX_VALUE;
            typeInfo.displaySize = Integer.MAX_VALUE;
            typeInfo.collation = Collation.decode(buffer);
            typeInfo.charset = typeInfo.collation.getCharset();
        }
    }),
    NCHAR(TdsDataType.NCHAR, new AbstractTypeDecoderStrategy(7){

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            typeInfo.lengthStrategy = LengthStrategy.USHORTLENTYPE;
            typeInfo.maxLength = Decode.uShort(buffer);
            if (typeInfo.maxLength > 8000 || 0 != typeInfo.maxLength % 2) {
                throw ProtocolException.invalidTds("Invalid NCHAR length");
            }
            typeInfo.displaySize = typeInfo.precision = typeInfo.maxLength / 2;
            typeInfo.serverType = SqlServerType.NCHAR;
            typeInfo.collation = Collation.decode(buffer);
            typeInfo.charset = ServerCharset.UNICODE.charset();
        }
    }),
    NVARCHAR(TdsDataType.NVARCHAR, new AbstractTypeDecoderStrategy(7){

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            typeInfo.maxLength = Decode.uShort(buffer);
            if (65535 == typeInfo.maxLength) {
                typeInfo.lengthStrategy = LengthStrategy.PARTLENTYPE;
                typeInfo.serverType = SqlServerType.NVARCHARMAX;
                typeInfo.precision = 0x3FFFFFFF;
                typeInfo.displaySize = 0x3FFFFFFF;
            } else if (typeInfo.maxLength <= 8000 && 0 == typeInfo.maxLength % 2) {
                typeInfo.lengthStrategy = LengthStrategy.USHORTLENTYPE;
                typeInfo.serverType = SqlServerType.NVARCHAR;
                typeInfo.displaySize = typeInfo.precision = typeInfo.maxLength / 2;
            } else {
                throw ProtocolException.invalidTds("Invalid NVARCHAR length");
            }
            typeInfo.collation = Collation.decode(buffer);
            typeInfo.charset = ServerCharset.UNICODE.charset();
        }
    }),
    NTEXT(TdsDataType.NTEXT, new AbstractTypeDecoderStrategy(9){

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            typeInfo.lengthStrategy = LengthStrategy.LONGLENTYPE;
            typeInfo.maxLength = Decode.asLong(buffer);
            if (typeInfo.maxLength < 0) {
                throw ProtocolException.invalidTds("Negative TEXT type length");
            }
            typeInfo.serverType = SqlServerType.NTEXT;
            typeInfo.precision = 0x3FFFFFFF;
            typeInfo.displaySize = 0x3FFFFFFF;
            typeInfo.collation = Collation.decode(buffer);
            typeInfo.charset = ServerCharset.UNICODE.charset();
        }
    }),
    GUID(TdsDataType.GUID, new AbstractTypeDecoderStrategy(1){

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            int maxLength = Decode.uByte(buffer);
            if (maxLength != 16 && maxLength != 0) {
                throw ProtocolException.invalidTds("Negative GUID type length");
            }
            typeInfo.lengthStrategy = LengthStrategy.BYTELENTYPE;
            typeInfo.serverType = SqlServerType.GUID;
            typeInfo.maxLength = maxLength;
            typeInfo.displaySize = 36;
            typeInfo.precision = 36;
        }
    }),
    SQL_VARIANT(TdsDataType.SQL_VARIANT, new AbstractTypeDecoderStrategy(4){

        @Override
        public void decode(MutableTypeInformation typeInfo, ByteBuf buffer) {
            typeInfo.lengthStrategy = LengthStrategy.LONGLENTYPE;
            typeInfo.maxLength = Decode.asLong(buffer);
            typeInfo.serverType = SqlServerType.SQL_VARIANT;
        }
    });

    private final TdsDataType tdsType;
    private final TypeDecoderStrategy strategy;
    private static final Map<TdsDataType, TypeBuilder> builderMap;

    private TypeBuilder(TdsDataType tdsType, TypeDecoderStrategy strategy) {
        this.tdsType = tdsType;
        this.strategy = strategy;
    }

    static TypeInformation decode(ByteBuf buffer, boolean readFlags) {
        TdsDataType tdsType;
        TypeBuilder typeBuilder;
        MutableTypeInformation typeInfo = new MutableTypeInformation();
        typeInfo.userType = Decode.intBigEndian(buffer);
        if (readFlags) {
            typeInfo.flags = Decode.uShort(buffer);
        }
        if ((typeBuilder = builderMap.get((Object)(tdsType = TdsDataType.valueOf(Decode.uByte(buffer))))) == null) {
            throw new IllegalStateException("TypeBuilder for " + (Object)((Object)tdsType) + " not available");
        }
        return typeBuilder.build(typeInfo, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean canDecode(ByteBuf buffer, boolean readFlags) {
        int length = 4 + (readFlags ? 2 : 0);
        int readerIndex = buffer.readerIndex();
        try {
            if (buffer.readableBytes() >= length + 1) {
                buffer.skipBytes(length);
                TdsDataType tdsType = TdsDataType.valueOf(Decode.uByte(buffer));
                TypeBuilder typeBuilder = builderMap.get((Object)tdsType);
                boolean bl = typeBuilder.strategy.canDecode(buffer);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            buffer.readerIndex(readerIndex);
        }
    }

    TdsDataType getTdsDataType() {
        return this.tdsType;
    }

    MutableTypeInformation build(MutableTypeInformation typeInfo, ByteBuf buffer) throws ProtocolException {
        this.strategy.decode(typeInfo, buffer);
        Assert.state(typeInfo.serverType != null, "Server type must not be null");
        Assert.state(typeInfo.lengthStrategy != null, "Length type must not be null");
        return typeInfo;
    }

    static {
        builderMap = new EnumMap<TdsDataType, TypeBuilder>(TdsDataType.class);
        for (TypeBuilder builder : TypeBuilder.values()) {
            builderMap.put(builder.getTdsDataType(), builder);
        }
    }
}

