/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.r2dbc.postgresql.client.DefaultHostnameVerifier;
import io.r2dbc.postgresql.client.SSLConfig;
import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.postgresql.extension.CodecRegistrar;
import io.r2dbc.postgresql.extension.Extension;
import io.r2dbc.postgresql.util.Assert;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import reactor.netty.resources.LoopResources;
import reactor.util.annotation.Nullable;

public final class PostgresqlConnectionConfiguration {
    public static final int DEFAULT_PORT = 5432;
    private final String applicationName;
    private final boolean autodetectExtensions;
    private final boolean compatibilityMode;
    private final Duration connectTimeout;
    private final String database;
    private final List<Extension> extensions;
    private final ToIntFunction<String> fetchSize;
    private final boolean forceBinary;
    private final String host;
    @Nullable
    private final Duration lockWaitTimeout;
    @Nullable
    private final LoopResources loopResources;
    private final Map<String, String> options;
    private final CharSequence password;
    private final int port;
    private final boolean preferAttachedBuffers;
    private final int preparedStatementCacheQueries;
    @Nullable
    private final Duration statementTimeout;
    private final String socket;
    private final SSLConfig sslConfig;
    private final boolean tcpKeepAlive;
    private final boolean tcpNoDelay;
    private final String username;

    private PostgresqlConnectionConfiguration(String applicationName, boolean autodetectExtensions, @Nullable boolean compatibilityMode, Duration connectTimeout, @Nullable String database, List<Extension> extensions, ToIntFunction<String> fetchSize, boolean forceBinary, @Nullable String host, @Nullable Duration lockWaitTimeout, @Nullable LoopResources loopResources, @Nullable Map<String, String> options, @Nullable CharSequence password, int port, boolean preferAttachedBuffers, int preparedStatementCacheQueries, @Nullable String schema, @Nullable String socket, SSLConfig sslConfig, @Nullable Duration statementTimeout, boolean tcpKeepAlive, boolean tcpNoDelay, String username) {
        this.applicationName = Assert.requireNonNull(applicationName, "applicationName must not be null");
        this.autodetectExtensions = autodetectExtensions;
        this.compatibilityMode = compatibilityMode;
        this.connectTimeout = connectTimeout;
        this.extensions = Assert.requireNonNull(extensions, "extensions must not be null");
        this.database = database;
        this.fetchSize = fetchSize;
        this.forceBinary = forceBinary;
        this.host = host;
        this.loopResources = loopResources;
        this.options = options == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(options);
        this.statementTimeout = statementTimeout;
        this.lockWaitTimeout = lockWaitTimeout;
        if (this.statementTimeout != null) {
            this.options.put("statement_timeout", Long.toString(statementTimeout.toMillis()));
        }
        if (this.lockWaitTimeout != null) {
            this.options.put("lock_timeout", Long.toString(lockWaitTimeout.toMillis()));
        }
        if (schema != null && !schema.isEmpty()) {
            this.options.put("search_path", schema);
        }
        this.password = password;
        this.port = port;
        this.preferAttachedBuffers = preferAttachedBuffers;
        this.preparedStatementCacheQueries = preparedStatementCacheQueries;
        this.socket = socket;
        this.sslConfig = sslConfig;
        this.tcpKeepAlive = tcpKeepAlive;
        this.tcpNoDelay = tcpNoDelay;
        this.username = Assert.requireNonNull(username, "username must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "PostgresqlConnectionConfiguration{applicationName='" + this.applicationName + '\'' + ", autodetectExtensions='" + this.autodetectExtensions + '\'' + ", compatibilityMode=" + this.compatibilityMode + ", connectTimeout=" + this.connectTimeout + ", database='" + this.database + '\'' + ", extensions=" + this.extensions + ", fetchSize=" + this.fetchSize + ", forceBinary='" + this.forceBinary + '\'' + ", host='" + this.host + '\'' + ", lockWaitTimeout='" + this.lockWaitTimeout + ", loopResources='" + this.loopResources + '\'' + ", options='" + this.options + '\'' + ", password='" + PostgresqlConnectionConfiguration.obfuscate(this.password != null ? this.password.length() : 0) + '\'' + ", port=" + this.port + ", preferAttachedBuffers=" + this.preferAttachedBuffers + ", socket=" + this.socket + ", statementTimeout=" + this.statementTimeout + ", tcpKeepAlive=" + this.tcpKeepAlive + ", tcpNoDelay=" + this.tcpNoDelay + ", username='" + this.username + '\'' + '}';
    }

    String getApplicationName() {
        return this.applicationName;
    }

    boolean isCompatibilityMode() {
        return this.compatibilityMode;
    }

    @Nullable
    Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Nullable
    String getDatabase() {
        return this.database;
    }

    List<Extension> getExtensions() {
        return this.extensions;
    }

    ToIntFunction<String> getFetchSize() {
        return this.fetchSize;
    }

    int getFetchSize(String sql) {
        return this.fetchSize.applyAsInt(sql);
    }

    @Nullable
    String getHost() {
        return this.host;
    }

    String getRequiredHost() {
        String host = this.getHost();
        if (host == null || host.isEmpty()) {
            throw new IllegalStateException("Connection is configured for socket connections and not for host usage");
        }
        return host;
    }

    @Nullable
    LoopResources getLoopResources() {
        return this.loopResources;
    }

    Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    @Nullable
    CharSequence getPassword() {
        return this.password;
    }

    int getPort() {
        return this.port;
    }

    boolean isPreferAttachedBuffers() {
        return this.preferAttachedBuffers;
    }

    int getPreparedStatementCacheQueries() {
        return this.preparedStatementCacheQueries;
    }

    @Nullable
    String getSocket() {
        return this.socket;
    }

    String getRequiredSocket() {
        String socket = this.getSocket();
        if (socket == null || socket.isEmpty()) {
            throw new IllegalStateException("Connection is configured to use host and port connections and not for socket usage");
        }
        return socket;
    }

    String getUsername() {
        return this.username;
    }

    boolean isAutodetectExtensions() {
        return this.autodetectExtensions;
    }

    boolean isForceBinary() {
        return this.forceBinary;
    }

    boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    boolean isUseSocket() {
        return this.getSocket() != null;
    }

    SSLConfig getSslConfig() {
        return this.sslConfig;
    }

    private static String obfuscate(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append("*");
        }
        return builder.toString();
    }

    static class FixedFetchSize
    implements ToIntFunction<String> {
        private final int fetchSize;

        public FixedFetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
        }

        @Override
        public int applyAsInt(String value) {
            return this.fetchSize;
        }

        public String toString() {
            return "" + this.fetchSize;
        }
    }

    public static final class Builder {
        private String applicationName = "r2dbc-postgresql";
        private boolean autodetectExtensions = true;
        private boolean compatibilityMode = false;
        @Nullable
        private Duration connectTimeout;
        @Nullable
        private String database;
        private final List<Extension> extensions = new ArrayList<Extension>();
        private ToIntFunction<String> fetchSize = sql -> 0;
        private boolean forceBinary = false;
        @Nullable
        private String host;
        @Nullable
        private Duration lockWaitTimeout;
        private Map<String, String> options;
        @Nullable
        private CharSequence password;
        private int port = 5432;
        private boolean preferAttachedBuffers = false;
        private int preparedStatementCacheQueries = -1;
        @Nullable
        private String schema;
        @Nullable
        private String socket;
        @Nullable
        private URL sslCert = null;
        private HostnameVerifier sslHostnameVerifier = DefaultHostnameVerifier.INSTANCE;
        @Nullable
        private URL sslKey = null;
        private SSLMode sslMode = SSLMode.DISABLE;
        @Nullable
        private CharSequence sslPassword = null;
        @Nullable
        private URL sslRootCert = null;
        @Nullable
        private Duration statementTimeout = null;
        private Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer = Function.identity();
        private boolean tcpKeepAlive = false;
        private boolean tcpNoDelay = true;
        @Nullable
        private LoopResources loopResources = null;
        @Nullable
        private String username;

        private Builder() {
        }

        public Builder applicationName(String applicationName) {
            this.applicationName = Assert.requireNonNull(applicationName, "applicationName must not be null");
            return this;
        }

        public Builder autodetectExtensions(boolean autodetectExtensions) {
            this.autodetectExtensions = autodetectExtensions;
            return this;
        }

        public PostgresqlConnectionConfiguration build() {
            if (this.host == null && this.socket == null) {
                throw new IllegalArgumentException("host or socket must not be null");
            }
            if (this.host != null && this.socket != null) {
                throw new IllegalArgumentException("Connection must be configured for either host/port or socket usage but not both");
            }
            if (this.username == null) {
                throw new IllegalArgumentException("username must not be null");
            }
            return new PostgresqlConnectionConfiguration(this.applicationName, this.autodetectExtensions, this.compatibilityMode, this.connectTimeout, this.database, this.extensions, this.fetchSize, this.forceBinary, this.host, this.lockWaitTimeout, this.loopResources, this.options, this.password, this.port, this.preferAttachedBuffers, this.preparedStatementCacheQueries, this.schema, this.socket, this.createSslConfig(), this.statementTimeout, this.tcpKeepAlive, this.tcpNoDelay, this.username);
        }

        public Builder compatibilityMode(boolean compatibilityMode) {
            this.compatibilityMode = compatibilityMode;
            return this;
        }

        public Builder connectTimeout(@Nullable Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder codecRegistrar(CodecRegistrar codecRegistrar) {
            return this.extendWith(codecRegistrar);
        }

        public Builder database(@Nullable String database) {
            this.database = database;
            return this;
        }

        public Builder enableSsl() {
            return this.sslMode(SSLMode.VERIFY_FULL);
        }

        public Builder extendWith(Extension extension) {
            this.extensions.add(Assert.requireNonNull(extension, "extension must not be null"));
            return this;
        }

        public Builder fetchSize(int fetchSize) {
            Assert.isTrue(fetchSize >= 0, "fetch size must be greater or equal zero");
            return this.fetchSize(new FixedFetchSize(fetchSize));
        }

        public Builder fetchSize(ToIntFunction<String> fetchSizeFunction) {
            Assert.requireNonNull(fetchSizeFunction, "fetch size function must be non null");
            this.fetchSize = fetchSizeFunction;
            return this;
        }

        public Builder forceBinary(boolean forceBinary) {
            this.forceBinary = forceBinary;
            return this;
        }

        public Builder host(String host) {
            this.host = Assert.requireNonNull(host, "host must not be null");
            return this;
        }

        public Builder lockWaitTimeout(Duration lockWaitTimeout) {
            this.lockWaitTimeout = Assert.requireNonNull(lockWaitTimeout, "Lock wait timeout must not be null");
            return this;
        }

        public Builder loopResources(LoopResources loopResources) {
            this.loopResources = Assert.requireNonNull(loopResources, "loopResources must not be null");
            return this;
        }

        public Builder options(Map<String, String> options) {
            Assert.requireNonNull(options, "options map must not be null");
            options.forEach((k, v) -> {
                Assert.requireNonNull(k, "option keys must not be null");
                Assert.requireNonNull(v, "option values must not be null");
            });
            this.options = options;
            return this;
        }

        public Builder password(@Nullable CharSequence password) {
            this.password = password;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder preferAttachedBuffers(boolean preferAttachedBuffers) {
            this.preferAttachedBuffers = preferAttachedBuffers;
            return this;
        }

        public Builder preparedStatementCacheQueries(int preparedStatementCacheQueries) {
            this.preparedStatementCacheQueries = preparedStatementCacheQueries;
            return this;
        }

        public Builder schema(@Nullable String schema) {
            this.schema = schema;
            return this;
        }

        public Builder socket(String socket) {
            this.socket = Assert.requireNonNull(socket, "host must not be null");
            this.sslMode(SSLMode.DISABLE);
            return this;
        }

        public Builder sslContextBuilderCustomizer(Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer) {
            this.sslContextBuilderCustomizer = Assert.requireNonNull(sslContextBuilderCustomizer, "sslContextBuilderCustomizer must not be null");
            return this;
        }

        public Builder sslCert(String sslCert) {
            return this.sslCert(this.requireExistingFilePath(sslCert, "sslCert must not be null and must exist"));
        }

        public Builder sslCert(URL sslCert) {
            this.sslCert = Assert.requireNonNull(sslCert, "sslCert must not be null");
            return this;
        }

        public Builder sslHostnameVerifier(HostnameVerifier sslHostnameVerifier) {
            this.sslHostnameVerifier = Assert.requireNonNull(sslHostnameVerifier, "sslHostnameVerifier must not be null");
            return this;
        }

        public Builder sslKey(String sslKey) {
            return this.sslKey(this.requireExistingFilePath(sslKey, "sslKey must not be null and must exist"));
        }

        public Builder sslKey(URL sslKey) {
            this.sslKey = Assert.requireNonNull(sslKey, "sslKey must not be null");
            return this;
        }

        public Builder sslMode(SSLMode sslMode) {
            this.sslMode = Assert.requireNonNull(sslMode, "sslMode must be not be null");
            return this;
        }

        public Builder sslPassword(@Nullable CharSequence sslPassword) {
            this.sslPassword = sslPassword;
            return this;
        }

        public Builder sslRootCert(String sslRootCert) {
            return this.sslRootCert(this.requireExistingFilePath(sslRootCert, "sslRootCert must not be null and must exist"));
        }

        public Builder sslRootCert(URL sslRootCert) {
            this.sslRootCert = Assert.requireNonNull(sslRootCert, "sslRootCert must not be null and must exist");
            return this;
        }

        public Builder statementTimeout(Duration statementTimeout) {
            this.statementTimeout = Assert.requireNonNull(statementTimeout, "Statement timeout");
            return this;
        }

        public Builder tcpKeepAlive(boolean enabled) {
            this.tcpKeepAlive = enabled;
            return this;
        }

        public Builder tcpNoDelay(boolean enabled) {
            this.tcpNoDelay = enabled;
            return this;
        }

        public Builder username(String username) {
            this.username = Assert.requireNonNull(username, "username must not be null");
            return this;
        }

        public String toString() {
            return "Builder{applicationName='" + this.applicationName + '\'' + ", autodetectExtensions='" + this.autodetectExtensions + '\'' + ", compatibilityMode='" + this.compatibilityMode + '\'' + ", connectTimeout='" + this.connectTimeout + '\'' + ", database='" + this.database + '\'' + ", extensions='" + this.extensions + '\'' + ", fetchSize='" + this.fetchSize + '\'' + ", forceBinary='" + this.forceBinary + '\'' + ", host='" + this.host + '\'' + ", lockWaitTimeout='" + this.lockWaitTimeout + '\'' + ", loopResources='" + this.loopResources + '\'' + ", parameters='" + this.options + '\'' + ", password='" + PostgresqlConnectionConfiguration.obfuscate(this.password != null ? this.password.length() : 0) + '\'' + ", port=" + this.port + ", preparedStatementCacheQueries='" + this.preparedStatementCacheQueries + '\'' + ", schema='" + this.schema + '\'' + ", socket='" + this.socket + '\'' + ", sslContextBuilderCustomizer='" + this.sslContextBuilderCustomizer + '\'' + ", sslMode='" + (Object)((Object)this.sslMode) + '\'' + ", sslRootCert='" + this.sslRootCert + '\'' + ", sslCert='" + this.sslCert + '\'' + ", sslKey='" + this.sslKey + '\'' + ", statementTimeout='" + this.statementTimeout + '\'' + ", sslHostnameVerifier='" + this.sslHostnameVerifier + '\'' + ", tcpKeepAlive='" + this.tcpKeepAlive + '\'' + ", tcpNoDelay='" + this.tcpNoDelay + '\'' + ", username='" + this.username + '\'' + '}';
        }

        private SSLConfig createSslConfig() {
            if (this.socket != null || this.sslMode == SSLMode.DISABLE) {
                return SSLConfig.disabled();
            }
            HostnameVerifier hostnameVerifier = this.sslHostnameVerifier;
            return new SSLConfig(this.sslMode, this.createSslProvider(), hostnameVerifier);
        }

        private Supplier<SslContext> createSslProvider() {
            String pathname;
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
            if (this.sslMode.verifyCertificate()) {
                if (this.sslRootCert != null) {
                    this.doWithStream(this.sslRootCert, arg_0 -> ((SslContextBuilder)sslContextBuilder).trustManager(arg_0));
                }
            } else {
                sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            }
            sslContextBuilder.sslProvider(OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).applicationProtocolConfig(null);
            URL sslKey = this.sslKey;
            URL sslCert = this.sslCert;
            String pathSeparator = System.getProperty("file.separator");
            String defaultDir = System.getProperty("os.name").toLowerCase().contains("windows") ? System.getenv("APPDATA") + pathSeparator + "postgresql" + pathSeparator : System.getProperty("user.home") + pathSeparator + ".postgresql" + pathSeparator;
            if (sslCert == null) {
                pathname = defaultDir + "postgresql.crt";
                sslCert = this.resolveUrlFromFile(pathname);
            }
            if (sslKey == null) {
                pathname = defaultDir + "postgresql.pk8";
                sslKey = this.resolveUrlFromFile(pathname);
            }
            URL sslKeyToUse = sslKey;
            if (sslKey != null && sslCert != null) {
                String sslPassword = this.sslPassword == null ? null : this.sslPassword.toString();
                this.doWithStream(sslCert, certStream -> this.doWithStream(sslKeyToUse, keyStream -> sslContextBuilder.keyManager(certStream, keyStream, sslPassword)));
            }
            return () -> {
                try {
                    return this.sslContextBuilderCustomizer.apply(sslContextBuilder).build();
                }
                catch (SSLException e) {
                    throw new IllegalStateException("Failed to create SslContext", e);
                }
            };
        }

        private void doWithStream(URL url, StreamConsumer consumer) {
            try (InputStream is = url.openStream();){
                consumer.doWithStream(is);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while reading " + url, e);
            }
        }

        private URL requireExistingFilePath(String path, String message) {
            Assert.requireNonNull(path, message);
            URL resource = this.getClass().getClassLoader().getResource(path);
            if (resource != null) {
                return resource;
            }
            if (!new File(path).exists()) {
                throw new IllegalArgumentException(message);
            }
            return this.resolveUrlFromFile(path);
        }

        private URL resolveUrlFromFile(String pathname) {
            File file = new File(pathname);
            if (file.exists()) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(String.format("Malformed error occurred during creating URL from %s", pathname));
                }
            }
            return null;
        }

        static interface StreamConsumer {
            public void doWithStream(InputStream var1) throws IOException;
        }
    }
}

