/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.Interval;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.util.Collections;
import java.util.EnumSet;

final class IntervalCodec
extends AbstractCodec<Interval> {
    private final ByteBufAllocator byteBufAllocator;

    IntervalCodec(ByteBufAllocator byteBufAllocator) {
        super(Interval.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return PostgresqlObjectId.INTERVAL == type && Format.FORMAT_TEXT == format;
    }

    @Override
    Interval doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, Class<? extends Interval> type) {
        return Interval.parse(ByteBufUtils.decode(buffer));
    }

    @Override
    public Iterable<Format> getFormats() {
        return EnumSet.of(Format.FORMAT_TEXT);
    }

    @Override
    public Iterable<PostgresqlObjectId> getDataTypes() {
        return Collections.singleton(PostgresqlObjectId.INTERVAL);
    }

    @Override
    Parameter doEncode(Interval value) {
        Assert.requireNonNull(value, "value must not be null");
        return IntervalCodec.create(PostgresqlObjectId.INTERVAL, Format.FORMAT_TEXT, () -> ByteBufUtils.encode(this.byteBufAllocator, value.getValue()));
    }

    @Override
    public Parameter encodeNull() {
        return IntervalCodec.createNull(PostgresqlObjectId.INTERVAL, Format.FORMAT_TEXT);
    }
}

