/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractJsonCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;

final class JsonStringCodec
extends AbstractJsonCodec<String> {
    private final ByteBufAllocator byteBufAllocator;

    JsonStringCodec(ByteBufAllocator byteBufAllocator) {
        super(String.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    String doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, Class<? extends String> type) {
        return ByteBufUtils.decode(buffer);
    }

    @Override
    Parameter doEncode(String value) {
        Assert.requireNonNull(value, "value must not be null");
        return JsonStringCodec.create(PostgresqlObjectId.JSON, Format.FORMAT_TEXT, () -> ByteBufUtils.encode(this.byteBufAllocator, value));
    }
}

