/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.math.BigDecimal;
import reactor.util.annotation.Nullable;

final class NumericDecodeUtils {
    private NumericDecodeUtils() {
    }

    public static Number decodeNumber(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        switch (dataType) {
            case NUMERIC: {
                if (format == Format.FORMAT_BINARY) {
                    return NumericDecodeUtils.decodeBinary(buffer);
                }
                return new BigDecimal(ByteBufUtils.decode(buffer));
            }
            case INT2: {
                if (Format.FORMAT_BINARY == format) {
                    return buffer.readShort();
                }
                return Short.parseShort(ByteBufUtils.decode(buffer));
            }
            case INT4: 
            case OID: {
                if (Format.FORMAT_BINARY == format) {
                    return buffer.readInt();
                }
                return Integer.parseInt(ByteBufUtils.decode(buffer));
            }
            case INT8: {
                if (Format.FORMAT_BINARY == format) {
                    return buffer.readLong();
                }
                return Long.parseLong(ByteBufUtils.decode(buffer));
            }
            case FLOAT4: {
                if (Format.FORMAT_BINARY == format) {
                    return Float.valueOf(buffer.readFloat());
                }
                return Float.valueOf(Float.parseFloat(ByteBufUtils.decode(buffer)));
            }
            case FLOAT8: {
                if (Format.FORMAT_BINARY == format) {
                    return buffer.readDouble();
                }
                return Double.parseDouble(ByteBufUtils.decode(buffer));
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot decode value for type %s, format %s", new Object[]{dataType, format}));
    }

    public static BigDecimal decodeBinary(ByteBuf byteBuf) {
        int i;
        short numOfDigits = byteBuf.readShort();
        if (numOfDigits == 0) {
            return BigDecimal.ZERO;
        }
        short weight = byteBuf.readShort();
        short sign = byteBuf.readShort();
        short scale = byteBuf.readShort();
        short[] digits = new short[numOfDigits];
        for (short i2 = 0; i2 < numOfDigits; i2 = (short)(i2 + 1)) {
            digits[i2] = byteBuf.readShort();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(digits[0]);
        for (i = 0; i < weight * 4; i = (int)((short)(i + 1))) {
            builder.append(0);
        }
        if (scale > 0) {
            builder.append('.');
            for (i = 0; i < scale; i = (int)((short)(i + 1))) {
                builder.append(0);
            }
        }
        int expectedLength = builder.length();
        int baseOffset = Short.toString(digits[0]).length();
        for (short i3 = 1; i3 < numOfDigits; i3 = (short)(i3 + 1)) {
            weight = (short)(weight - 1);
            String temp = Short.toString(digits[i3]);
            int offset = baseOffset + 4 * i3 - temp.length();
            if (weight < 0) {
                ++offset;
            }
            builder.replace(offset, offset + temp.length(), temp);
        }
        builder.setLength(expectedLength);
        if (sign == 0) {
            return new BigDecimal(builder.toString());
        }
        return new BigDecimal("-" + builder.toString());
    }
}

