/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractArrayCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Supplier;

final class StringArrayCodec
extends AbstractArrayCodec<String> {
    private static final Set<PostgresqlObjectId> SUPPORTED_TYPES = EnumSet.of(PostgresqlObjectId.BPCHAR_ARRAY, PostgresqlObjectId.CHAR_ARRAY, PostgresqlObjectId.NAME_ARRAY, PostgresqlObjectId.TEXT_ARRAY, PostgresqlObjectId.VARCHAR_ARRAY);

    StringArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, String.class);
    }

    @Override
    public Parameter encodeNull() {
        return StringArrayCodec.createNull(PostgresqlObjectId.TEXT_ARRAY, Format.FORMAT_TEXT);
    }

    @Override
    public Iterable<PostgresqlObjectId> getDataTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    String doDecodeBinary(ByteBuf byteBuffer) {
        return ByteBufUtils.decode(byteBuffer);
    }

    @Override
    String doDecodeText(String text) {
        return text;
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return SUPPORTED_TYPES.contains((Object)type);
    }

    @Override
    Parameter encodeArray(Supplier<ByteBuf> encodedSupplier) {
        return StringArrayCodec.create(PostgresqlObjectId.TEXT_ARRAY, Format.FORMAT_TEXT, encodedSupplier);
    }

    @Override
    String doEncodeText(String value) {
        Assert.requireNonNull(value, "value must not be null");
        return AbstractArrayCodec.escapeArrayElement(value);
    }
}

