/*
 * Decompiled with CFR 0.152.
 */
package rx;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import rx.Observable;
import rx.Scheduler;
import rx.SingleSubscriber;
import rx.Subscriber;
import rx.Subscription;
import rx.annotations.Experimental;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorNotImplementedException;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.functions.Func3;
import rx.functions.Func4;
import rx.functions.Func5;
import rx.functions.Func6;
import rx.functions.Func7;
import rx.functions.Func8;
import rx.functions.Func9;
import rx.internal.operators.OnSubscribeToObservableFuture;
import rx.internal.operators.OperatorMap;
import rx.internal.operators.OperatorObserveOn;
import rx.internal.operators.OperatorOnErrorReturn;
import rx.internal.operators.OperatorSubscribeOn;
import rx.internal.operators.OperatorTimeout;
import rx.internal.operators.OperatorZip;
import rx.internal.producers.SingleDelayedProducer;
import rx.observers.SafeSubscriber;
import rx.plugins.RxJavaObservableExecutionHook;
import rx.plugins.RxJavaPlugins;
import rx.schedulers.Schedulers;
import rx.subscriptions.Subscriptions;

@Experimental
public class Single<T> {
    final Observable.OnSubscribe<T> onSubscribe;
    private static final RxJavaObservableExecutionHook hook = RxJavaPlugins.getInstance().getObservableExecutionHook();

    protected Single(final OnSubscribe<T> f) {
        this.onSubscribe = new Observable.OnSubscribe<T>(){

            @Override
            public void call(final Subscriber<? super T> child) {
                final SingleDelayedProducer producer = new SingleDelayedProducer(child);
                child.setProducer(producer);
                SingleSubscriber ss = new SingleSubscriber<T>(){

                    @Override
                    public void onSuccess(T value) {
                        producer.setValue(value);
                    }

                    @Override
                    public void onError(Throwable error) {
                        child.onError(error);
                    }
                };
                child.add(ss);
                f.call(ss);
            }
        };
    }

    private Single(Observable.OnSubscribe<T> f) {
        this.onSubscribe = f;
    }

    public static final <T> Single<T> create(OnSubscribe<T> f) {
        return new Single<T>(f);
    }

    private final <R> Single<R> lift(final Observable.Operator<? extends R, ? super T> lift) {
        return new Single<T>(new Observable.OnSubscribe<R>(){

            @Override
            public void call(Subscriber<? super R> o) {
                try {
                    Subscriber st = (Subscriber)hook.onLift(lift).call(o);
                    try {
                        st.onStart();
                        Single.this.onSubscribe.call(st);
                    }
                    catch (Throwable e) {
                        if (e instanceof OnErrorNotImplementedException) {
                            throw (OnErrorNotImplementedException)e;
                        }
                        st.onError(e);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof OnErrorNotImplementedException) {
                        throw (OnErrorNotImplementedException)e;
                    }
                    o.onError(e);
                }
            }
        });
    }

    public <R> Single<R> compose(Transformer<? super T, ? extends R> transformer) {
        return (Single)transformer.call(this);
    }

    private static <T> Observable<T> asObservable(Single<T> t) {
        return Observable.create(t.onSubscribe);
    }

    private final Single<Observable<T>> nest() {
        return Single.just(Single.asObservable(this));
    }

    public static final <T> Observable<T> concat(Single<? extends T> t1, Single<? extends T> t2) {
        return Observable.concat(Single.asObservable(t1), Single.asObservable(t2));
    }

    public static final <T> Observable<T> concat(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3) {
        return Observable.concat(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3));
    }

    public static final <T> Observable<T> concat(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4) {
        return Observable.concat(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4));
    }

    public static final <T> Observable<T> concat(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5) {
        return Observable.concat(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5));
    }

    public static final <T> Observable<T> concat(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5, Single<? extends T> t6) {
        return Observable.concat(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5), Single.asObservable(t6));
    }

    public static final <T> Observable<T> concat(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5, Single<? extends T> t6, Single<? extends T> t7) {
        return Observable.concat(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5), Single.asObservable(t6), Single.asObservable(t7));
    }

    public static final <T> Observable<T> concat(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5, Single<? extends T> t6, Single<? extends T> t7, Single<? extends T> t8) {
        return Observable.concat(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5), Single.asObservable(t6), Single.asObservable(t7), Single.asObservable(t8));
    }

    public static final <T> Observable<T> concat(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5, Single<? extends T> t6, Single<? extends T> t7, Single<? extends T> t8, Single<? extends T> t9) {
        return Observable.concat(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5), Single.asObservable(t6), Single.asObservable(t7), Single.asObservable(t8), Single.asObservable(t9));
    }

    public static final <T> Single<T> error(final Throwable exception) {
        return Single.create(new OnSubscribe<T>(){

            @Override
            public void call(SingleSubscriber<? super T> te) {
                te.onError(exception);
            }
        });
    }

    public static final <T> Single<T> from(Future<? extends T> future) {
        return new Single<T>(OnSubscribeToObservableFuture.toObservableFuture(future));
    }

    public static final <T> Single<T> from(Future<? extends T> future, long timeout, TimeUnit unit) {
        return new Single<T>(OnSubscribeToObservableFuture.toObservableFuture(future, timeout, unit));
    }

    public static final <T> Single<T> from(Future<? extends T> future, Scheduler scheduler) {
        return new Single<T>(OnSubscribeToObservableFuture.toObservableFuture(future)).subscribeOn(scheduler);
    }

    public static final <T> Single<T> just(final T value) {
        return Single.create(new OnSubscribe<T>(){

            @Override
            public void call(SingleSubscriber<? super T> te) {
                te.onSuccess(value);
            }
        });
    }

    public static final <T> Single<T> merge(final Single<? extends Single<? extends T>> source) {
        return Single.create(new OnSubscribe<T>(){

            @Override
            public void call(final SingleSubscriber<? super T> child) {
                source.subscribe(new SingleSubscriber<Single<? extends T>>(){

                    @Override
                    public void onSuccess(Single<? extends T> innerSingle) {
                        innerSingle.subscribe(child);
                    }

                    @Override
                    public void onError(Throwable error) {
                        child.onError(error);
                    }
                });
            }
        });
    }

    public static final <T> Observable<T> merge(Single<? extends T> t1, Single<? extends T> t2) {
        return Observable.merge(Single.asObservable(t1), Single.asObservable(t2));
    }

    public static final <T> Observable<T> merge(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3) {
        return Observable.merge(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3));
    }

    public static final <T> Observable<T> merge(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4) {
        return Observable.merge(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4));
    }

    public static final <T> Observable<T> merge(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5) {
        return Observable.merge(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5));
    }

    public static final <T> Observable<T> merge(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5, Single<? extends T> t6) {
        return Observable.merge(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5), Single.asObservable(t6));
    }

    public static final <T> Observable<T> merge(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5, Single<? extends T> t6, Single<? extends T> t7) {
        return Observable.merge(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5), Single.asObservable(t6), Single.asObservable(t7));
    }

    public static final <T> Observable<T> merge(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5, Single<? extends T> t6, Single<? extends T> t7, Single<? extends T> t8) {
        return Observable.merge(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5), Single.asObservable(t6), Single.asObservable(t7), Single.asObservable(t8));
    }

    public static final <T> Observable<T> merge(Single<? extends T> t1, Single<? extends T> t2, Single<? extends T> t3, Single<? extends T> t4, Single<? extends T> t5, Single<? extends T> t6, Single<? extends T> t7, Single<? extends T> t8, Single<? extends T> t9) {
        return Observable.merge(Single.asObservable(t1), Single.asObservable(t2), Single.asObservable(t3), Single.asObservable(t4), Single.asObservable(t5), Single.asObservable(t6), Single.asObservable(t7), Single.asObservable(t8), Single.asObservable(t9));
    }

    public static final <T1, T2, R> Single<R> zip(Single<? extends T1> o1, Single<? extends T2> o2, Func2<? super T1, ? super T2, ? extends R> zipFunction) {
        return super.lift(new OperatorZip(zipFunction));
    }

    public static final <T1, T2, T3, R> Single<R> zip(Single<? extends T1> o1, Single<? extends T2> o2, Single<? extends T3> o3, Func3<? super T1, ? super T2, ? super T3, ? extends R> zipFunction) {
        return super.lift(new OperatorZip(zipFunction));
    }

    public static final <T1, T2, T3, T4, R> Single<R> zip(Single<? extends T1> o1, Single<? extends T2> o2, Single<? extends T3> o3, Single<? extends T4> o4, Func4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipFunction) {
        return super.lift(new OperatorZip(zipFunction));
    }

    public static final <T1, T2, T3, T4, T5, R> Single<R> zip(Single<? extends T1> o1, Single<? extends T2> o2, Single<? extends T3> o3, Single<? extends T4> o4, Single<? extends T5> o5, Func5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipFunction) {
        return super.lift(new OperatorZip(zipFunction));
    }

    public static final <T1, T2, T3, T4, T5, T6, R> Single<R> zip(Single<? extends T1> o1, Single<? extends T2> o2, Single<? extends T3> o3, Single<? extends T4> o4, Single<? extends T5> o5, Single<? extends T6> o6, Func6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipFunction) {
        return super.lift(new OperatorZip(zipFunction));
    }

    public static final <T1, T2, T3, T4, T5, T6, T7, R> Single<R> zip(Single<? extends T1> o1, Single<? extends T2> o2, Single<? extends T3> o3, Single<? extends T4> o4, Single<? extends T5> o5, Single<? extends T6> o6, Single<? extends T7> o7, Func7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipFunction) {
        return super.lift(new OperatorZip(zipFunction));
    }

    public static final <T1, T2, T3, T4, T5, T6, T7, T8, R> Single<R> zip(Single<? extends T1> o1, Single<? extends T2> o2, Single<? extends T3> o3, Single<? extends T4> o4, Single<? extends T5> o5, Single<? extends T6> o6, Single<? extends T7> o7, Single<? extends T8> o8, Func8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipFunction) {
        return super.lift(new OperatorZip(zipFunction));
    }

    public static final <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Single<R> zip(Single<? extends T1> o1, Single<? extends T2> o2, Single<? extends T3> o3, Single<? extends T4> o4, Single<? extends T5> o5, Single<? extends T6> o6, Single<? extends T7> o7, Single<? extends T8> o8, Single<? extends T9> o9, Func9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipFunction) {
        return super.lift(new OperatorZip(zipFunction));
    }

    public final Observable<T> concatWith(Single<? extends T> t1) {
        return Single.concat(this, t1);
    }

    public final <R> Single<R> flatMap(Func1<? super T, ? extends Single<? extends R>> func) {
        return Single.merge(this.map(func));
    }

    public final <R> Observable<R> flatMapObservable(Func1<? super T, ? extends Observable<? extends R>> func) {
        return Observable.merge(Single.asObservable(this.map(func)));
    }

    public final <R> Single<R> map(Func1<? super T, ? extends R> func) {
        return this.lift(new OperatorMap<T, R>(func));
    }

    public final Observable<T> mergeWith(Single<? extends T> t1) {
        return Single.merge(this, t1);
    }

    public final Single<T> observeOn(Scheduler scheduler) {
        return this.lift(new OperatorObserveOn(scheduler));
    }

    public final Single<T> onErrorReturn(Func1<Throwable, ? extends T> resumeFunction) {
        return this.lift(new OperatorOnErrorReturn<T>(resumeFunction));
    }

    public final Subscription subscribe() {
        return this.subscribe(new Subscriber<T>(){

            @Override
            public final void onCompleted() {
            }

            @Override
            public final void onError(Throwable e) {
                throw new OnErrorNotImplementedException(e);
            }

            @Override
            public final void onNext(T args) {
            }
        });
    }

    public final Subscription subscribe(final Action1<? super T> onSuccess) {
        if (onSuccess == null) {
            throw new IllegalArgumentException("onSuccess can not be null");
        }
        return this.subscribe(new Subscriber<T>(){

            @Override
            public final void onCompleted() {
            }

            @Override
            public final void onError(Throwable e) {
                throw new OnErrorNotImplementedException(e);
            }

            @Override
            public final void onNext(T args) {
                onSuccess.call(args);
            }
        });
    }

    public final Subscription subscribe(final Action1<? super T> onSuccess, final Action1<Throwable> onError) {
        if (onSuccess == null) {
            throw new IllegalArgumentException("onSuccess can not be null");
        }
        if (onError == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        return this.subscribe(new Subscriber<T>(){

            @Override
            public final void onCompleted() {
            }

            @Override
            public final void onError(Throwable e) {
                onError.call(e);
            }

            @Override
            public final void onNext(T args) {
                onSuccess.call(args);
            }
        });
    }

    public final void unsafeSubscribe(Subscriber<? super T> subscriber) {
        try {
            subscriber.onStart();
            this.onSubscribe.call(subscriber);
            hook.onSubscribeReturn(subscriber);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            try {
                subscriber.onError(hook.onSubscribeError(e));
            }
            catch (OnErrorNotImplementedException e2) {
                throw e2;
            }
            catch (Throwable e2) {
                RuntimeException r = new RuntimeException("Error occurred attempting to subscribe [" + e.getMessage() + "] and then again while trying to pass to onError.", e2);
                hook.onSubscribeError(r);
                throw r;
            }
        }
    }

    public final Subscription subscribe(Subscriber<? super T> subscriber) {
        if (subscriber == null) {
            throw new IllegalArgumentException("observer can not be null");
        }
        if (this.onSubscribe == null) {
            throw new IllegalStateException("onSubscribe function can not be null.");
        }
        subscriber.onStart();
        if (!(subscriber instanceof SafeSubscriber)) {
            subscriber = new SafeSubscriber<T>(subscriber);
        }
        try {
            this.onSubscribe.call(subscriber);
            return hook.onSubscribeReturn(subscriber);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            try {
                subscriber.onError(hook.onSubscribeError(e));
            }
            catch (OnErrorNotImplementedException e2) {
                throw e2;
            }
            catch (Throwable e2) {
                RuntimeException r = new RuntimeException("Error occurred attempting to subscribe [" + e.getMessage() + "] and then again while trying to pass to onError.", e2);
                hook.onSubscribeError(r);
                throw r;
            }
            return Subscriptions.empty();
        }
    }

    public final Subscription subscribe(final SingleSubscriber<? super T> te) {
        Subscriber s = new Subscriber<T>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                te.onError(e);
            }

            @Override
            public void onNext(T t) {
                te.onSuccess(t);
            }
        };
        te.add(s);
        this.subscribe(s);
        return s;
    }

    public final Single<T> subscribeOn(Scheduler scheduler) {
        return super.lift(new OperatorSubscribeOn(scheduler));
    }

    public final Observable<T> toObservable() {
        return Single.asObservable(this);
    }

    public final Single<T> timeout(long timeout, TimeUnit timeUnit) {
        return this.timeout(timeout, timeUnit, null, Schedulers.computation());
    }

    public final Single<T> timeout(long timeout, TimeUnit timeUnit, Scheduler scheduler) {
        return this.timeout(timeout, timeUnit, null, scheduler);
    }

    public final Single<T> timeout(long timeout, TimeUnit timeUnit, Single<? extends T> other) {
        return this.timeout(timeout, timeUnit, other, Schedulers.computation());
    }

    public final Single<T> timeout(long timeout, TimeUnit timeUnit, Single<? extends T> other, Scheduler scheduler) {
        if (other == null) {
            other = Single.error(new TimeoutException());
        }
        return this.lift(new OperatorTimeout<T>(timeout, timeUnit, Single.asObservable(other), scheduler));
    }

    public final <T2, R> Single<R> zipWith(Single<? extends T2> other, Func2<? super T, ? super T2, ? extends R> zipFunction) {
        return Single.zip(this, other, zipFunction);
    }

    public static interface Transformer<T, R>
    extends Func1<Single<T>, Single<R>> {
    }

    public static interface OnSubscribe<T>
    extends Action1<SingleSubscriber<? super T>> {
    }
}

