/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.annotations.Experimental;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func1;

@Experimental
public final class OperatorTakeUntilPredicate<T>
implements Observable.Operator<T, T> {
    private final Func1<? super T, Boolean> stopPredicate;

    public OperatorTakeUntilPredicate(Func1<? super T, Boolean> stopPredicate) {
        this.stopPredicate = stopPredicate;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final ParentSubscriber parent = new ParentSubscriber(child);
        child.add(parent);
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                parent.downstreamRequest(n);
            }
        });
        return parent;
    }

    private final class ParentSubscriber
    extends Subscriber<T> {
        private final Subscriber<? super T> child;
        private boolean done = false;

        private ParentSubscriber(Subscriber<? super T> child) {
            this.child = child;
        }

        @Override
        public void onNext(T t) {
            this.child.onNext(t);
            boolean stop = false;
            try {
                stop = (Boolean)OperatorTakeUntilPredicate.this.stopPredicate.call(t);
            }
            catch (Throwable e) {
                this.done = true;
                Exceptions.throwIfFatal(e);
                this.child.onError(OnErrorThrowable.addValueAsLastCause(e, t));
                this.unsubscribe();
                return;
            }
            if (stop) {
                this.done = true;
                this.child.onCompleted();
                this.unsubscribe();
            }
        }

        @Override
        public void onCompleted() {
            if (!this.done) {
                this.child.onCompleted();
            }
        }

        @Override
        public void onError(Throwable e) {
            if (!this.done) {
                this.child.onError(e);
            }
        }

        void downstreamRequest(long n) {
            this.request(n);
        }
    }
}

