/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.mockmvc.config;

import io.restassured.config.DecoderConfig;
import io.restassured.config.EncoderConfig;
import io.restassured.config.HeaderConfig;
import io.restassured.config.JsonConfig;
import io.restassured.config.LogConfig;
import io.restassured.config.MultiPartConfig;
import io.restassured.config.ObjectMapperConfig;
import io.restassured.config.ParamConfig;
import io.restassured.config.SessionConfig;
import io.restassured.config.XmlConfig;
import io.restassured.internal.assertion.AssertParameter;
import io.restassured.module.mockmvc.config.MockMvcConfig;
import io.restassured.module.mockmvc.config.MockMvcParamConfig;
import io.restassured.module.spring.commons.config.AsyncConfig;
import io.restassured.module.spring.commons.config.ClientConfig;
import io.restassured.module.spring.commons.config.SpecificationConfig;

public class RestAssuredMockMvcConfig
implements SpecificationConfig {
    private final LogConfig logConfig;
    private final EncoderConfig encoderConfig;
    private final DecoderConfig decoderConfig;
    private final SessionConfig sessionConfig;
    private final ObjectMapperConfig objectMapperConfig;
    private final JsonConfig jsonConfig;
    private final XmlConfig xmlConfig;
    private final HeaderConfig headerConfig;
    private final AsyncConfig asyncConfig;
    private final MockMvcConfig mockMvcConfig;
    private final MultiPartConfig multiPartConfig;
    private final MockMvcParamConfig paramConfig;

    public RestAssuredMockMvcConfig() {
        this(new LogConfig(), new EncoderConfig(), new DecoderConfig(), new SessionConfig(), new ObjectMapperConfig(), new JsonConfig(), new XmlConfig(), new HeaderConfig(), new AsyncConfig(), new MultiPartConfig(), new MockMvcConfig(), new MockMvcParamConfig());
    }

    private RestAssuredMockMvcConfig(LogConfig logConfig, EncoderConfig encoderConfig, DecoderConfig decoderConfig, SessionConfig sessionConfig, ObjectMapperConfig objectMapperConfig, JsonConfig jsonConfig, XmlConfig xmlConfig, HeaderConfig headerConfig, AsyncConfig asyncConfig, MultiPartConfig multiPartConfig, MockMvcConfig mockMvcConfig, MockMvcParamConfig paramConfig) {
        AssertParameter.notNull((Object)logConfig, (String)"Log config");
        AssertParameter.notNull((Object)encoderConfig, (String)"Encoder config");
        AssertParameter.notNull((Object)decoderConfig, (String)"Decoder config");
        AssertParameter.notNull((Object)sessionConfig, (String)"Session config");
        AssertParameter.notNull((Object)objectMapperConfig, (String)"Object mapper config");
        AssertParameter.notNull((Object)jsonConfig, (String)"Json config");
        AssertParameter.notNull((Object)xmlConfig, (String)"Xml config");
        AssertParameter.notNull((Object)headerConfig, (String)"Header config");
        AssertParameter.notNull((Object)multiPartConfig, (String)"MultiPart config");
        AssertParameter.notNull((Object)mockMvcConfig, (String)"MockMvc config");
        AssertParameter.notNull((Object)((Object)paramConfig), (String)"Param config");
        this.logConfig = logConfig;
        this.encoderConfig = encoderConfig;
        this.decoderConfig = decoderConfig;
        this.sessionConfig = sessionConfig;
        this.objectMapperConfig = objectMapperConfig;
        this.jsonConfig = jsonConfig;
        this.xmlConfig = xmlConfig;
        this.headerConfig = headerConfig;
        this.asyncConfig = asyncConfig;
        this.multiPartConfig = multiPartConfig;
        this.mockMvcConfig = mockMvcConfig;
        this.paramConfig = paramConfig;
    }

    public RestAssuredMockMvcConfig logConfig(LogConfig logConfig) {
        AssertParameter.notNull((Object)logConfig, (String)"Log config");
        return new RestAssuredMockMvcConfig(logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.mockMvcConfig, this.paramConfig);
    }

    public RestAssuredMockMvcConfig sessionConfig(SessionConfig sessionConfig) {
        AssertParameter.notNull((Object)sessionConfig, (String)"Session config");
        return new RestAssuredMockMvcConfig(this.logConfig, this.encoderConfig, this.decoderConfig, sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.mockMvcConfig, this.paramConfig);
    }

    public RestAssuredMockMvcConfig objectMapperConfig(ObjectMapperConfig objectMapperConfig) {
        AssertParameter.notNull((Object)objectMapperConfig, (String)"Object mapper config");
        return new RestAssuredMockMvcConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.mockMvcConfig, this.paramConfig);
    }

    public RestAssuredMockMvcConfig jsonConfig(JsonConfig jsonConfig) {
        AssertParameter.notNull((Object)jsonConfig, (String)"JsonConfig");
        return new RestAssuredMockMvcConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.mockMvcConfig, this.paramConfig);
    }

    public RestAssuredMockMvcConfig xmlConfig(XmlConfig xmlConfig) {
        AssertParameter.notNull((Object)xmlConfig, (String)"XmlConfig");
        return new RestAssuredMockMvcConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.mockMvcConfig, this.paramConfig);
    }

    public RestAssuredMockMvcConfig encoderConfig(EncoderConfig encoderConfig) {
        AssertParameter.notNull((Object)encoderConfig, (String)"EncoderConfig");
        return new RestAssuredMockMvcConfig(this.logConfig, encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.mockMvcConfig, this.paramConfig);
    }

    public RestAssuredMockMvcConfig decoderConfig(DecoderConfig decoderConfig) {
        AssertParameter.notNull((Object)this.encoderConfig, DecoderConfig.class);
        return new RestAssuredMockMvcConfig(this.logConfig, this.encoderConfig, decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.mockMvcConfig, this.paramConfig);
    }

    public RestAssuredMockMvcConfig headerConfig(HeaderConfig headerConfig) {
        AssertParameter.notNull((Object)headerConfig, (String)"HeaderConfig");
        return new RestAssuredMockMvcConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, headerConfig, this.asyncConfig, this.multiPartConfig, this.mockMvcConfig, this.paramConfig);
    }

    public RestAssuredMockMvcConfig asyncConfig(AsyncConfig asyncConfig) {
        AssertParameter.notNull((Object)asyncConfig, AsyncConfig.class);
        return new RestAssuredMockMvcConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, asyncConfig, this.multiPartConfig, this.mockMvcConfig, this.paramConfig);
    }

    public RestAssuredMockMvcConfig mockMvcConfig(MockMvcConfig mockMvcConfig) {
        AssertParameter.notNull((Object)mockMvcConfig, MockMvcConfig.class);
        return new RestAssuredMockMvcConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, mockMvcConfig, this.paramConfig);
    }

    public RestAssuredMockMvcConfig multiPartConfig(MultiPartConfig multiPartConfig) {
        AssertParameter.notNull((Object)multiPartConfig, MultiPartConfig.class);
        return new RestAssuredMockMvcConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, multiPartConfig, this.mockMvcConfig, this.paramConfig);
    }

    public ClientConfig getClientConfig() {
        return this.getMockMvcConfig();
    }

    public SpecificationConfig clientConfig(ClientConfig clientConfig) {
        if (!(clientConfig instanceof MockMvcConfig)) {
            throw new IllegalArgumentException("Wrong ClientConfig type supplied");
        }
        return this.mockMvcConfig((MockMvcConfig)clientConfig);
    }

    public RestAssuredMockMvcConfig paramConfig(MockMvcParamConfig paramConfig) {
        AssertParameter.notNull((Object)((Object)paramConfig), MultiPartConfig.class);
        return new RestAssuredMockMvcConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.mockMvcConfig, paramConfig);
    }

    public RestAssuredMockMvcConfig and() {
        return this;
    }

    public RestAssuredMockMvcConfig set() {
        return this;
    }

    public RestAssuredMockMvcConfig with() {
        return this;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public EncoderConfig getEncoderConfig() {
        return this.encoderConfig;
    }

    public DecoderConfig getDecoderConfig() {
        return this.decoderConfig;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public ObjectMapperConfig getObjectMapperConfig() {
        return this.objectMapperConfig;
    }

    public JsonConfig getJsonConfig() {
        return this.jsonConfig;
    }

    public XmlConfig getXmlConfig() {
        return this.xmlConfig;
    }

    public HeaderConfig getHeaderConfig() {
        return this.headerConfig;
    }

    public AsyncConfig getAsyncConfig() {
        return this.asyncConfig;
    }

    public MultiPartConfig getMultiPartConfig() {
        return this.multiPartConfig;
    }

    public ParamConfig getParamConfig() {
        return this.paramConfig;
    }

    public SpecificationConfig paramConfig(ParamConfig paramConfig) {
        if (!(paramConfig instanceof MockMvcParamConfig)) {
            throw new IllegalArgumentException("Wrong ClientConfig type supplied");
        }
        return this.paramConfig((MockMvcParamConfig)paramConfig);
    }

    public MockMvcParamConfig getMockMvcParamConfig() {
        return this.paramConfig;
    }

    public MockMvcConfig getMockMvcConfig() {
        return this.mockMvcConfig;
    }

    public static RestAssuredMockMvcConfig newConfig() {
        return new RestAssuredMockMvcConfig();
    }

    public static RestAssuredMockMvcConfig config() {
        return new RestAssuredMockMvcConfig();
    }

    public boolean isUserConfigured() {
        return this.decoderConfig.isUserConfigured() || this.encoderConfig.isUserConfigured() || this.logConfig.isUserConfigured() || this.sessionConfig.isUserConfigured() || this.objectMapperConfig.isUserConfigured() || this.xmlConfig.isUserConfigured() || this.jsonConfig.isUserConfigured() || this.headerConfig.isUserConfigured() || this.asyncConfig.isUserConfigured() || this.multiPartConfig.isUserConfigured() || this.mockMvcConfig.isUserConfigured() || this.paramConfig.isUserConfigured();
    }
}

