/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.local;

import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.local.LocalClientTransport;
import io.rsocket.transport.local.LocalServerTransport;
import io.rsocket.uri.UriHandler;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

public final class LocalUriHandler
implements UriHandler {
    private static final String SCHEME = "local";

    public Optional<ClientTransport> buildClient(URI uri) {
        Objects.requireNonNull(uri, "uri must not be null");
        if (!SCHEME.equals(uri.getScheme())) {
            return Optional.empty();
        }
        return Optional.of(LocalClientTransport.create(uri.getSchemeSpecificPart()));
    }

    public Optional<ServerTransport> buildServer(URI uri) {
        Objects.requireNonNull(uri, "uri must not be null");
        if (!SCHEME.equals(uri.getScheme())) {
            return Optional.empty();
        }
        return Optional.of(LocalServerTransport.create(uri.getSchemeSpecificPart()));
    }
}

