/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.local;

import io.rsocket.DuplexConnection;
import io.rsocket.Frame;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.local.LocalDuplexConnection;
import io.rsocket.transport.local.LocalServerTransport;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.publisher.UnicastProcessor;

public final class LocalClientTransport
implements ClientTransport {
    private final String name;

    private LocalClientTransport(String name) {
        this.name = name;
    }

    public static LocalClientTransport create(String name) {
        Objects.requireNonNull(name, "name must not be null");
        return new LocalClientTransport(name);
    }

    public Mono<DuplexConnection> connect() {
        return Mono.defer(() -> {
            LocalServerTransport.ServerDuplexConnectionAcceptor server = LocalServerTransport.findServer(this.name);
            if (server == null) {
                return Mono.error((Throwable)new IllegalArgumentException("Could not find server: " + this.name));
            }
            UnicastProcessor in = UnicastProcessor.create();
            UnicastProcessor out = UnicastProcessor.create();
            MonoProcessor closeNotifier = MonoProcessor.create();
            server.accept(new LocalDuplexConnection((Flux<Frame>)out, (Subscriber<Frame>)in, (MonoProcessor<Void>)closeNotifier));
            return Mono.just((Object)new LocalDuplexConnection((Flux<Frame>)in, (Subscriber<Frame>)out, (MonoProcessor<Void>)closeNotifier));
        });
    }
}

