/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.auth;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"username", "password", "metadata"})
public class BasicAuthDefinition
implements Serializable {
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="String or a workflow expression. Contains the user name")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="String or a workflow expression. Contains the user password")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String password;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Metadata")
    @Valid
    private Map<String, String> metadata;
    private static final long serialVersionUID = -6123191764856682930L;

    public BasicAuthDefinition() {
    }

    public BasicAuthDefinition(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public BasicAuthDefinition withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    public BasicAuthDefinition withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public BasicAuthDefinition withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }
}

