/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.functions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"workflowId", "version", "onParentComplete", "invoke"})
public class SubFlowRef
implements Serializable {
    @JsonProperty(value="workflowId")
    @JsonPropertyDescription(value="Unique id of the sub-workflow to be invoked")
    @NotNull
    private String workflowId;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Version of the sub-workflow to be invoked")
    @Size(min=1)
    private @Size(min=1) String version;
    @JsonProperty(value="onParentComplete")
    @JsonPropertyDescription(value="If invoke is 'async', specifies how subflow execution should behave when parent workflow completes. Default is 'terminate'")
    private OnParentComplete onParentComplete = OnParentComplete.fromValue("terminate");
    @JsonProperty(value="invoke")
    @JsonPropertyDescription(value="Specifies if the function should be invoked sync or async. Default is sync.")
    private Invoke invoke = Invoke.fromValue("sync");
    private static final long serialVersionUID = -1437306479472092902L;

    public SubFlowRef() {
    }

    public SubFlowRef(String workflowId) {
        this.workflowId = workflowId;
    }

    @JsonProperty(value="workflowId")
    public String getWorkflowId() {
        return this.workflowId;
    }

    @JsonProperty(value="workflowId")
    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public SubFlowRef withWorkflowId(String workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    public SubFlowRef withVersion(String version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="onParentComplete")
    public OnParentComplete getOnParentComplete() {
        return this.onParentComplete;
    }

    @JsonProperty(value="onParentComplete")
    public void setOnParentComplete(OnParentComplete onParentComplete) {
        this.onParentComplete = onParentComplete;
    }

    public SubFlowRef withOnParentComplete(OnParentComplete onParentComplete) {
        this.onParentComplete = onParentComplete;
        return this;
    }

    @JsonProperty(value="invoke")
    public Invoke getInvoke() {
        return this.invoke;
    }

    @JsonProperty(value="invoke")
    public void setInvoke(Invoke invoke) {
        this.invoke = invoke;
    }

    public SubFlowRef withInvoke(Invoke invoke) {
        this.invoke = invoke;
        return this;
    }

    public static enum OnParentComplete {
        CONTINUE("continue"),
        TERMINATE("terminate");

        private final String value;
        private static final Map<String, OnParentComplete> CONSTANTS;

        private OnParentComplete(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OnParentComplete fromValue(String value) {
            OnParentComplete constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, OnParentComplete>();
            for (OnParentComplete c : OnParentComplete.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Invoke {
        SYNC("sync"),
        ASYNC("async");

        private final String value;
        private static final Map<String, Invoke> CONSTANTS;

        private Invoke(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Invoke fromValue(String value) {
            Invoke constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Invoke>();
            for (Invoke c : Invoke.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

