/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.states;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.serverlessworkflow.api.actions.Action;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.timeouts.TimeoutsDefinition;
import io.serverlessworkflow.api.transitions.Transition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"inputCollection", "outputCollection", "iterationParam", "batchSize", "actions", "usedForCompensation", "mode"})
public class ForEachState
extends DefaultState
implements Serializable,
State {
    @JsonProperty(value="inputCollection")
    @JsonPropertyDescription(value="Workflow expression selecting an array element of the states data")
    private String inputCollection;
    @JsonProperty(value="outputCollection")
    @JsonPropertyDescription(value="Workflow expression specifying an array element of the states data to add the results of each iteration")
    private String outputCollection;
    @JsonProperty(value="iterationParam")
    @JsonPropertyDescription(value="Name of the iteration parameter that can be referenced in actions/workflow. For each parallel iteration, this param should contain an unique element of the inputCollection array")
    private String iterationParam;
    @JsonProperty(value="batchSize")
    @JsonPropertyDescription(value="Specifies how many iterations may run in parallel at the same time. Used if 'mode' property is set to 'parallel' (default)")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") int batchSize = 0;
    @JsonProperty(value="actions")
    @JsonPropertyDescription(value="Actions to be executed for each of the elements of inputCollection")
    @Valid
    private List<Action> actions = new ArrayList<Action>();
    @JsonProperty(value="usedForCompensation")
    @JsonPropertyDescription(value="If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    @JsonProperty(value="mode")
    @JsonPropertyDescription(value="Specifies how iterations are to be performed (sequentially or in parallel)")
    private Mode mode = Mode.fromValue("parallel");
    private static final long serialVersionUID = -7003790626872816580L;

    public ForEachState() {
    }

    public ForEachState(String name, DefaultState.Type type) {
        super(name, type);
    }

    @JsonProperty(value="inputCollection")
    public String getInputCollection() {
        return this.inputCollection;
    }

    @JsonProperty(value="inputCollection")
    public void setInputCollection(String inputCollection) {
        this.inputCollection = inputCollection;
    }

    public ForEachState withInputCollection(String inputCollection) {
        this.inputCollection = inputCollection;
        return this;
    }

    @JsonProperty(value="outputCollection")
    public String getOutputCollection() {
        return this.outputCollection;
    }

    @JsonProperty(value="outputCollection")
    public void setOutputCollection(String outputCollection) {
        this.outputCollection = outputCollection;
    }

    public ForEachState withOutputCollection(String outputCollection) {
        this.outputCollection = outputCollection;
        return this;
    }

    @JsonProperty(value="iterationParam")
    public String getIterationParam() {
        return this.iterationParam;
    }

    @JsonProperty(value="iterationParam")
    public void setIterationParam(String iterationParam) {
        this.iterationParam = iterationParam;
    }

    public ForEachState withIterationParam(String iterationParam) {
        this.iterationParam = iterationParam;
        return this;
    }

    @JsonProperty(value="batchSize")
    public int getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="batchSize")
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public ForEachState withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @JsonProperty(value="actions")
    public List<Action> getActions() {
        return this.actions;
    }

    @JsonProperty(value="actions")
    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public ForEachState withActions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    @JsonProperty(value="usedForCompensation")
    public boolean isUsedForCompensation() {
        return this.usedForCompensation;
    }

    @JsonProperty(value="usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public ForEachState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @JsonProperty(value="mode")
    public Mode getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public ForEachState withMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    @Override
    public ForEachState withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ForEachState withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ForEachState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public ForEachState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public ForEachState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public ForEachState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public ForEachState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public ForEachState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public ForEachState withCompensatedBy(String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }

    @Override
    public ForEachState withTimeouts(TimeoutsDefinition timeouts) {
        super.withTimeouts(timeouts);
        return this;
    }

    public static enum Mode {
        SEQUENTIAL("sequential"),
        PARALLEL("parallel");

        private final String value;
        private static final Map<String, Mode> CONSTANTS;

        private Mode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Mode fromValue(String value) {
            Mode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Mode>();
            for (Mode c : Mode.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

