/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.states;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.serverlessworkflow.api.branches.Branch;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.timeouts.TimeoutsDefinition;
import io.serverlessworkflow.api.transitions.Transition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"branches", "completionType", "numCompleted", "usedForCompensation"})
public class ParallelState
extends DefaultState
implements Serializable,
State {
    @JsonProperty(value="branches")
    @JsonPropertyDescription(value="Branch Definitions")
    @Valid
    @NotNull
    private List<Branch> branches = new ArrayList<Branch>();
    @JsonProperty(value="completionType")
    @JsonPropertyDescription(value="Option types on how to complete branch execution.")
    private CompletionType completionType = CompletionType.fromValue("allOf");
    @JsonProperty(value="numCompleted")
    @JsonPropertyDescription(value="Used when completionType is set to 'atLeast' to specify the minimum number of branches that must complete before the state will transition.")
    private String numCompleted = "0";
    @JsonProperty(value="usedForCompensation")
    @JsonPropertyDescription(value="If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    private static final long serialVersionUID = 7284092251950973712L;

    public ParallelState() {
    }

    public ParallelState(List<Branch> branches, String name, DefaultState.Type type) {
        super(name, type);
        this.branches = branches;
    }

    @JsonProperty(value="branches")
    public List<Branch> getBranches() {
        return this.branches;
    }

    @JsonProperty(value="branches")
    public void setBranches(List<Branch> branches) {
        this.branches = branches;
    }

    public ParallelState withBranches(List<Branch> branches) {
        this.branches = branches;
        return this;
    }

    @JsonProperty(value="completionType")
    public CompletionType getCompletionType() {
        return this.completionType;
    }

    @JsonProperty(value="completionType")
    public void setCompletionType(CompletionType completionType) {
        this.completionType = completionType;
    }

    public ParallelState withCompletionType(CompletionType completionType) {
        this.completionType = completionType;
        return this;
    }

    @JsonProperty(value="numCompleted")
    public String getNumCompleted() {
        return this.numCompleted;
    }

    @JsonProperty(value="numCompleted")
    public void setNumCompleted(String numCompleted) {
        this.numCompleted = numCompleted;
    }

    public ParallelState withNumCompleted(String numCompleted) {
        this.numCompleted = numCompleted;
        return this;
    }

    @JsonProperty(value="usedForCompensation")
    public boolean isUsedForCompensation() {
        return this.usedForCompensation;
    }

    @JsonProperty(value="usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public ParallelState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @Override
    public ParallelState withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ParallelState withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ParallelState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public ParallelState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public ParallelState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public ParallelState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public ParallelState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public ParallelState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public ParallelState withCompensatedBy(String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }

    @Override
    public ParallelState withTimeouts(TimeoutsDefinition timeouts) {
        super.withTimeouts(timeouts);
        return this;
    }

    public static enum CompletionType {
        ALL_OF("allOf"),
        AT_LEAST("atLeast");

        private final String value;
        private static final Map<String, CompletionType> CONSTANTS;

        private CompletionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CompletionType fromValue(String value) {
            CompletionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CompletionType>();
            for (CompletionType c : CompletionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

