/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.agent.net;

import io.sf.carte.doc.agent.OriginPolicy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

public class DefaultOriginPolicy
implements OriginPolicy {
    private static final List<String> TOP_LEVEL_SUFFIX = new ArrayList<String>();
    private static final List<String> SUFFIX_EXCEPTIONS = new ArrayList<String>();
    private static final List<String> SUFFIX_WILDCARDS = new ArrayList<String>();

    private DefaultOriginPolicy() {
    }

    private static void readSuffixes() {
        BufferedReader re = null;
        try {
            re = new BufferedReader(new InputStreamReader(DefaultOriginPolicy.openStream("/io/sf/carte/doc/agent/net/public_suffix_list.dat"), "utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String line = null;
        try {
            while ((line = re.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("//")) continue;
                if (line.charAt(0) == '*') {
                    SUFFIX_WILDCARDS.add(line.substring(2));
                    continue;
                }
                if (line.charAt(0) == '!') {
                    SUFFIX_EXCEPTIONS.add(line.substring(1));
                    continue;
                }
                TOP_LEVEL_SUFFIX.add(line);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                re.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static InputStream openStream(final String fileName) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return DefaultOriginPolicy.class.getResourceAsStream(fileName);
            }
        });
    }

    public static DefaultOriginPolicy getInstance() {
        return DefaultOriginPolicyHolder.HOLDER;
    }

    public boolean isTopLevelSuffix(String possibleTld) {
        if (TOP_LEVEL_SUFFIX.contains(possibleTld) || SUFFIX_WILDCARDS.contains(possibleTld)) {
            return true;
        }
        int idx = possibleTld.indexOf(46);
        return idx > 0 && SUFFIX_WILDCARDS.contains(possibleTld.substring(idx + 1)) && !SUFFIX_EXCEPTIONS.contains(possibleTld);
    }

    public String domainFromHostname(String host) {
        String domain = host;
        int count = host.length();
        for (int idx = count - 1; idx >= 0; --idx) {
            String possibleTld;
            if (domain.charAt(idx) != '.' || this.isTopLevelSuffix(possibleTld = domain.subSequence(idx + 1, count).toString())) continue;
            return possibleTld;
        }
        return host;
    }

    static {
        DefaultOriginPolicy.readSuffixes();
    }

    private static class DefaultOriginPolicyHolder {
        static final DefaultOriginPolicy HOLDER = new DefaultOriginPolicy();

        private DefaultOriginPolicyHolder() {
        }
    }
}

