/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.agent.net;

import io.sf.carte.doc.DocumentException;
import io.sf.carte.doc.agent.AbstractUserAgent;
import io.sf.carte.doc.agent.AgentUtil;
import io.sf.carte.doc.agent.UserAgent;
import io.sf.carte.doc.agent.net.DefaultOriginPolicy;
import io.sf.carte.doc.dom.CSSDOMImplementation;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.HTMLDocument;
import io.sf.carte.doc.dom.XMLDocumentBuilder;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.nsac.Parser2;
import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.EnumSet;
import nu.validator.htmlparser.dom.HtmlDocumentBuilder;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultUserAgent
extends AbstractUserAgent {
    private final CSSDOMImplementation domImpl;
    private EntityResolver resolver = this.createEntityResolver();

    protected DefaultUserAgent(EnumSet<Parser2.Flag> parserFlags, boolean setDefaultSheet) {
        super(parserFlags);
        this.setOriginPolicy(DefaultOriginPolicy.getInstance());
        this.domImpl = new MyDOMImplementation(this.getParserFlags());
        if (setDefaultSheet) {
            this.domImpl.setDefaultHTMLUserAgentSheet();
        }
    }

    public static UserAgent createUserAgent(EnumSet<Parser2.Flag> parserFlags, boolean setDefaultSheet) {
        return new DefaultUserAgent(parserFlags, setDefaultSheet);
    }

    protected EntityResolver createEntityResolver() {
        return new DefaultEntityResolver();
    }

    public CSSDOMImplementation getDOMImplementation() {
        return this.domImpl;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    public DOMDocument readURL(URL url) throws IOException, DocumentException {
        String referrerPolicy;
        HtmlDocumentBuilder builder;
        long time = System.currentTimeMillis();
        URLConnection con = this.openConnection(url, time);
        con.connect();
        String conType = con.getContentType();
        String contentEncoding = con.getContentEncoding();
        InputStream is = null;
        MyDocument htmlDoc = null;
        boolean isHtml = true;
        if (conType != null) {
            int i = conType.indexOf(59);
            String mimeType = i == -1 ? conType.trim() : conType.substring(0, i).trim();
            isHtml = mimeType.equals("text/html");
        }
        if (isHtml) {
            builder = new HtmlDocumentBuilder((DOMImplementation)this.domImpl);
        } else {
            XMLDocumentBuilder xmlbuilder = new XMLDocumentBuilder((DOMImplementation)this.domImpl);
            xmlbuilder.setIgnoreElementContentWhitespace(true);
            xmlbuilder.setEntityResolver(this.resolver);
            builder = xmlbuilder;
        }
        try {
            is = this.openInputStream(con);
            InputSource source = new InputSource(AgentUtil.inputStreamToReader((InputStream)is, (String)conType, (String)contentEncoding, (String)"utf-8"));
            htmlDoc = (MyDocument)((Object)builder.parse(source));
        }
        catch (IOException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new DocumentException("Error parsing HTML document at " + url.toExternalForm(), (Throwable)e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        htmlDoc.setDocumentURI(url.toExternalForm());
        htmlDoc.setLoadingTime(time);
        String defStyle = con.getHeaderField("Default-Style");
        NodeList list = htmlDoc.getElementsByTagName("meta");
        int listL = list.getLength();
        for (int i = listL - 1; i >= 0; --i) {
            String metaDefStyle;
            if (!"Default-Style".equalsIgnoreCase(((Element)list.item(i)).getAttribute("http-equiv")) || (metaDefStyle = ((Element)list.item(i)).getAttribute("content")).length() != 0) continue;
            defStyle = metaDefStyle;
        }
        if (defStyle != null) {
            htmlDoc.setSelectedStyleSheetSet(defStyle);
        }
        if ((referrerPolicy = con.getHeaderField("Referrer-Policy")) != null) {
            htmlDoc.setReferrerPolicyHeader(referrerPolicy);
        }
        if (con instanceof HttpURLConnection) {
            HttpURLConnection hcon = (HttpURLConnection)con;
            this.readCookies(hcon, time);
            hcon.disconnect();
        }
        return (DOMDocument)htmlDoc;
    }

    protected InputStream openInputStream(URLConnection con) throws IOException {
        return con.getInputStream();
    }

    class MyDOMImplementation
    extends CSSDOMImplementation {
        MyDOMImplementation(EnumSet<Parser2.Flag> parserFlags) {
            super(parserFlags);
        }

        public DOMDocument createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
            MyDocument document = namespaceURI == null || namespaceURI.equals("http://www.w3.org/1999/xhtml") || doctype != null && "html".equalsIgnoreCase(doctype.getName()) ? new MyHTMLDocument(doctype) : new MyXMLDocument(doctype);
            if (!this.getStrictErrorChecking()) {
                document.setStrictErrorChecking(false);
            }
            if (qualifiedName != null && qualifiedName.length() != 0) {
                document.appendChild((Node)document.createElementNS(namespaceURI, qualifiedName));
            }
            return document;
        }

        class MyHTMLDocument
        extends HTMLDocument
        implements MyDocument {
            private long loadingTime;

            public MyHTMLDocument(DocumentType documentType) {
                super(documentType);
            }

            public CSSDOMImplementation getImplementation() {
                return MyDOMImplementation.this;
            }

            public URLConnection openConnection(URL url) throws IOException {
                return DefaultUserAgent.this.openConnection(url, this.loadingTime);
            }

            public boolean isVisitedURI(String href) {
                try {
                    return DefaultUserAgent.this.isVisitedURL(this.getURL(href));
                }
                catch (MalformedURLException e) {
                    return false;
                }
            }

            @Override
            public void setLoadingTime(long time) {
                this.loadingTime = time;
            }

            @Override
            public void setReferrerPolicyHeader(String policy) {
                super.setReferrerPolicyHeader(policy);
            }

            protected CSSDOMImplementation getStyleSheetFactory() {
                return MyDOMImplementation.this;
            }
        }

        class MyXMLDocument
        extends DOMDocument
        implements MyDocument {
            private long loadingTime;

            public MyXMLDocument(DocumentType documentType) {
                super(documentType);
            }

            public CSSDOMImplementation getImplementation() {
                return MyDOMImplementation.this;
            }

            public URLConnection openConnection(URL url) throws IOException {
                return DefaultUserAgent.this.openConnection(url, this.loadingTime);
            }

            public boolean isVisitedURI(String href) {
                try {
                    return DefaultUserAgent.this.isVisitedURL(this.getURL(href));
                }
                catch (MalformedURLException e) {
                    return false;
                }
            }

            @Override
            public void setLoadingTime(long time) {
                this.loadingTime = time;
            }

            @Override
            public void setReferrerPolicyHeader(String policy) {
                super.setReferrerPolicyHeader(policy);
            }

            protected CSSDOMImplementation getStyleSheetFactory() {
                return MyDOMImplementation.this;
            }
        }
    }

    static interface MyDocument
    extends CSSDocument {
        public void setLoadingTime(long var1);

        public void setReferrerPolicyHeader(String var1);
    }
}

