/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.agent.net;

import io.sf.carte.doc.agent.IllegalOriginException;
import io.sf.carte.doc.agent.net.DownloadListener;
import io.sf.carte.doc.agent.net.ResourceAgent;
import io.sf.carte.doc.style.css.CSSDocument;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public abstract class ResourceDownloader<C>
extends Thread {
    private final URL url;
    protected C nativeContent = null;
    protected List<DownloadListener<C>> listeners = new LinkedList<DownloadListener<C>>();
    private String contentType = null;
    private boolean done = false;

    protected ResourceDownloader(URL url) {
        this.url = url;
    }

    protected ResourceDownloader(CSSFontFaceRule rule) throws IllegalArgumentException {
        URL[] urlist = ResourceDownloader.extractURL(rule.getStyle());
        if (urlist == null) {
            throw new IllegalArgumentException("No URLs to download font");
        }
        this.url = urlist[0];
    }

    private static URL[] extractURL(CSSStyleDeclaration style) throws IllegalArgumentException {
        CSSValue src = style.getPropertyCSSValue("src");
        if (src == null) {
            return null;
        }
        return ResourceDownloader.extractURL(src);
    }

    private static URL[] extractURL(CSSValue src) {
        short type = src.getCssValueType();
        if (type == 1) {
            if (((CSSPrimitiveValue)src).getPrimitiveType() == 20) {
                URL url;
                try {
                    url = new URL(((CSSPrimitiveValue)src).getStringValue());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Bad URL to download font", e);
                }
                return new URL[]{url};
            }
        } else if (type == 2) {
            LinkedList<URL> urlist = new LinkedList<URL>();
            CSSValueList list = (CSSValueList)src;
            for (int i = 0; i < list.getLength(); ++i) {
                URL[] url = ResourceDownloader.extractURL(list.item(i));
                if (url == null) continue;
                for (int j = 0; j < url.length; ++j) {
                    urlist.add(url[j]);
                }
            }
            if (!urlist.isEmpty()) {
                return urlist.toArray(new URL[0]);
            }
        }
        return null;
    }

    public URL getURL() {
        return this.url;
    }

    public void addListener(DownloadListener<C> listener) {
        if (this.done) {
            if (this.nativeContent == null) {
                listener.doFailedDownload();
            } else {
                listener.doContentDownloaded(this.nativeContent);
            }
        } else {
            this.listeners.add(listener);
        }
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public void run() {
        try {
            InputStream is = this.openStream();
            if (is == null) {
                this.notifyFailure(new IOException("Cannot open URL " + this.getURL().toExternalForm()));
            }
            this.readContent(is);
            is.close();
            this.done = true;
            this.notifyDownload();
        }
        catch (IOException e) {
            this.notifyFailure(e);
        }
        this.listeners.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected InputStream openStream() throws IOException {
        URLConnection con;
        CSSDocument doc = null;
        if (!this.listeners.isEmpty()) {
            int nl = this.listeners.size();
            for (int i = 0; i < nl && (doc = this.listeners.get(i).getDocument()) == null; ++i) {
            }
        }
        if (doc != null) {
            if (!doc.isSafeOrigin(this.getURL())) throw new IllegalOriginException("Illegal origin: " + this.getURL().toExternalForm());
            con = doc.openConnection(this.getURL());
        } else {
            con = this.getURL().openConnection();
        }
        this.contentType = con.getContentType();
        return con.getInputStream();
    }

    public String getContentType() {
        return this.contentType;
    }

    protected abstract void readContent(InputStream var1) throws IOException;

    protected abstract ResourceAgent<C, ?> getResourceAgent();

    protected void notifyDownload() {
        Iterator<DownloadListener<C>> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().doContentDownloaded(this.nativeContent);
        }
        this.nativeContent = null;
    }

    protected void notifyFailure(Exception e) {
        Iterator<DownloadListener<C>> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().doFailedDownload();
        }
    }

    public C getNativeContent() {
        return this.nativeContent;
    }
}

