/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.XHTMLDocumentFactory;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.MediaQueryFactory;
import io.sf.carte.doc.style.css.om.OMMediaList;
import java.util.Iterator;
import org.w3c.dom.css.CSSRule;

public abstract class DOM4JCSSStyleSheet
extends BaseCSSStyleSheet
implements Cloneable {
    CSSElement ownerElement;

    public DOM4JCSSStyleSheet(String title, CSSElement ownerElement, MediaQueryList media, CSSRule ownerRule, short origin) {
        super(title, media, ownerRule, origin);
        this.ownerElement = ownerElement;
    }

    public String getHref() {
        String href = super.getHref();
        if (href == null) {
            return this.ownerElement.getOwnerDocument().getBaseURL().toExternalForm();
        }
        return href;
    }

    public CSSElement getOwnerNode() {
        return this.ownerElement;
    }

    protected String getTargetMedium() {
        if (this.ownerElement != null) {
            return this.ownerElement.getOwnerDocument().getStyleSheet().getTargetMedium();
        }
        return null;
    }

    void setDestinationMedia(String media) {
        if (media == null && !this.destinationMedia.isAllMedia() || !this.destinationMedia.getMediaText().equals(media)) {
            OMMediaList mediaList;
            if (media == null || media.trim().length() == 0) {
                mediaList = OMMediaList.createMediaList();
            } else {
                mediaList = MediaQueryFactory.createMediaList((String)media);
                if (mediaList.isNotAllMedia() && mediaList.hasErrors()) {
                    this.getStyleSheetFactory().getErrorHandler().mediaQueryError(media);
                }
            }
            this.destinationMedia = mediaList;
        }
    }

    public DOM4JCSSStyleSheet clone() {
        DOM4JCSSStyleSheet myClone = ((XHTMLDocumentFactory.DOM4JCSSStyleSheetFactory)this.getStyleSheetFactory()).createCSSStyleSheet(this.getTitle(), this.getOwnerNode(), this.getMedia(), this.getOwnerRule(), this.getOrigin());
        myClone.currentInsertionIndex = this.currentInsertionIndex;
        myClone.setDisabled(this.getDisabled());
        myClone.setHref(this.getHref());
        myClone.namespaces = this.namespaces;
        myClone.setParentStyleSheet(this.getParentStyleSheet());
        myClone.cssRules = new CSSRuleArrayList(this.cssRules.getLength());
        int i = 0;
        Iterator it = this.cssRules.iterator();
        while (it.hasNext()) {
            myClone.cssRules.add(((AbstractCSSRule)it.next()).clone((AbstractCSSStyleSheet)myClone, i++));
        }
        return myClone;
    }
}

