/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.CSSStylableElement;
import io.sf.carte.doc.dom4j.DOM4JCSSStyleDeclaration;
import io.sf.carte.doc.dom4j.XHTMLDocument;
import io.sf.carte.doc.dom4j.XHTMLDocumentFactory;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.InlineStyle;
import java.util.Iterator;
import org.w3c.dom.Node;

public abstract class DOM4JDocumentCSSStyleSheet
extends BaseDocumentCSSStyleSheet {
    private XHTMLDocument ownerElement = null;

    DOM4JDocumentCSSStyleSheet(short origin) {
        super(null, origin);
    }

    protected DOM4JDocumentCSSStyleSheet(String medium, short origin) {
        super(medium, origin);
    }

    public String getHref() {
        return this.ownerElement != null ? this.ownerElement.getBaseURI() : null;
    }

    public XHTMLDocument getOwnerNode() {
        return this.ownerElement;
    }

    public void setOwnerDocument(CSSDocument owner) {
        this.ownerElement = (XHTMLDocument)owner;
    }

    public abstract XHTMLDocumentFactory.DOM4JCSSStyleSheetFactory getStyleSheetFactory();

    public ComputedCSSStyle getComputedStyle(CSSElement elm, String pseudoElt) {
        InlineStyle inline = (InlineStyle)elm.getStyle();
        DOM4JCSSStyleDeclaration styledecl = this.getStyleSheetFactory().createComputedStyle();
        styledecl.setOwnerNode((Node)((Object)this.getOwnerNode()));
        ComputedCSSStyle style = this.computeStyle(styledecl, ((CSSStylableElement)elm).getSelectorMatcher(), pseudoElt, inline);
        ((DOM4JCSSStyleDeclaration)style).setOwnerNode((Node)elm);
        return style;
    }

    public DOM4JDocumentCSSStyleSheet clone() {
        DOM4JDocumentCSSStyleSheet myClone = this.getStyleSheetFactory().createDocumentStyleSheet(this.getTargetMedium(), this.getOrigin());
        myClone.setOwnerDocument(this.ownerElement);
        myClone.currentInsertionIndex = this.currentInsertionIndex;
        myClone.setDisabled(this.getDisabled());
        myClone.namespaces = this.namespaces;
        myClone.setParentStyleSheet(this.getParentStyleSheet());
        myClone.cssRules = new CSSRuleArrayList(this.cssRules.getLength());
        int i = 0;
        Iterator it = this.cssRules.iterator();
        while (it.hasNext()) {
            myClone.cssRules.add(((AbstractCSSRule)it.next()).clone((AbstractCSSStyleSheet)myClone, i++));
        }
        return myClone;
    }

    public DOM4JDocumentCSSStyleSheet clone(String targetMedium) {
        DOM4JDocumentCSSStyleSheet myClone = this.getStyleSheetFactory().createDocumentStyleSheet(targetMedium, this.getOrigin());
        myClone.setOwnerDocument(this.ownerElement);
        this.copyTo(myClone);
        return myClone;
    }
}

