/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.XHTMLElement;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.InlineStyle;
import org.dom4j.QName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;

class FontElement
extends XHTMLElement {
    private static final long serialVersionUID = 2L;

    FontElement(String name) {
        super(name);
    }

    FontElement(QName qname) {
        super(qname);
    }

    FontElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    @Override
    public CSSStyleDeclaration getStyle() {
        BaseCSSStyleDeclaration styledecl = (BaseCSSStyleDeclaration)super.getStyle();
        InlineStyle defstyle = this.getDocumentFactory().getStyleSheetFactory().createInlineStyle((Node)((Object)this));
        StringBuilder equivStyle = new StringBuilder(64);
        String attr = this.attributeValue("face");
        if (attr != null && attr.length() > 0) {
            equivStyle.append("font-family: ").append(attr).append("; ");
        }
        if ((attr = this.attributeValue("size")) != null && attr.length() > 0) {
            equivStyle.append("font-size: ").append(this.translateFontSize(attr)).append("; ");
        }
        if ((attr = this.attributeValue("color")) != null && attr.length() > 0) {
            equivStyle.append("color: ").append(attr).append(";");
        }
        if (equivStyle.length() > 0) {
            try {
                defstyle.setCssText(equivStyle.toString());
            }
            catch (DOMException e) {
                this.getDocumentFactory().getStyleSheetFactory().getErrorHandler().onException((Exception)e, (Element)((Object)this));
            }
            defstyle.addStyle(styledecl);
            styledecl = defstyle;
        }
        return styledecl;
    }

    private CharSequence translateFontSize(CharSequence size) {
        if (size.charAt(0) == '+') {
            return "larger";
        }
        if (size.charAt(0) == '-') {
            return "smaller";
        }
        return size;
    }
}

