/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.dom;

import io.sf.carte.doc.style.css.SACParserFactory;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.dom.AbstractCSSRule;
import io.sf.carte.doc.style.css.dom.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.BaseCSSRule;
import io.sf.carte.doc.style.css.dom.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.dom.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.dom.CSSRuleArrayList;
import io.sf.carte.doc.style.css.dom.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.dom.DOMCSSFontFaceRule;
import io.sf.carte.doc.style.css.dom.DOMCSSImportRule;
import io.sf.carte.doc.style.css.dom.DOMCSSMediaRule;
import io.sf.carte.doc.style.css.dom.DOMCSSPageRule;
import io.sf.carte.doc.style.css.dom.DOMCSSStyleRule;
import io.sf.carte.doc.style.css.dom.DOMMediaList;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.stylesheets.StyleSheet;

public abstract class BaseCSSStyleSheet
extends AbstractCSSStyleSheet {
    private StyleSheet parent = null;
    private String href = null;
    private CSSRule ownerRule = null;
    private short sheetOrigin;
    protected CSSRuleArrayList cssRules = new CSSRuleArrayList();
    protected int currentInsertionIndex = 0;
    protected DOMMediaList destinationMedia;
    protected Map<String, String> namespaces = new HashMap<String, String>();
    private boolean disabled = false;
    private SheetErrorHandler sheetErrorHandler;

    protected BaseCSSStyleSheet(String title, DOMMediaList media, CSSRule ownerRule, short origin) {
        super(title);
        this.ownerRule = ownerRule;
        this.destinationMedia = media;
        this.sheetErrorHandler = this.getStyleSheetFactory().createSheetErrorHandler();
        this.sheetOrigin = origin;
    }

    protected BaseCSSStyleSheet(BaseCSSStyleSheet copyMe) {
        super(copyMe.getTitle());
        this.ownerRule = copyMe.ownerRule;
        this.destinationMedia = copyMe.destinationMedia;
        this.sheetOrigin = copyMe.sheetOrigin;
        this.sheetErrorHandler = copyMe.getStyleSheetFactory().createSheetErrorHandler();
    }

    @Override
    public abstract BaseCSSStyleSheetFactory getStyleSheetFactory();

    @Override
    public CSSRule getOwnerRule() {
        return this.ownerRule;
    }

    @Override
    public Node getOwnerNode() {
        return null;
    }

    @Override
    public DOMMediaList getMedia() {
        return this.destinationMedia;
    }

    @Override
    public short getOrigin() {
        return this.sheetOrigin;
    }

    @Override
    public CSSRuleArrayList getCssRules() {
        return this.cssRules;
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        if (index > this.getCssRules().getLength() || index < 0) {
            throw new DOMException(1, "Invalid index: " + index);
        }
        InputSource source = new InputSource();
        StringReader re = new StringReader(rule);
        source.setCharacterStream((Reader)re);
        Parser psr = this.createSACParser();
        psr.setDocumentHandler(this.createDocumentHandler(this.getOrigin()));
        this.currentInsertionIndex = index - 1;
        try {
            psr.parseRule(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return this.currentInsertionIndex;
    }

    @Override
    public void addRule(AbstractCSSRule cssrule) {
        cssrule.setParentStyleSheet(this);
        this.addLocalRule(cssrule);
    }

    protected void addLocalRule(CSSRule cssrule) {
        this.currentInsertionIndex = this.cssRules.insertRule(cssrule, ++this.currentInsertionIndex);
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        try {
            this.cssRules.remove(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DOMException(1, e.getMessage());
        }
    }

    @Override
    public DOMCSSStyleRule createCSSStyleRule() {
        return new DOMCSSStyleRule(this, this.getOrigin());
    }

    @Override
    public DOMCSSFontFaceRule createCSSFontFaceRule() {
        return new DOMCSSFontFaceRule(this, this.getOrigin());
    }

    @Override
    public DOMCSSImportRule createCSSImportRule(DOMMediaList mediaList) {
        return new DOMCSSImportRule((AbstractCSSStyleSheet)this, mediaList.unmodifiable(), this.getOrigin());
    }

    @Override
    public DOMCSSMediaRule createCSSMediaRule(DOMMediaList mediaList) {
        return new DOMCSSMediaRule((AbstractCSSStyleSheet)this, mediaList, this.getOrigin());
    }

    @Override
    public DOMCSSPageRule createCSSPageRule() {
        return new DOMCSSPageRule(this, this.getOrigin());
    }

    @Override
    protected BaseCSSStyleDeclaration createCSSStyleDeclaration(CSSStyleDeclarationRule rule) {
        return new BaseCSSStyleDeclaration(rule);
    }

    @Override
    public BaseCSSStyleDeclaration createCSSStyleDeclaration() {
        return new BaseCSSStyleDeclaration();
    }

    @Override
    public SheetErrorHandler getErrorHandler() {
        return this.sheetErrorHandler;
    }

    @Override
    public String getType() {
        return "text/css";
    }

    public String getNamespaceURI(String prefix) {
        return this.namespaces.get(prefix);
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public StyleSheet getParentStyleSheet() {
        return this.parent;
    }

    public void setParentStyleSheet(StyleSheet parent) {
        this.parent = parent;
    }

    @Override
    public String getHref() {
        if (this.href == null && this.ownerRule != null) {
            return this.ownerRule.getParentStyleSheet().getHref();
        }
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void addStyleSheet(AbstractCSSStyleSheet sheet) {
        if (!sheet.getDisabled()) {
            DOMMediaList mediaList = sheet.getMedia();
            int localrl = this.getCssRules().getLength();
            if (mediaList.getLength() == 0) {
                CSSRuleArrayList otherRules = sheet.getCssRules();
                int orl = otherRules.getLength();
                for (int i = 0; i < orl; ++i) {
                    this.addLocalRule(otherRules.item(i).clone(sheet, localrl + i));
                }
            } else {
                boolean nouri = sheet.getHref() == null;
                DOMCSSMediaRule mrule = this.createCSSMediaRule(mediaList);
                CSSRuleArrayList otherRules = sheet.getCssRules();
                int orl = otherRules.getLength();
                for (int i = 0; i < orl; ++i) {
                    AbstractCSSRule orule = nouri ? otherRules.item(i).clone(this, localrl) : otherRules.item(i).clone(sheet, localrl);
                    orule.setParentRule(mrule);
                    mrule.addRule(orule);
                }
                this.addLocalRule(mrule);
            }
        }
    }

    public boolean loadStyleSheet(URL url) throws CSSException, IOException {
        boolean result;
        PushbackReader re;
        int iread;
        int idx;
        URLConnection ucon = this.openConnection(url);
        InputStream is = ucon.getInputStream();
        String charset = null;
        String conType = ucon.getContentType();
        if (conType == null) {
            try {
                conType = URLConnection.guessContentTypeFromStream(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (conType != null && (idx = conType.indexOf("charset=")) >= 0) {
            charset = conType.substring(idx + 8);
        }
        if ((iread = (re = charset != null ? new PushbackReader(new InputStreamReader(is, charset), 1) : new PushbackReader(new InputStreamReader(is, "utf-8"), 1)).read()) != -1 && iread == 0xEFBBBF) {
            charset = "utf-8";
        } else {
            re.unread(iread);
        }
        InputSource source = new InputSource((Reader)re);
        try {
            result = this.parseCSSStyleSheet(source);
            this.setHref(url.toExternalForm());
        }
        catch (DOMException e) {
            throw new CSSException((Exception)e);
        }
        catch (CSSException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (ucon instanceof HttpURLConnection) {
            ((HttpURLConnection)ucon).disconnect();
        }
        return result;
    }

    protected String getTargetMedium() {
        return null;
    }

    @Override
    public String toMinifiedString() {
        return this.getCssRules().toMinifiedString();
    }

    public String toString() {
        return this.getCssRules().toString();
    }

    @Override
    public String toStyleString() {
        String rules = this.getCssRules().toString();
        StringBuilder buf = new StringBuilder(rules.length() + 60);
        buf.append("<style type=\"text/css\"");
        if (!this.destinationMedia.isAllMedia()) {
            buf.append(" media=\"").append(this.destinationMedia.getMediaText()).append('\"');
        }
        if (this.getTitle() != null) {
            buf.append(" title=\"").append(this.getTitle()).append('\"');
        }
        buf.append(">\n").append(rules).append("\n</style>\n");
        return buf.toString();
    }

    DocumentHandler createDocumentHandler(short origin) {
        return new CSSDocumentHandler(origin);
    }

    protected Parser createSACParser() throws DOMException {
        return SACParserFactory.createSACParser();
    }

    @Override
    public boolean parseCSSStyleSheet(InputSource source) throws DOMException, IOException {
        this.getErrorHandler().reset();
        short origin = this.getOrigin();
        for (AbstractCSSRule rule : this.getCssRules()) {
            short ruleo = rule.getOrigin();
            if (ruleo >= origin) continue;
            origin = ruleo;
        }
        Parser parser = this.createSACParser();
        DocumentHandler handler = this.createDocumentHandler(origin);
        parser.setDocumentHandler(handler);
        parser.setErrorHandler((ErrorHandler)handler);
        parser.parseStyleSheet(source);
        return !this.getErrorHandler().hasSacErrors();
    }

    class CSSDocumentHandler
    implements DocumentHandler,
    ErrorHandler {
        private BaseCSSRule currentRule = null;
        private short sheetOrigin;
        private boolean ignoreRulesForMedia = false;
        private boolean ignoreImports = false;

        CSSDocumentHandler(short origin) {
            this.sheetOrigin = origin;
        }

        public void startDocument(InputSource source) throws CSSException {
            this.currentRule = null;
            this.ignoreRulesForMedia = false;
            this.ignoreImports = false;
        }

        public void endDocument(InputSource source) throws CSSException {
        }

        public void comment(String text) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
            BaseCSSStyleSheet.this.namespaces.put(prefix, uri);
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException, DOMException {
            if (this.ignoreImports) {
                SheetErrorHandler eh = BaseCSSStyleSheet.this.getErrorHandler();
                if (eh != null) {
                    eh.ignoredImport(uri);
                }
                return;
            }
            if (BaseCSSStyleSheet.this.destinationMedia.match(media)) {
                DOMCSSImportRule imp = new DOMCSSImportRule(BaseCSSStyleSheet.this, this.sheetOrigin);
                try {
                    imp.loadStyleSheet(uri, BaseCSSStyleSheet.this.getTitle(), media);
                }
                catch (CSSException e) {
                    throw new CSSException((Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new CSSException((Exception)e);
                }
            }
        }

        public void startMedia(SACMediaList media) throws CSSException {
            this.ignoreImports = true;
            if (media.getLength() > 0) {
                if (BaseCSSStyleSheet.this.destinationMedia.match(media)) {
                    this.currentRule = new DOMCSSMediaRule((AbstractCSSStyleSheet)BaseCSSStyleSheet.this, media, this.sheetOrigin);
                } else {
                    this.ignoreRulesForMedia = true;
                }
            } else {
                SheetErrorHandler eh = BaseCSSStyleSheet.this.getErrorHandler();
                if (eh != null) {
                    eh.emptyMediaList();
                }
                this.ignoreRulesForMedia = true;
            }
        }

        public void endMedia(SACMediaList media) throws CSSException {
            if (this.ignoreRulesForMedia) {
                this.ignoreRulesForMedia = false;
            } else {
                BaseCSSStyleSheet.this.addLocalRule(this.currentRule);
            }
            this.currentRule = null;
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            this.ignoreImports = true;
            if (!this.ignoreRulesForMedia) {
                this.currentRule = new DOMCSSPageRule(BaseCSSStyleSheet.this, this.sheetOrigin);
                if (pseudo_page != null) {
                    Parser parser = BaseCSSStyleSheet.this.createSACParser();
                    InputSource source = new InputSource((Reader)new StringReader(pseudo_page));
                    try {
                        ((DOMCSSPageRule)this.currentRule).setSelectorList(parser.parseSelectors(source));
                    }
                    catch (IOException iOException) {}
                } else {
                    ((DOMCSSPageRule)this.currentRule).setSelectorText("");
                }
            }
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
            if (!this.ignoreRulesForMedia) {
                BaseCSSStyleSheet.this.addLocalRule(this.currentRule);
                this.currentRule = null;
            }
        }

        public void startFontFace() throws CSSException {
            this.ignoreImports = true;
            if (!this.ignoreRulesForMedia) {
                this.currentRule = new DOMCSSFontFaceRule(BaseCSSStyleSheet.this, this.sheetOrigin);
            }
        }

        public void endFontFace() throws CSSException {
            if (!this.ignoreRulesForMedia) {
                BaseCSSStyleSheet.this.addLocalRule(this.currentRule);
                this.currentRule = null;
            }
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            this.ignoreImports = true;
            if (!this.ignoreRulesForMedia) {
                DOMCSSStyleRule styleRule = BaseCSSStyleSheet.this.createCSSStyleRule();
                if (this.currentRule != null) {
                    styleRule.setParentRule(this.currentRule);
                }
                this.currentRule = styleRule;
                ((CSSStyleDeclarationRule)this.currentRule).setSelectorList(selectors);
            }
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            if (!this.ignoreRulesForMedia && this.currentRule instanceof DOMCSSStyleRule) {
                BaseCSSRule pRule = (BaseCSSRule)this.currentRule.getParentRule();
                if (((DOMCSSStyleRule)this.currentRule).getStyle().getLength() == 0) {
                    SheetErrorHandler eh = BaseCSSStyleSheet.this.getErrorHandler();
                    if (eh != null) {
                        eh.emptyRule(((DOMCSSStyleRule)this.currentRule).getSelectorText());
                    }
                } else if (pRule == null) {
                    BaseCSSStyleSheet.this.addLocalRule(this.currentRule);
                } else {
                    ((DOMCSSMediaRule)pRule).addRule(this.currentRule);
                }
                this.currentRule = pRule;
            }
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            if (!this.ignoreRulesForMedia) {
                String importantString = null;
                importantString = important ? "important" : "";
                ((BaseCSSStyleDeclaration)((CSSStyleDeclarationRule)this.currentRule).getStyle()).setProperty(name, value, importantString);
            }
        }

        public void warning(CSSParseException exception) throws CSSException {
            if (this.currentRule != null && this.currentRule instanceof DOMCSSStyleRule && ((DOMCSSStyleRule)this.currentRule).getStyleDeclarationErrorHandler() != null) {
                int previousIndex = -1;
                CSSStyleDeclaration style = ((DOMCSSStyleRule)this.currentRule).getStyle();
                if (style != null) {
                    previousIndex = style.getLength() - 1;
                }
                ((DOMCSSStyleRule)this.currentRule).getStyleDeclarationErrorHandler().sacWarning(exception, previousIndex);
            } else {
                BaseCSSStyleSheet.this.getErrorHandler().handleSacWarning(exception);
            }
        }

        public void error(CSSParseException exception) throws CSSException {
            if (this.currentRule != null && this.currentRule instanceof DOMCSSStyleRule && ((DOMCSSStyleRule)this.currentRule).getStyleDeclarationErrorHandler() != null) {
                int previousIndex = -1;
                CSSStyleDeclaration style = ((DOMCSSStyleRule)this.currentRule).getStyle();
                if (style != null) {
                    previousIndex = style.getLength() - 1;
                }
                ((DOMCSSStyleRule)this.currentRule).getStyleDeclarationErrorHandler().sacError(exception, previousIndex);
                BaseCSSStyleSheet.this.getErrorHandler().mapError(exception, this.currentRule);
            } else {
                BaseCSSStyleSheet.this.getErrorHandler().handleSacError(exception);
            }
        }

        public void fatalError(CSSParseException exception) throws CSSException {
            if (this.currentRule != null && this.currentRule instanceof DOMCSSStyleRule && ((DOMCSSStyleRule)this.currentRule).getStyleDeclarationErrorHandler() != null) {
                int previousIndex = -1;
                CSSStyleDeclaration style = ((DOMCSSStyleRule)this.currentRule).getStyle();
                if (style != null) {
                    previousIndex = style.getLength() - 1;
                }
                ((DOMCSSStyleRule)this.currentRule).getStyleDeclarationErrorHandler().sacFatalError(exception, previousIndex);
                BaseCSSStyleSheet.this.getErrorHandler().mapError(exception, this.currentRule);
            } else {
                BaseCSSStyleSheet.this.getErrorHandler().handleSacError(exception);
            }
        }
    }
}

