/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.dom;

import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSStyleSheetFactory;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.dom.AbstractCSSRule;
import io.sf.carte.doc.style.css.dom.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.dom.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.dom.CSSRuleArrayList;
import io.sf.carte.doc.style.css.dom.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.dom.DOMCSSStyleRule;
import io.sf.carte.doc.style.css.dom.DOMMediaList;
import io.sf.carte.doc.style.css.dom.DefaultSheetErrorHandler;
import io.sf.carte.doc.style.css.dom.DefaultStyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.dom.SystemDefaultValue;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.RGBColor;

public abstract class BaseCSSStyleSheetFactory
implements CSSStyleSheetFactory {
    private static final String HTML_DEFAULT_SHEET = "/io/sf/carte/doc/style/css/html.css";
    private ClassLoader classLoader = null;
    private final byte complianceMode;
    private AbstractCSSStyleSheet userImportantSheet = null;
    private AbstractCSSStyleSheet userNormalSheet = null;

    protected BaseCSSStyleSheetFactory(byte complianceMode) {
        this.complianceMode = complianceMode;
    }

    @Override
    public abstract DocumentCSSStyleSheet createDocumentStyleSheet(short var1);

    @Override
    public AbstractCSSStyleSheet createStyleSheet(String title, String media) {
        DOMMediaList mediaList = media == null || media.equals("all") ? DOMMediaList.create() : DOMMediaList.create(media);
        return this.createLinkedStyleSheet(null, title, mediaList);
    }

    @Override
    public abstract AbstractCSSStyleSheet createRuleStyleSheet(AbstractCSSRule var1, String var2, DOMMediaList var3);

    @Override
    public abstract AbstractCSSStyleSheet createLinkedStyleSheet(CSSElement var1, String var2, DOMMediaList var3);

    @Override
    public abstract AbstractCSSStyleDeclaration createAnonymousStyleDeclaration(Node var1, CSSElement var2);

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    @Override
    public void setUserStyleSheet(Reader re) throws IOException {
        if (re != null) {
            AbstractCSSStyleSheet cssSheet;
            try {
                InputSource source = new InputSource(re);
                cssSheet = (AbstractCSSStyleSheet)((Object)this.createDocumentStyleSheet((short)9));
                cssSheet.parseCSSStyleSheet(source);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                try {
                    re.close();
                }
                catch (IOException iOException) {}
            }
            this.userImportantSheet = (AbstractCSSStyleSheet)((Object)this.createDocumentStyleSheet((short)3));
            this.userNormalSheet = (AbstractCSSStyleSheet)((Object)this.createDocumentStyleSheet((short)9));
            BaseCSSStyleSheetFactory.prioritySplit(cssSheet, this.userImportantSheet, this.userNormalSheet);
        } else {
            this.userImportantSheet = null;
            this.userNormalSheet = null;
        }
    }

    protected AbstractCSSStyleSheet getUserImportantStyleSheet() {
        return this.userImportantSheet;
    }

    protected AbstractCSSStyleSheet getUserNormalStyleSheet() {
        return this.userNormalSheet;
    }

    static void prioritySplit(AbstractCSSStyleSheet cssSheet, AbstractCSSStyleSheet importantSheet, AbstractCSSStyleSheet normalSheet) {
        AbstractCSSStyleDeclaration userImportantStyle = cssSheet.createCSSStyleDeclaration();
        AbstractCSSStyleDeclaration userNormalStyle = cssSheet.createCSSStyleDeclaration();
        CSSRuleArrayList rules = cssSheet.getCssRules();
        int rl = rules.getLength();
        for (int i = 0; i < rl; ++i) {
            AbstractCSSRule r = rules.item(i);
            if (r.getType() == 1) {
                BaseCSSStyleDeclaration style;
                CSSStyleDeclarationRule newrule;
                userImportantStyle.clear();
                userNormalStyle.clear();
                DOMCSSStyleRule rule = (DOMCSSStyleRule)r;
                CSSStyleDeclaration st = rule.getStyle();
                ((AbstractCSSStyleDeclaration)st).prioritySplit(userImportantStyle, userNormalStyle);
                if (!userImportantStyle.isEmpty()) {
                    newrule = importantSheet.createCSSStyleRule();
                    newrule.setSelectorList(rule.getSelectorList());
                    style = (BaseCSSStyleDeclaration)newrule.getStyle();
                    style.setProperties((BaseCSSStyleDeclaration)userImportantStyle);
                    importantSheet.addRule(newrule);
                }
                if (userNormalStyle.isEmpty()) continue;
                newrule = normalSheet.createCSSStyleRule();
                newrule.setSelectorList(rule.getSelectorList());
                style = (BaseCSSStyleDeclaration)newrule.getStyle();
                style.setProperties((BaseCSSStyleDeclaration)userNormalStyle);
                normalSheet.addRule(newrule);
                continue;
            }
            normalSheet.addRule(r.clone(normalSheet, i));
        }
    }

    @Override
    public abstract void setDefaultHTMLUserAgentSheet();

    public DocumentCSSStyleSheet loadXHTMLDefaultSheet() throws IOException {
        return this.loadDefaultSheet(this.loadCSSfromClasspath(HTML_DEFAULT_SHEET));
    }

    private DocumentCSSStyleSheet loadDefaultSheet(InputStream is) throws IOException {
        DocumentCSSStyleSheet cssSheet;
        InputStreamReader re = null;
        try {
            re = new InputStreamReader(is, "UTF-8");
            InputSource source = new InputSource((Reader)re);
            cssSheet = this.createDocumentStyleSheet((short)16);
            cssSheet.parseCSSStyleSheet(source);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (re != null) {
                try {
                    ((Reader)re).close();
                }
                catch (IOException iOException) {}
            }
        }
        return cssSheet;
    }

    private InputStream loadCSSfromClasspath(final String cssFilename) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                if (BaseCSSStyleSheetFactory.this.classLoader != null) {
                    return BaseCSSStyleSheetFactory.this.classLoader.getResourceAsStream(BaseCSSStyleSheetFactory.resourcePath(BaseCSSStyleSheetFactory.class.getPackage().getName(), cssFilename));
                }
                return this.getClass().getResourceAsStream(cssFilename);
            }
        });
    }

    private static String resourcePath(String clase, String filename) {
        return '/' + clase.replace('.', '/') + '/' + filename;
    }

    @Override
    public byte getComplianceMode() {
        return this.complianceMode;
    }

    @Override
    public AbstractCSSPrimitiveValue getSystemDefaultValue(String propertyName) {
        if (this.complianceMode == 0) {
            CSSPrimitiveValue value = null;
            if ("color".equals(propertyName = propertyName.toLowerCase(Locale.US)) || propertyName.endsWith("-color")) {
                value = (CSSPrimitiveValue)((Object)AbstractCSSValue.parseProperty("#ffffff"));
            } else if ("font-family".equals(propertyName)) {
                value = (CSSPrimitiveValue)((Object)AbstractCSSValue.parseProperty("serif"));
            }
            if (value == null) {
                return new SafeSystemDefaultValue(value);
            }
        }
        return SystemDefaultValue.getInstance();
    }

    @Override
    public StyleDeclarationErrorHandler createStyleDeclarationErrorHandler(CSSStyleDeclarationRule rule) {
        return new DefaultStyleDeclarationErrorHandler();
    }

    @Override
    public SheetErrorHandler createSheetErrorHandler() {
        return new DefaultSheetErrorHandler();
    }

    protected abstract ErrorHandler createErrorHandler();

    @Override
    public abstract ErrorHandler getErrorHandler();

    private class SafeSystemDefaultValue
    extends SystemDefaultValue {
        private CSSPrimitiveValue defvalue;

        SafeSystemDefaultValue(CSSPrimitiveValue defvalue) {
        }

        @Override
        public String getCssText() {
            return this.defvalue.getCssText();
        }

        @Override
        public short getPrimitiveType() {
            return this.defvalue.getPrimitiveType();
        }

        @Override
        public String getStringValue() throws DOMException {
            return this.defvalue.getStringValue();
        }

        @Override
        public RGBColor getRGBColorValue() throws DOMException {
            return this.defvalue.getRGBColorValue();
        }

        @Override
        public float getFloatValue(short unitType) throws DOMException {
            return this.defvalue.getFloatValue(unitType);
        }
    }
}

