/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.dom;

import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSRuleListener;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.dom.AbstractCSSRule;
import io.sf.carte.doc.style.css.dom.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.dom.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.CSSRuleArrayList;
import io.sf.carte.doc.style.css.dom.ComputedCSSStyle;
import io.sf.carte.doc.style.css.dom.DOMCSSFontFaceRule;
import io.sf.carte.doc.style.css.dom.DOMCSSImportRule;
import io.sf.carte.doc.style.css.dom.DOMCSSMediaRule;
import io.sf.carte.doc.style.css.dom.DOMCSSStyleRule;
import io.sf.carte.doc.style.css.dom.DOMMediaList;
import io.sf.carte.doc.style.css.dom.SelectorMatcher;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;

public abstract class BaseDocumentCSSStyleSheet
extends BaseCSSStyleSheet {
    private String targetMedium = null;

    protected BaseDocumentCSSStyleSheet(String medium, short origin) {
        super(null, DOMMediaList.createUnmodifiable(medium), null, origin);
        this.targetMedium = "all".equals(medium) ? null : medium;
    }

    @Override
    public void setHref(String href) {
        throw new IllegalStateException("Document sheet's href is parent document href");
    }

    @Override
    public String getHref() {
        return this.getOwnerNode() != null ? this.getOwnerNode().getBaseURI() : null;
    }

    @Override
    public abstract CSSDocument getOwnerNode();

    protected void copyTo(BaseDocumentCSSStyleSheet myCopy) {
        if (myCopy.getTargetMedium() == null) {
            throw new NullPointerException();
        }
        if (!this.getMedia().matchMedium(myCopy.getTargetMedium())) {
            throw new IllegalArgumentException("Incompatible target medium: " + this.targetMedium);
        }
        myCopy.currentInsertionIndex = this.currentInsertionIndex;
        myCopy.setDisabled(this.getDisabled());
        myCopy.namespaces = this.namespaces;
        myCopy.setParentStyleSheet(this.getParentStyleSheet());
        myCopy.cssRules = new CSSRuleArrayList(this.cssRules.getLength());
        int i = 0;
        for (AbstractCSSRule rule : this.cssRules) {
            short type = rule.getType();
            if (type == 4 && !((DOMCSSMediaRule)rule).getMedia().matchMedium(this.targetMedium) || type == 3 && !((DOMCSSImportRule)rule).getMedia().matchMedium(this.targetMedium)) continue;
            myCopy.cssRules.add(rule.clone(myCopy, i++));
        }
    }

    @Override
    public String getTargetMedium() {
        return this.targetMedium;
    }

    public abstract CSSStyleDeclaration getComputedStyle(CSSElement var1, String var2);

    protected ComputedCSSStyle computeStyle(ComputedCSSStyle style, SelectorMatcher matcher, ComputedCSSStyle inlineStyle, String pseudoElt) {
        AbstractCSSStyleSheet userImportantStyleSheet;
        SheetErrorHandler eh;
        if (this.getDisabled()) {
            return style;
        }
        matcher.setPseudoElement(pseudoElt);
        Cascade matchingStyles = new Cascade();
        matchingStyles.cascade(matcher, this.getTargetMedium(), this.cssRules);
        Iterator<DOMCSSStyleRule> styleit = matchingStyles.iterator();
        if (!styleit.hasNext() && (eh = this.getErrorHandler()) != null) {
            eh.emptyCascade(matcher.toString());
        }
        while (styleit.hasNext()) {
            DOMCSSStyleRule rule = styleit.next();
            style.addStyle((BaseCSSStyleDeclaration)rule.getStyle());
        }
        if (!inlineStyle.isEmpty()) {
            style.addStyle(inlineStyle);
        }
        CSSElement elt = (CSSElement)inlineStyle.getOwnerNode();
        if (inlineStyle.hasOverrideStyle(pseudoElt)) {
            style.addStyle((BaseCSSStyleDeclaration)elt.getOwnerDocument().getOverrideStyle(elt, pseudoElt));
        }
        if ((userImportantStyleSheet = this.getStyleSheetFactory().getUserImportantStyleSheet()) != null) {
            Cascade usercascade = new Cascade();
            usercascade.cascade(matcher, this.getTargetMedium(), userImportantStyleSheet.getCssRules());
            styleit = usercascade.iterator();
            while (styleit.hasNext()) {
                DOMCSSStyleRule rule = styleit.next();
                style.addStyle((BaseCSSStyleDeclaration)rule.getStyle());
            }
        }
        return style;
    }

    static class Cascade {
        private SortedMap<DOMCSSStyleRule.RuleSpecifity, LinkedList<DOMCSSStyleRule>> matchingStyles = new TreeMap<DOMCSSStyleRule.RuleSpecifity, LinkedList<DOMCSSStyleRule>>(new DOMCSSStyleRule.SpecificityComparator());

        Cascade() {
        }

        void cascade(SelectorMatcher matcher, String targetMedium, CSSRuleArrayList list) {
            for (CSSRule rule : list) {
                if (!(rule instanceof DOMCSSStyleRule)) {
                    if (rule instanceof DOMCSSMediaRule) {
                        this.scanMediaRule(matcher, targetMedium, (DOMCSSMediaRule)rule);
                        continue;
                    }
                    if (rule instanceof DOMCSSImportRule) {
                        this.scanImportRule(matcher, targetMedium, (DOMCSSImportRule)rule);
                        continue;
                    }
                    if (!(rule instanceof DOMCSSFontFaceRule)) continue;
                    this.processFontFaceRule((DOMCSSFontFaceRule)rule);
                    continue;
                }
                DOMCSSStyleRule stylerule = (DOMCSSStyleRule)rule;
                int selIdx = matcher.match(stylerule.getSelectorList());
                if (selIdx < 0) continue;
                this.add(stylerule.getSpecifity(selIdx));
            }
        }

        private void scanMediaRule(SelectorMatcher matcher, String targetMedium, DOMCSSMediaRule mediaRule) {
            DOMMediaList mediaList = mediaRule.getMedia();
            if (targetMedium != null && mediaList.matchMedium(targetMedium)) {
                CSSRuleArrayList ruleList = mediaRule.getCssRules();
                int rll = ruleList.getLength();
                for (int i = 0; i < rll; ++i) {
                    DOMCSSStyleRule stylerule;
                    int selIdx;
                    if (!(ruleList.item(i) instanceof DOMCSSStyleRule) || (selIdx = matcher.match((stylerule = (DOMCSSStyleRule)ruleList.item(i)).getSelectorList())) < 0) continue;
                    this.add(stylerule.getSpecifity(selIdx));
                }
            }
        }

        private void scanImportRule(SelectorMatcher matcher, String targetMedium, DOMCSSImportRule importRule) {
            AbstractCSSStyleSheet sheet;
            DOMMediaList mediaList = importRule.getMedia();
            if ((mediaList.isAllMedia() || targetMedium != null && mediaList.matchMedium(targetMedium)) && (sheet = importRule.getStyleSheet()) != null) {
                CSSRuleArrayList ruleList = sheet.getCssRules();
                int rll = ruleList.getLength();
                for (int i = 0; i < rll; ++i) {
                    DOMCSSStyleRule stylerule;
                    int selIdx;
                    if (!(ruleList.item(i) instanceof DOMCSSStyleRule) || (selIdx = matcher.match((stylerule = (DOMCSSStyleRule)ruleList.item(i)).getSelectorList())) < 0) continue;
                    this.add(stylerule.getSpecifity(selIdx));
                }
            }
        }

        private void processFontFaceRule(DOMCSSFontFaceRule rule) {
            Document doc = rule.getParentStyleSheet().getOwnerNode().getOwnerDocument();
            if (doc instanceof CSSRuleListener) {
                ((CSSRuleListener)((Object)doc)).onFontFaceRule(rule);
            }
        }

        void add(DOMCSSStyleRule.RuleSpecifity sp) {
            if (this.matchingStyles.containsKey(sp)) {
                ((LinkedList)this.matchingStyles.get(sp)).add(sp.getCSSStyleRule());
            } else {
                LinkedList<DOMCSSStyleRule> matchingRules = new LinkedList<DOMCSSStyleRule>();
                matchingRules.add(sp.getCSSStyleRule());
                this.matchingStyles.put(sp, matchingRules);
            }
        }

        Iterator<DOMCSSStyleRule> iterator() {
            return new RuleIterator();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            Iterator<DOMCSSStyleRule> it = this.iterator();
            while (it.hasNext()) {
                DOMCSSStyleRule rule = it.next();
                buf.append(rule.getOrigin()).append(": ").append(rule.getCssText()).append('\n');
            }
            return buf.toString();
        }

        class RuleIterator
        implements Iterator<DOMCSSStyleRule> {
            private Iterator<DOMCSSStyleRule.RuleSpecifity> keyit;
            private Iterator<DOMCSSStyleRule> currentList;

            RuleIterator() {
                this.keyit = Cascade.this.matchingStyles.keySet().iterator();
                if (this.keyit.hasNext()) {
                    this.findCurrentList();
                } else {
                    this.currentList = null;
                }
            }

            private void findCurrentList() {
                while (this.currentList == null || !this.currentList.hasNext()) {
                    if (this.keyit.hasNext()) {
                        this.currentList = ((LinkedList)Cascade.this.matchingStyles.get(this.keyit.next())).iterator();
                        continue;
                    }
                    this.currentList = null;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                return this.currentList != null;
            }

            @Override
            public DOMCSSStyleRule next() {
                if (this.currentList != null && this.currentList.hasNext()) {
                    DOMCSSStyleRule thenext = this.currentList.next();
                    this.findCurrentList();
                    return thenext;
                }
                throw new NoSuchElementException();
            }
        }
    }
}

