/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.dom;

import io.sf.carte.doc.style.css.StyleDatabaseRequiredException;
import io.sf.carte.doc.style.css.dom.ComputedCSSStyle;
import io.sf.carte.doc.style.css.property.CSSNumberValue;

public class BoxModelHelper {
    public static String contractSpaces(String t) {
        int tl = t.length();
        StringBuffer sb = new StringBuffer(tl);
        int ini = 0;
        int fin = 0;
        while ((ini = t.indexOf("  ", fin)) != -1) {
            sb.append(t.substring(fin, ini));
            fin = ini;
            while (++fin < tl && t.charAt(fin) == ' ') {
            }
            --fin;
        }
        sb.append(t.substring(fin));
        return sb.toString();
    }

    public static int computeMinimumCharsWidth(String text) {
        int tlen = text.length();
        int maxsz = 0;
        int j = 0;
        int i = 0;
        while (i < tlen) {
            if (!Character.isLetterOrDigit(text.charAt(i))) {
                int k = i - j;
                if (k > maxsz) {
                    maxsz = k;
                }
                j = i;
                ++j;
                while (j < tlen && !Character.isLetterOrDigit(text.charAt(j))) {
                    ++j;
                }
                i = j;
                continue;
            }
            ++i;
        }
        if (j > 0) {
            if (tlen - j > maxsz) {
                maxsz = tlen - j;
            }
        } else {
            maxsz = tlen;
        }
        return maxsz;
    }

    public static float computeNodeMinimumWidth(String text, ComputedCSSStyle styledecl, short unitType) {
        float maxsz = BoxModelHelper.computeMinimumCharsWidth(text);
        if (maxsz == 0.0f) {
            return 0.0f;
        }
        if (styledecl.getStyleDatabase() == null) {
            if (unitType < 0) {
                throw new StyleDatabaseRequiredException();
            }
            maxsz *= 0.5f * (float)styledecl.getComputedFontSize();
        } else {
            if (unitType < 0) {
                unitType = styledecl.getStyleDatabase().getNaturalUnit();
            }
            maxsz *= (float)styledecl.getStyleDatabase().getExSizeInPt(styledecl.getUsedFontFamily(), styledecl.getComputedFontSize());
        }
        return CSSNumberValue.floatValueConversion(maxsz, (short)9, unitType);
    }

    public static float computeTextWidth(String text, ComputedCSSStyle styledecl, short unitType) {
        float maxsz = text.length();
        if (maxsz == 0.0f) {
            return 0.0f;
        }
        if (styledecl.getStyleDatabase() == null) {
            if (unitType < 0) {
                throw new StyleDatabaseRequiredException();
            }
            maxsz *= 0.5f * (float)styledecl.getComputedFontSize();
        } else {
            if (unitType < 0) {
                unitType = styledecl.getStyleDatabase().getNaturalUnit();
            }
            maxsz *= (float)styledecl.getStyleDatabase().getExSizeInPt(styledecl.getUsedFontFamily(), styledecl.getComputedFontSize());
        }
        return CSSNumberValue.floatValueConversion(maxsz, (short)9, unitType);
    }
}

