/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.dom;

import io.sf.carte.doc.style.css.dom.AbstractCSSRule;
import io.sf.carte.doc.style.css.dom.RuleStore;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;

public class CSSRuleArrayList
extends ArrayList<AbstractCSSRule>
implements CSSRuleList,
RuleStore {
    private static final long serialVersionUID = 2L;

    public CSSRuleArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public CSSRuleArrayList() {
    }

    public CSSRuleArrayList(Collection<? extends AbstractCSSRule> c) {
        super(c);
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public AbstractCSSRule item(int index) {
        if (index >= this.getLength() || index < 0) {
            return null;
        }
        return (AbstractCSSRule)this.get(index);
    }

    @Override
    public int insertRule(CSSRule cssrule, int index) {
        if (index >= this.size()) {
            index = this.size();
        } else if (index < 0) {
            index = 0;
        }
        this.add(index, (AbstractCSSRule)cssrule);
        ((AbstractCSSRule)cssrule).setInsertionIndex(index);
        for (int i = index + 1; i < this.size(); ++i) {
            ((AbstractCSSRule)this.get(i)).setInsertionIndex(i);
        }
        return index;
    }

    @Override
    public boolean add(AbstractCSSRule rule) {
        rule.setInsertionIndex(this.size());
        return super.add(rule);
    }

    public String toMinifiedString() {
        int sz = this.size();
        StringBuilder sb = new StringBuilder(sz * 20);
        for (int i = 0; i < sz; ++i) {
            sb.append(this.item(i).getMinifiedCssText());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        int sz = this.size();
        StringBuilder sb = new StringBuilder(sz * 20);
        for (int i = 0; i < sz; ++i) {
            sb.append(this.item(i).getCssText()).append('\n');
        }
        return sb.toString();
    }
}

