/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.dom;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.style.css.BoxValues;
import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.StyleDatabaseRequiredException;
import io.sf.carte.doc.style.css.dom.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.dom.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.dom.SimpleBoxModel;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSIdentifierValue;
import io.sf.carte.doc.style.css.property.CSSNumberValue;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.CSSStringValue;
import io.sf.carte.doc.style.css.property.CSSURIValue;
import io.sf.carte.doc.style.css.property.CSSURIValueWrapper;
import io.sf.carte.doc.style.css.property.DOMCSSValueList;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.WrappedValue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public abstract class ComputedCSSStyle
extends BaseCSSStyleDeclaration
implements CSSComputedProperties {
    private Node node = null;

    protected ComputedCSSStyle() {
    }

    protected ComputedCSSStyle(BaseCSSStyleDeclaration copiedObject) {
        super(copiedObject);
    }

    public void setOwnerNode(Node node) {
        this.node = node;
    }

    @Override
    public Node getOwnerNode() {
        return this.node;
    }

    @Override
    protected void setPropertyCSSValue(String propertyName, AbstractCSSValue value, String hrefcontext) {
        if ("background-image".equals(propertyName) || "border-image-source".equals(propertyName)) {
            if (value.getCssValueType() == 2) {
                if (hrefcontext != null) {
                    value = ((DOMCSSValueList)value).wrap(hrefcontext);
                }
            } else if (value.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)value)).getPrimitiveType() == 20 && hrefcontext != null) {
                value = new CSSURIValueWrapper((CSSURIValue)value, hrefcontext);
            }
        }
        super.setPropertyCSSValue(propertyName, value, hrefcontext);
    }

    @Override
    public AbstractCSSValue getCSSValue(String property) throws StyleDatabaseRequiredException {
        AbstractCSSValue value = super.getCSSValue(property);
        boolean inherited = PropertyDatabase.getInstance().isInherited(property);
        CSSComputedProperties ancStyle = this;
        while ((value == null ? inherited : value.getCssValueType() == 0) && (ancStyle = ancStyle.getParentComputedStyle()) != null) {
            value = (AbstractCSSValue)ancStyle.getPropertyCSSValue(property);
        }
        if (value != null && value.getCssValueType() == 0) {
            value = null;
        }
        if (value == null || value.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)value)).getPrimitiveType() == 21 && value.getCssText().equals("initial")) {
            value = this.defaultPropertyValue(property);
        }
        if (value != null) {
            if (value.isSystemDefault()) {
                throw new StyleDatabaseRequiredException("Attempted to compute value for property " + property + ", which has a system-dependent default value set by a subproperty, and no style database was set.");
            }
            if (property.equals("font-family")) {
                value = this.computeFontFamily(property, value);
            } else if ("display".equals(property)) {
                value = this.applyDisplayConstrains(value);
            } else if (property.endsWith("-width")) {
                value = this.applyBorderWidthConstrains(property, value);
            } else if ("background-repeat".equals(property)) {
                value = this.computeBackgroundSubproperty("background-repeat", this.computeBackgroundRepeat(value));
            } else if ("background-position".equals(property) || "background-size".equals(property) || "background-clip".equals(property) || "background-origin".equals(property) || "background-attachment".equals(property)) {
                value = this.computeBackgroundSubproperty(property, value);
            }
            if (!property.equals("font-size")) {
                if (value.getCssValueType() == 2) {
                    DOMCSSValueList list = (DOMCSSValueList)value;
                    int lstlen = list.getLength();
                    for (int i = 0; i < lstlen; ++i) {
                        AbstractCSSValue item = list.item(i);
                        if (!this.isRelativeUnit(item)) continue;
                        this.absoluteValue((CSSNumberValue)list.item(i));
                    }
                } else if (this.isRelativeUnit(value)) {
                    this.absoluteValue((CSSNumberValue)value);
                }
            }
        }
        return value;
    }

    private boolean isRelativeUnit(CSSValue value) {
        CSSPrimitiveValue pri;
        short unit;
        return value.getCssValueType() == 1 && ((unit = (pri = (CSSPrimitiveValue)value).getPrimitiveType()) == 3 || unit == 4);
    }

    private void absoluteValue(CSSNumberValue value) {
        short unit = value.getPrimitiveType();
        float fv = value.getFloatValue(unit);
        if (unit == 3) {
            value.setFloatValuePt(fv * (float)this.getComputedFontSize());
        } else {
            fv = this.getStyleDatabase() != null ? (fv *= (float)this.getStyleDatabase().getExSizeInPt(this.getUsedFontFamily(), this.getComputedFontSize())) : (fv *= (float)this.getComputedFontSize() * 0.5f);
            value.setFloatValuePt(fv);
        }
    }

    private AbstractCSSValue applyDisplayConstrains(AbstractCSSValue value) {
        AbstractCSSValue computedValue = value;
        if (value.getCssValueType() != 1) {
            return value;
        }
        String strVal = ((CSSPrimitiveValue)((Object)value)).getStringValue();
        if (!"none".equals(strVal)) {
            String position = ((CSSPrimitiveValue)((Object)this.getCSSValue("position"))).getStringValue();
            if ("absolute".equals(position) || "fixed".equals(position)) {
                computedValue = this.computeConstrainedDisplay(value);
            } else {
                String floatProp = ((CSSPrimitiveValue)((Object)this.getCSSValue("float"))).getStringValue();
                if (!"none".equals(floatProp)) {
                    computedValue = this.computeConstrainedDisplay(value);
                }
            }
        }
        return computedValue;
    }

    private AbstractCSSValue computeConstrainedDisplay(AbstractCSSValue value) {
        String display = ((CSSPrimitiveValue)((Object)value)).getStringValue();
        if ("inline-table".equals(display)) {
            return AbstractCSSValue.parseProperty("table");
        }
        if ("inline".equals(display) || "run-in".equals(display) || "table-row-group".equals(display) || "table-column".equals(display) || "table-column-group".equals(display) || "table-header-group".equals(display) || "table-footer-group".equals(display) || "table-row".equals(display) || "table-cell".equals(display) || "table-caption".equals(display) || "inline-block".equals(display)) {
            return AbstractCSSValue.parseProperty("block");
        }
        return value;
    }

    private AbstractCSSValue applyBorderWidthConstrains(String property, AbstractCSSValue value) {
        String style = null;
        if (property.equals("border-top-width")) {
            style = this.getCSSValue("border-top-style").getCssText();
        } else if (property.equals("border-right-width")) {
            style = this.getCSSValue("border-top-style").getCssText();
        } else if (property.equals("border-bottom-width")) {
            style = this.getCSSValue("border-top-style").getCssText();
        } else if (property.equals("border-left-width")) {
            style = this.getCSSValue("border-top-style").getCssText();
        }
        if (style != null && (style.equals("none") || style.equals("hidden"))) {
            value = AbstractCSSValue.parseProperty("0");
        }
        return value;
    }

    private AbstractCSSValue computeFontFamily(String property, AbstractCSSValue value) {
        int i;
        CSSStringValue fontFamily;
        CSSValueList fontList = null;
        if (value.getCssValueType() == 2) {
            fontList = (CSSValueList)((Object)value);
            fontFamily = (CSSStringValue)fontList.item(0);
            i = 1;
        } else {
            fontFamily = (CSSStringValue)value;
            i = 0;
        }
        CSSComputedProperties ancStyle = this;
        String requestedFamily = fontFamily.getStringValue();
        while (!this.isFontFamilyAvailable(requestedFamily)) {
            if (i > 0 && i < fontList.getLength()) {
                fontFamily = (CSSStringValue)fontList.item(i);
                ++i;
            } else {
                ancStyle = ancStyle.getParentComputedStyle();
                while (ancStyle != null) {
                    value = ((BaseCSSStyleDeclaration)((Object)ancStyle)).getDeclaredCSSValue(property);
                    if (value == null) {
                        fontFamily = null;
                        break;
                    }
                    if (value.getCssValueType() == 2) {
                        fontList = (CSSValueList)((Object)value);
                        fontFamily = (CSSStringValue)fontList.item(0);
                        i = 1;
                    } else {
                        fontFamily = (CSSStringValue)value;
                        i = 0;
                    }
                    if (value == null) continue;
                }
                if (fontFamily == null) break;
            }
            requestedFamily = fontFamily.getStringValue();
        }
        if (fontFamily == null) {
            requestedFamily = this.getStyleDatabase().getDefaultGenericFontFamily();
        }
        value = new CSSIdentifierValue();
        ((CSSIdentifierValue)value).setStringValue((short)19, requestedFamily);
        return value;
    }

    private AbstractCSSValue computeBackgroundRepeat(AbstractCSSValue value) {
        if (value.getCssValueType() == 2) {
            DOMCSSValueList list = (DOMCSSValueList)value;
            if (list.isCommaSeparated()) {
                for (int i = 0; i < list.getLength(); ++i) {
                    AbstractCSSValue item = list.item(i);
                    if (item.getCssValueType() == 2) continue;
                    list.set(i, this.computeBackgroundRepeatPrimitive(item));
                }
            }
        } else {
            value = this.computeBackgroundRepeatPrimitive(value);
        }
        return value;
    }

    private AbstractCSSValue computeBackgroundRepeatPrimitive(AbstractCSSValue value) {
        DOMCSSValueList list = DOMCSSValueList.createWSValueList();
        String s = value.getCssText();
        if (s.equals("repeat-y")) {
            list.add(AbstractCSSValue.parseProperty("no-repeat"));
            list.add(AbstractCSSValue.parseProperty("repeat"));
        } else if (s.equals("repeat-x")) {
            list.add(AbstractCSSValue.parseProperty("repeat"));
            list.add(AbstractCSSValue.parseProperty("no-repeat"));
        } else if (s.equals("repeat")) {
            list.add(AbstractCSSValue.parseProperty("repeat"));
            list.add(AbstractCSSValue.parseProperty("repeat"));
        } else if (s.equals("no-repeat")) {
            list.add(AbstractCSSValue.parseProperty("no-repeat"));
            list.add(AbstractCSSValue.parseProperty("no-repeat"));
        } else if (s.equals("space")) {
            list.add(AbstractCSSValue.parseProperty("space"));
            list.add(AbstractCSSValue.parseProperty("space"));
        } else if (s.equals("round")) {
            list.add(AbstractCSSValue.parseProperty("round"));
            list.add(AbstractCSSValue.parseProperty("round"));
        } else {
            return value;
        }
        return list;
    }

    private AbstractCSSValue computeBackgroundSubproperty(String propertyName, AbstractCSSValue value) {
        block10: {
            int items;
            DOMCSSValueList list;
            int layers;
            block9: {
                DOMCSSValueList list2;
                AbstractCSSValue bimg = this.getCSSValue("background-image");
                if (bimg == null) {
                    return null;
                }
                layers = 1;
                if (bimg.getCssValueType() == 2 && (list2 = (DOMCSSValueList)bimg).isCommaSeparated()) {
                    layers = list2.getLength();
                }
                if (layers != true) break block9;
                if (value != null) break block10;
                value = PropertyDatabase.getInstance().getInitialValue(propertyName);
                break block10;
            }
            if (value.getCssValueType() == 2 && ((DOMCSSValueList)value).isCommaSeparated()) {
                list = (DOMCSSValueList)value;
                items = list.getLength();
            } else {
                list = DOMCSSValueList.createCSValueList();
                list.add(value);
                value = list;
                items = 1;
            }
            if (layers != items) {
                if (layers < items) {
                    while (items > layers) {
                        list.remove(--items);
                    }
                } else {
                    int j = 0;
                    while (items++ < layers) {
                        list.add(list.item(j++));
                    }
                }
            }
        }
        return value;
    }

    @Override
    public AbstractCSSPrimitiveValue getCSSColor() {
        return (AbstractCSSPrimitiveValue)this.getCSSValue("color");
    }

    @Override
    public CSSPrimitiveValue getCSSBackgroundColor() {
        return (CSSPrimitiveValue)((Object)this.getCSSValue("background-color"));
    }

    @Override
    public String[] getBackgroundImages() {
        CSSStyleDeclarationRule pRule;
        AbstractCSSValue cssVal = this.getCSSValue("background-image");
        if (cssVal == null) {
            return null;
        }
        String baseHref = cssVal instanceof WrappedValue ? ((WrappedValue)((Object)cssVal)).getParentSheetHref() : ((pRule = this.getParentRule()) != null ? pRule.getParentStyleSheet().getHref() : null);
        if (cssVal.getCssValueType() == 1) {
            return new String[]{this.getHref((CSSPrimitiveValue)((Object)cssVal), baseHref)};
        }
        CSSValueList list = (CSSValueList)((Object)cssVal);
        int len = list.getLength();
        String[] sa = new String[len];
        for (int i = 0; i < len; ++i) {
            sa[i] = this.getHref((CSSPrimitiveValue)list.item(i), baseHref);
        }
        return sa;
    }

    public String getHref(CSSPrimitiveValue cssVal, String baseHref) {
        String href = cssVal.getStringValue();
        if (!href.contains("://")) {
            URL baseUrl = null;
            if (baseHref == null) {
                String documentURI = this.getOwnerNode().getBaseURI();
                if (documentURI != null) {
                    try {
                        baseUrl = new URL(documentURI);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            } else if (!baseHref.contains("://")) {
                try {
                    baseUrl = new URL(new URL(this.getOwnerNode().getBaseURI()), baseHref);
                }
                catch (MalformedURLException e) {
                    this.getParentRule().getStyleDeclarationErrorHandler().malformedURIValue(baseHref);
                }
            } else {
                try {
                    baseUrl = new URL(baseHref);
                }
                catch (MalformedURLException e) {
                    this.getParentRule().getStyleDeclarationErrorHandler().malformedURIValue(baseHref);
                }
            }
            if (baseUrl != null) {
                try {
                    URL url = new URL(baseUrl, href);
                    href = url.toExternalForm();
                }
                catch (MalformedURLException e) {
                    this.getParentRule().getStyleDeclarationErrorHandler().malformedURIValue(href);
                }
            }
        }
        return href;
    }

    @Override
    public String getUsedFontFamily() {
        AbstractCSSValue val = this.getCSSValue("font-family");
        if (val.getCssValueType() == 2) {
            return ((CSSValueList)((Object)val)).item(0).getCssText();
        }
        return val.getCssText();
    }

    @Override
    public String getFontFamily() {
        return this.getCSSValue("font-family").getCssText();
    }

    @Override
    public String getFontWeight() {
        CSSStringValue fontWeight = (CSSStringValue)this.getCSSValue("font-weight");
        return fontWeight.getStringValue();
    }

    @Override
    public int getComputedFontSize() {
        CSSPrimitiveValue cssSize = (CSSPrimitiveValue)((Object)this.getCSSValue("font-size"));
        int sz = this.getStyleDatabase() != null ? this.getFontSizeFromIdentifier(null, "medium") : 3;
        if (cssSize == null) {
            return sz;
        }
        switch (cssSize.getPrimitiveType()) {
            case 3: {
                float factor = cssSize.getFloatValue((short)3);
                sz = Math.round((float)this.getParentElementFontSize() * factor);
                break;
            }
            case 4: {
                float factor = cssSize.getFloatValue((short)4);
                CSSComputedProperties parentStyle = this.getParentComputedStyle();
                if (parentStyle == null) {
                    sz = Math.round((float)this.getFontSizeFromIdentifier(null, "medium") * 0.5f * factor);
                    break;
                }
                if (this.getStyleDatabase() != null) {
                    sz = Math.round((float)this.getStyleDatabase().getExSizeInPt(parentStyle.getUsedFontFamily(), parentStyle.getComputedFontSize()) * factor);
                    break;
                }
                sz = Math.round((float)parentStyle.getComputedFontSize() * 0.5f * factor);
                break;
            }
            case 21: {
                String sizeIdentifier = cssSize.getStringValue().toLowerCase(Locale.US);
                try {
                    if ("larger".equals(sizeIdentifier)) {
                        sz = this.getLargerFontSize(sz);
                        break;
                    }
                    if ("smaller".equals(sizeIdentifier)) {
                        sz = this.getSmallerFontSize(sz);
                        break;
                    }
                    sz = this.getFontSizeFromIdentifier(null, sizeIdentifier);
                }
                catch (DOMException e) {
                    if (this.getParentRule() != null) {
                        this.getParentRule().getStyleDeclarationErrorHandler().unknownIdentifier("font-size", sizeIdentifier);
                        break;
                    }
                    ((CSSDocument)this.getOwnerNode().getOwnerDocument()).getStyleSheet().getErrorHandler().computedStyleError("font-size", sizeIdentifier, "Unknown identifier");
                }
                break;
            }
            case 2: {
                float pcnt = cssSize.getFloatValue((short)2);
                sz = Math.round((float)this.getParentElementFontSize() * pcnt / 100.0f);
                break;
            }
            case 9: {
                sz = (int)cssSize.getFloatValue((short)9);
            }
        }
        return sz;
    }

    private int getFontSizeFromIdentifier(String familyName, String sizeIdentifier) {
        if (this.getStyleDatabase() != null) {
            return this.getStyleDatabase().getFontSizeFromIdentifier(familyName, sizeIdentifier);
        }
        int sz = "medium".equals(sizeIdentifier) ? 3 : ("large".equals(sizeIdentifier) ? 4 : ("small".equals(sizeIdentifier) ? 2 : ("x-large".equals(sizeIdentifier) ? 5 : ("x-small".equals(sizeIdentifier) ? 2 : ("xx-small".equals(sizeIdentifier) ? 1 : ("xx-large".equals(sizeIdentifier) ? 6 : 3))))));
        return sz;
    }

    protected int getLargerFontSize(int defaultSize) {
        CSSPrimitiveValue csssize;
        float sz = (float)defaultSize * 1.2f;
        ComputedCSSStyle parentCss = (ComputedCSSStyle)this.getParentComputedStyle();
        if (parentCss != null && (csssize = (CSSPrimitiveValue)((Object)parentCss.getCSSValue("font-size"))) != null) {
            switch (csssize.getPrimitiveType()) {
                case 21: {
                    String baseFontSize = csssize.getStringValue();
                    if (baseFontSize.equals("xx-small")) {
                        sz = this.getFontSizeFromIdentifier(null, "x-small");
                        break;
                    }
                    if (baseFontSize.equals("x-small")) {
                        sz = this.getFontSizeFromIdentifier(null, "small");
                        break;
                    }
                    if (baseFontSize.equals("small")) {
                        sz = this.getFontSizeFromIdentifier(null, "medium");
                        break;
                    }
                    if (baseFontSize.equals("medium")) {
                        sz = this.getFontSizeFromIdentifier(null, "large");
                        break;
                    }
                    if (baseFontSize.equals("large")) {
                        sz = this.getFontSizeFromIdentifier(null, "x-large");
                        break;
                    }
                    if (baseFontSize.equals("x-large")) {
                        sz = this.getFontSizeFromIdentifier(null, "xx-large");
                        break;
                    }
                    if (baseFontSize.equals("xx-large")) {
                        sz = 2.0f * (float)this.getFontSizeFromIdentifier(null, "xx-large") - (float)this.getFontSizeFromIdentifier(null, "x-large");
                        break;
                    }
                    if (this.getParentRule() != null) {
                        this.getParentRule().getStyleDeclarationErrorHandler().unknownIdentifier("font-size", baseFontSize);
                        break;
                    }
                    ((CSSDocument)this.getOwnerNode().getOwnerDocument()).getStyleSheet().getErrorHandler().computedStyleError("font-size", baseFontSize, "Unknown identifier");
                    break;
                }
                default: {
                    sz = (float)parentCss.getComputedFontSize() * 1.2f;
                }
            }
        }
        return Math.round(sz);
    }

    protected int getSmallerFontSize(int defaultSize) {
        CSSPrimitiveValue csssize;
        float sz = (float)defaultSize * 0.82f;
        ComputedCSSStyle parentCss = (ComputedCSSStyle)this.getParentComputedStyle();
        if (parentCss != null && (csssize = (CSSPrimitiveValue)((Object)parentCss.getCSSValue("font-size"))) != null) {
            switch (csssize.getPrimitiveType()) {
                case 21: {
                    String baseFontSize = csssize.getStringValue();
                    if (baseFontSize.equals("xx-small")) {
                        sz = 2.0f * (float)this.getFontSizeFromIdentifier(null, "xx-small") - (float)this.getFontSizeFromIdentifier(null, "x-small");
                        if (!(sz < 0.1f)) break;
                        sz = this.getFontSizeFromIdentifier(null, "xx-small");
                        break;
                    }
                    if (baseFontSize.equals("x-small")) {
                        sz = this.getFontSizeFromIdentifier(null, "xx-small");
                        break;
                    }
                    if (baseFontSize.equals("small")) {
                        sz = this.getFontSizeFromIdentifier(null, "x-small");
                        break;
                    }
                    if (baseFontSize.equals("medium")) {
                        sz = this.getFontSizeFromIdentifier(null, "small");
                        break;
                    }
                    if (baseFontSize.equals("large")) {
                        sz = this.getFontSizeFromIdentifier(null, "medium");
                        break;
                    }
                    if (baseFontSize.equals("x-large")) {
                        sz = this.getFontSizeFromIdentifier(null, "large");
                        break;
                    }
                    if (baseFontSize.equals("xx-large")) {
                        sz = this.getFontSizeFromIdentifier(null, "x-large");
                        break;
                    }
                    if (this.getParentRule() != null) {
                        this.getParentRule().getStyleDeclarationErrorHandler().unknownIdentifier("font-size", baseFontSize);
                        break;
                    }
                    ((CSSDocument)this.getOwnerNode().getOwnerDocument()).getStyleSheet().getErrorHandler().computedStyleError("font-size", baseFontSize, "Unknown identifier");
                    break;
                }
                default: {
                    sz = (float)parentCss.getComputedFontSize() * 0.82f;
                }
            }
        }
        return Math.round(sz);
    }

    private int getParentElementFontSize() {
        CSSComputedProperties parentCss = this.getParentComputedStyle();
        int sz = parentCss != null ? parentCss.getComputedFontSize() : this.getFontSizeFromIdentifier(null, "medium");
        return sz;
    }

    protected boolean isFontFamilyAvailable(String requestedFamily) {
        if (this.getStyleDatabase().isFontFamilyAvailable(requestedFamily)) {
            return true;
        }
        CSSCanvas canvas = ((CSSDocument)this.getOwnerNode().getOwnerDocument()).getCanvas();
        if (canvas != null) {
            return canvas.isFontFaceName(requestedFamily);
        }
        return false;
    }

    @Override
    public float getComputedLineHeight() {
        return this.getComputedLineHeight(1.16f);
    }

    public float getComputedLineHeight(float defval) {
        float height;
        CSSPrimitiveValue cssval = (CSSPrimitiveValue)((Object)this.getCSSValue("line-height"));
        if (cssval == null) {
            return defval * (float)this.getComputedFontSize();
        }
        short declType = cssval.getPrimitiveType();
        if (declType == 2) {
            height = (float)this.getComputedFontSize() * cssval.getFloatValue((short)2) / 100.0f;
        } else if (declType == 21) {
            if (!"normal".equals(cssval.getStringValue())) {
                if (this.getParentRule() != null) {
                    CSSPropertyValueException e = new CSSPropertyValueException("Expected 'normal', found " + cssval.getStringValue());
                    this.getParentRule().getStyleDeclarationErrorHandler().wrongValue("line-height", e);
                } else {
                    ((CSSDocument)this.getOwnerNode().getOwnerDocument()).getStyleSheet().getErrorHandler().computedStyleError("line-height", cssval.getStringValue(), "Wrong value: expected 'normal'");
                }
            }
            height = defval * (float)this.getComputedFontSize();
        } else if (cssval instanceof CSSNumberValue) {
            height = cssval.getFloatValue(declType);
            if (declType != 9) {
                height = CSSNumberValue.floatValueConversion(height, declType, (short)9);
            }
        } else {
            if (this.getParentRule() != null) {
                CSSPropertyValueException e = new CSSPropertyValueException("Expected number or identifier, found " + cssval.getCssText());
                this.getParentRule().getStyleDeclarationErrorHandler().wrongValue("line-height", e);
            } else {
                ((CSSDocument)this.getOwnerNode().getOwnerDocument()).getStyleSheet().getErrorHandler().computedStyleError("line-height", cssval.getStringValue(), "Wrong value: expected number or identifier");
            }
            height = defval * (float)this.getComputedFontSize();
        }
        return height;
    }

    @Override
    public BoxValues getBoxValues(short unitType) throws DOMException, StyleDatabaseRequiredException {
        return new MyDefaultBoxModel().getComputedBox(unitType);
    }

    @Override
    public abstract String getOwnerXPath();

    public abstract String getParentXPath();

    @Override
    public abstract CSSComputedProperties getParentComputedStyle();

    public abstract boolean hasOverrideStyle(String var1);

    public abstract String getText();

    @Override
    public abstract ComputedCSSStyle clone();

    private class MyDefaultBoxModel
    extends SimpleBoxModel {
        MyDefaultBoxModel() {
        }

        @Override
        protected ComputedCSSStyle getComputedStyle() {
            return ComputedCSSStyle.this;
        }
    }
}

