/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.dom;

import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.dom.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.CSSStyleDeclarationRule;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSPrimitiveValue;

public class DOMCSSFontFaceRule
extends CSSStyleDeclarationRule
implements CSSFontFaceRule {
    private URL parentURL = null;

    public DOMCSSFontFaceRule(AbstractCSSStyleSheet parentSheet, short origin) {
        super(parentSheet, (short)5, origin);
        Node node;
        String parentHref = parentSheet.getHref();
        if (parentHref != null && !parentHref.contains("://") && (node = parentSheet.getOwnerNode()) != null) {
            try {
                this.parentURL = new URL(((CSSDocument)node.getOwnerDocument()).getBaseURL(), parentHref);
            }
            catch (MalformedURLException e) {
                this.getStyleDeclarationErrorHandler().malformedURIValue(parentHref);
            }
        }
    }

    public URL getSrcURL() {
        CSSPrimitiveValue uriValue = (CSSPrimitiveValue)this.getStyle().getPropertyCSSValue("src");
        if (uriValue == null) {
            return null;
        }
        String uri = uriValue.getStringValue();
        try {
            if (uri.contains("://")) {
                return new URL(uri);
            }
            if (this.parentURL != null) {
                return new URL(this.parentURL, uri);
            }
        }
        catch (MalformedURLException e) {
            this.getStyleDeclarationErrorHandler().malformedURIValue(uri);
        }
        return null;
    }
}

