/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.dom;

import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.dom.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.dom.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.ComputedCSSStyle;
import org.w3c.dom.Node;

public abstract class DOMCSSStyleDeclaration
extends ComputedCSSStyle {
    private BaseCSSStyleSheet parentSheet = null;

    public DOMCSSStyleDeclaration() {
    }

    public DOMCSSStyleDeclaration(BaseCSSStyleSheet parentSheet) {
        this.parentSheet = parentSheet;
    }

    public DOMCSSStyleDeclaration(BaseCSSStyleDeclaration copiedObject) {
        super(copiedObject);
    }

    @Override
    public String getOwnerXPath() {
        return "";
    }

    @Override
    public String getParentXPath() {
        return "";
    }

    @Override
    public DOMCSSStyleDeclaration getParentComputedStyle() {
        DOMCSSStyleDeclaration parentCss = null;
        if (this.parentSheet == null) {
            return null;
        }
        Node node = this.getOwnerNode();
        while (node != null && (node = node.getParentNode()) != null) {
            if (node.getNodeType() != 1) continue;
            parentCss = (DOMCSSStyleDeclaration)((BaseDocumentCSSStyleSheet)this.parentSheet).getComputedStyle((CSSElement)node, null);
            break;
        }
        return parentCss;
    }

    @Override
    public String getText() {
        String text = this.getOwnerNode().getTextContent().trim().replace("  ", " ");
        return text;
    }

    @Override
    public StyleDatabase getStyleDatabase() {
        Node node = this.getOwnerNode();
        if (node != null) {
            CSSDocument doc = (CSSDocument)node.getOwnerDocument();
            return doc.getStyleDatabase();
        }
        return super.getStyleDatabase();
    }
}

