/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.dom;

import io.sf.carte.doc.DocumentException;
import io.sf.carte.doc.agent.AbstractUserAgent;
import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSNode;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.LogErrorHandler;
import io.sf.carte.doc.style.css.dom.AbstractCSSRule;
import io.sf.carte.doc.style.css.dom.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.dom.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.dom.DOMCSSStyleDeclaration;
import io.sf.carte.doc.style.css.dom.DOMCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.DOMDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.DOMMediaList;
import io.sf.carte.doc.style.css.dom.StylableDocumentWrapper;
import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSRule;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMCSSStyleSheetFactory
extends BaseCSSStyleSheetFactory {
    private DOMDocumentCSSStyleSheet defStyleSheet = null;
    private DOMDocumentCSSStyleSheet uaStyleSheet = null;
    private EntityResolver resolver = this.createEntityResolver();
    private MyUserAgent myUserAgent = null;
    private DeviceFactory deviceFactory;
    private ErrorHandler errorHandler = this.createErrorHandler();

    public DOMCSSStyleSheetFactory() {
        this(0);
    }

    public DOMCSSStyleSheetFactory(byte complianceMode) {
        super(complianceMode);
    }

    @Override
    public DOMDocumentCSSStyleSheet createDocumentStyleSheet(short origin) {
        return new MyDOMDocumentCSSStyleSheet(null, origin);
    }

    @Override
    public DOMCSSStyleSheet createRuleStyleSheet(AbstractCSSRule ownerRule, String title, DOMMediaList mediaList) {
        return new MyDOMCSSStyleSheet(title, null, mediaList, ownerRule, ownerRule.getOrigin());
    }

    @Override
    public DOMCSSStyleSheet createLinkedStyleSheet(CSSElement ownerNode, String title, DOMMediaList mediaList) {
        Node titleattr;
        if (title == null && ownerNode != null && (titleattr = ownerNode.getAttributes().getNamedItem("title")) != null) {
            title = titleattr.getNodeValue();
        }
        return new MyDOMCSSStyleSheet(title, ownerNode, mediaList, null, 8);
    }

    public DOMDocumentCSSStyleSheet getUserAgentStyleSheet() {
        if (this.uaStyleSheet == null) {
            this.uaStyleSheet = this.createDocumentStyleSheet((short)16);
        }
        return this.uaStyleSheet;
    }

    protected DOMDocumentCSSStyleSheet getDefaultStyleSheet() {
        if (this.defStyleSheet == null) {
            this.mergeUserSheets();
        }
        return this.defStyleSheet;
    }

    @Override
    public void setDefaultHTMLUserAgentSheet() {
        try {
            this.setUserAgentStyleSheet((DOMDocumentCSSStyleSheet)this.loadXHTMLDefaultSheet());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read the default style sheet", e);
        }
    }

    private void setUserAgentStyleSheet(DOMDocumentCSSStyleSheet styleSheet) {
        this.uaStyleSheet = styleSheet;
        this.defStyleSheet = null;
    }

    private void mergeUserSheets() {
        this.defStyleSheet = this.getUserAgentStyleSheet().clone();
        if (this.getUserNormalStyleSheet() != null) {
            this.defStyleSheet.addStyleSheet(this.getUserNormalStyleSheet());
        }
    }

    public AbstractUserAgent getUserAgent() {
        if (this.myUserAgent == null) {
            this.myUserAgent = new MyUserAgent();
        }
        return this.myUserAgent;
    }

    public DeviceFactory getDeviceFactory() {
        return this.deviceFactory;
    }

    public void setDeviceFactory(DeviceFactory deviceFactory) {
        this.deviceFactory = deviceFactory;
    }

    public StylableDocumentWrapper createCSSDocument(Document document) {
        MyStylableDocumentWrapper mydoc = new MyStylableDocumentWrapper(document);
        mydoc.setDefaultStyleSheet(this.getDefaultStyleSheet());
        return mydoc;
    }

    @Override
    public AbstractCSSStyleDeclaration createAnonymousStyleDeclaration(Node node, CSSElement parent) {
        StylableDocumentWrapper.MyDOMCSSStyleDeclaration style = new StylableDocumentWrapper.MyDOMCSSStyleDeclaration();
        style.setOwnerNode(node);
        style.setStyleDatabase(parent.getOwnerDocument().getStyleDatabase());
        return style;
    }

    protected EntityResolver createEntityResolver() {
        return new DefaultEntityResolver();
    }

    @Override
    protected ErrorHandler createErrorHandler() {
        return new LogErrorHandler();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    private class MyStylableDocumentWrapper
    extends StylableDocumentWrapper {
        private long loadingTime;

        public MyStylableDocumentWrapper(Document document) {
            super(document);
        }

        @Override
        protected DOMCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }

        @Override
        public URLConnection openConnection(URL url) throws IOException {
            return ((MyUserAgent)DOMCSSStyleSheetFactory.this.getUserAgent()).openConnection(url, this.loadingTime);
        }

        @Override
        public void setLoadingTime(long time) {
            this.loadingTime = time;
        }
    }

    class MyUserAgent
    extends AbstractUserAgent {
        MyUserAgent() {
        }

        @Override
        public CSSDocument readURL(URL url) throws IOException, DocumentException {
            DocumentBuilder docb;
            DocumentBuilderFactory dbFac = DocumentBuilderFactory.newInstance();
            try {
                docb = dbFac.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new DocumentException("Error creating a document builder", e);
            }
            docb.setEntityResolver(DOMCSSStyleSheetFactory.this.resolver);
            long time = System.currentTimeMillis();
            URLConnection con = this.openConnection(url, time);
            String conType = con.getContentType();
            InputStream is = null;
            Document xdoc = null;
            try {
                PushbackReader re;
                int iread;
                int idx;
                is = con.getInputStream();
                String charset = null;
                if (conType == null) {
                    conType = URLConnection.guessContentTypeFromStream(is);
                }
                if (conType != null && (idx = conType.indexOf("charset=")) >= 0) {
                    charset = conType.substring(idx + 8);
                }
                if ((iread = (re = charset != null ? new PushbackReader(new InputStreamReader(is, charset), 1) : new PushbackReader(new InputStreamReader(is, "utf-8"), 1)).read()) != -1 && iread == 0xEFBBBF) {
                    charset = "utf-8";
                } else {
                    re.unread(iread);
                }
                InputSource source = new InputSource(re);
                xdoc = docb.parse(source);
            }
            catch (IOException e) {
                throw e;
            }
            catch (SAXException e) {
                throw new DocumentException("Error parsing XML document at " + url.toExternalForm(), e);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            xdoc.getDocumentElement().normalize();
            xdoc.setDocumentURI(url.toExternalForm());
            StylableDocumentWrapper wrapper = DOMCSSStyleSheetFactory.this.createCSSDocument(xdoc);
            wrapper.setLoadingTime(time);
            String defStyle = con.getHeaderField("Default-Style");
            NodeList list = xdoc.getElementsByTagName("meta");
            int listL = list.getLength();
            for (int i = listL - 1; i >= 0; --i) {
                String metaDefStyle;
                if (!"Default-Style".equalsIgnoreCase(((Element)list.item(i)).getAttribute("http-equiv")) || (metaDefStyle = ((Element)list.item(i)).getAttribute("content")).length() != 0) continue;
                defStyle = metaDefStyle;
            }
            if (defStyle != null) {
                wrapper.setSelectedStyleSheetSet(defStyle);
            }
            if (con instanceof HttpURLConnection) {
                HttpURLConnection hcon = (HttpURLConnection)con;
                this.readCookies(hcon, time);
                hcon.disconnect();
            }
            return wrapper;
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
            DOMCSSStyleSheetFactory.this.resolver = resolver;
        }

        @Override
        public URLConnection openConnection(URL url, long creationDate) throws IOException {
            return super.openConnection(url, creationDate);
        }
    }

    class MyDOMCSSStyleSheet
    extends DOMCSSStyleSheet {
        MyDOMCSSStyleSheet(String title, CSSNode ownerNode, DOMMediaList media, CSSRule ownerRule, short origin) {
            super(title, ownerNode, media, ownerRule, origin);
        }

        @Override
        protected DOMCSSStyleSheet createCSSStyleSheet(String title, CSSNode ownerNode, DOMMediaList media, CSSRule ownerRule, short origin) {
            return new MyDOMCSSStyleSheet(title, ownerNode, media, ownerRule, origin);
        }

        @Override
        public DOMCSSStyleDeclaration createComputedCSSStyle() {
            return new StylableDocumentWrapper.MyDOMCSSStyleDeclaration();
        }

        @Override
        public DOMCSSStyleDeclaration createComputedCSSStyle(BaseCSSStyleSheet parentSheet) {
            return new StylableDocumentWrapper.MyDOMCSSStyleDeclaration(parentSheet);
        }

        @Override
        public BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }
    }

    private class MyDOMDocumentCSSStyleSheet
    extends DOMDocumentCSSStyleSheet {
        MyDOMDocumentCSSStyleSheet(String medium, short origin) {
            super(medium, origin);
        }

        @Override
        protected DOMDocumentCSSStyleSheet createDocumentCSSStyleSheet(String medium, short origin) {
            return new MyDOMDocumentCSSStyleSheet(medium, origin);
        }

        @Override
        public DOMCSSStyleDeclaration createComputedCSSStyle() {
            return new StylableDocumentWrapper.MyDOMCSSStyleDeclaration();
        }

        @Override
        public DOMCSSStyleDeclaration createComputedCSSStyle(BaseCSSStyleSheet parentSheet) {
            return new StylableDocumentWrapper.MyDOMCSSStyleDeclaration(parentSheet);
        }

        @Override
        public BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }
    }
}

