/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.dom;

import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.AbstractCSSRule;
import io.sf.carte.doc.style.css.dom.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.dom.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.CSSRuleArrayList;
import io.sf.carte.doc.style.css.dom.DOMCSSStyleDeclaration;
import io.sf.carte.doc.style.css.dom.DOMSelectorMatcher;
import java.util.Iterator;
import org.w3c.dom.DOMException;

public abstract class DOMDocumentCSSStyleSheet
extends BaseDocumentCSSStyleSheet
implements DocumentCSSStyleSheet,
Cloneable {
    private CSSDocument ownerNode = null;

    public DOMDocumentCSSStyleSheet(short origin) {
        super(null, origin);
    }

    protected DOMDocumentCSSStyleSheet(String medium, short origin) {
        super(medium, origin);
    }

    @Override
    public CSSDocument getOwnerNode() {
        return this.ownerNode;
    }

    public void setOwnerDocument(CSSDocument ownerNode) {
        this.ownerNode = ownerNode;
    }

    @Override
    public CSSComputedProperties getComputedStyle(CSSElement elm, String pseudoElt) {
        DOMCSSStyleDeclaration inline = this.createComputedCSSStyle();
        inline.setOwnerNode(elm);
        String st = elm.getAttribute("style");
        if (st.length() > 0) {
            try {
                inline.setCssText(st);
            }
            catch (DOMException e) {
                this.getErrorHandler().inlineStyleError(e, elm, st);
                inline = null;
            }
        }
        DOMCSSStyleDeclaration style = this.createComputedCSSStyle(this);
        style.setOwnerNode(elm);
        return this.computeStyle(style, new DOMSelectorMatcher(elm), inline, pseudoElt);
    }

    public abstract DOMCSSStyleDeclaration createComputedCSSStyle();

    public abstract DOMCSSStyleDeclaration createComputedCSSStyle(BaseCSSStyleSheet var1);

    protected abstract DOMDocumentCSSStyleSheet createDocumentCSSStyleSheet(String var1, short var2);

    @Override
    public abstract BaseCSSStyleSheetFactory getStyleSheetFactory();

    @Override
    public DOMDocumentCSSStyleSheet clone() {
        DOMDocumentCSSStyleSheet myClone = this.createDocumentCSSStyleSheet(this.getTargetMedium(), this.getOrigin());
        myClone.setOwnerDocument(this.ownerNode);
        myClone.currentInsertionIndex = this.currentInsertionIndex;
        myClone.setDisabled(this.getDisabled());
        myClone.namespaces = this.namespaces;
        myClone.setParentStyleSheet(this.getParentStyleSheet());
        myClone.cssRules = new CSSRuleArrayList(this.cssRules.getLength());
        int i = 0;
        Iterator it = this.cssRules.iterator();
        while (it.hasNext()) {
            myClone.cssRules.add(((AbstractCSSRule)it.next()).clone(myClone, i++));
        }
        return myClone;
    }

    @Override
    public DOMDocumentCSSStyleSheet clone(String targetMedium) {
        DOMDocumentCSSStyleSheet myClone = this.createDocumentCSSStyleSheet(targetMedium, this.getOrigin());
        myClone.setOwnerDocument(this.ownerNode);
        this.copyTo(myClone);
        return myClone;
    }
}

