/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.dom;

import io.sf.carte.doc.style.css.dom.SelectorMatcher;
import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class DOMSelectorMatcher
extends SelectorMatcher {
    private String idAttr = null;
    Element element;

    public DOMSelectorMatcher(Element elm) {
        this.element = elm;
        String name = elm.getTagName();
        if (name != null) {
            name = name.toLowerCase(Locale.US).intern();
        }
        this.setTagname(name);
        Node parent = elm.getParentNode();
        if (parent != null) {
            name = parent.getNodeName();
            if (name != null) {
                name = name.toLowerCase(Locale.US).intern();
            }
            this.setParentTagname(name);
        }
        this.setClassAttribute(elm.getAttribute("class"));
        this.idAttr = elm.getAttribute("id");
        if (this.idAttr.length() == 0) {
            this.idAttr = elm.getAttribute("ID");
            if (this.idAttr.length() == 0) {
                this.idAttr = elm.getAttribute("Id");
            }
        }
    }

    @Override
    public SelectorMatcher getParentSelectorMatcher() {
        Node parent = this.element.getParentNode();
        if (parent instanceof Element) {
            return new DOMSelectorMatcher((Element)parent);
        }
        return null;
    }

    @Override
    public SelectorMatcher getPreviousSiblingSelectorMatcher() {
        Node sibling = this.element.getPreviousSibling();
        if (sibling instanceof Element) {
            return new DOMSelectorMatcher((Element)sibling);
        }
        return null;
    }

    @Override
    public boolean isFirstChild() {
        return this.element.getPreviousSibling() == null;
    }

    @Override
    public String getAttributeValue(String attrName) {
        return this.element.getAttribute(attrName);
    }

    @Override
    public boolean hasAttribute(String attrName) {
        return this.element.hasAttribute(attrName);
    }

    @Override
    public String getLanguage() {
        String lang = this.element.getAttribute("lang");
        Node parent = this.element;
        while (lang.length() == 0 && (parent = parent.getParentNode()) != null) {
            if (!(parent instanceof Element)) continue;
            lang = parent.getAttribute("lang");
        }
        return lang;
    }

    @Override
    public String getId() {
        return this.idAttr;
    }
}

