/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.dom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public abstract class DOMStyleSheetList
implements StyleSheetList {
    private List<StyleSheet> list;
    private MyDOMStringList styleSheetSets = new MyDOMStringList();
    private String preferredStyleSheetSet = "";
    private boolean needsUpdate;

    protected DOMStyleSheetList(int initialCapacity) {
        this.list = new ArrayList<StyleSheet>(initialCapacity);
    }

    @Override
    public int getLength() {
        if (this.needsUpdate) {
            this.update();
        }
        return this.list.size();
    }

    @Override
    public StyleSheet item(int index) {
        if (this.needsUpdate) {
            this.update();
        }
        if (index >= this.list.size() || index < 0) {
            return null;
        }
        return this.list.get(index);
    }

    public DOMStringList getStyleSheetSets() {
        return this.styleSheetSets;
    }

    public void add(StyleSheet sheet) {
        if (sheet != null) {
            this.list.add(sheet);
            String title = sheet.getTitle();
            if (title != null && title.length() > 0) {
                this.styleSheetSets.add(title);
                if (!sheet.getDisabled() && this.preferredStyleSheetSet.length() == 0) {
                    this.preferredStyleSheetSet = title;
                }
            }
        }
    }

    public String getPreferredStyleSheetSet() {
        if (this.needsUpdate) {
            this.update();
        }
        return this.preferredStyleSheetSet;
    }

    public void remove(String title) {
        for (StyleSheet sheet : this.list) {
            if (!title.equals(sheet.getTitle())) continue;
            this.list.remove(sheet);
        }
    }

    protected Iterator<StyleSheet> iterator() {
        return this.list.iterator();
    }

    protected void clear() {
        this.list.clear();
    }

    protected boolean needsUpdate() {
        return this.needsUpdate;
    }

    protected void setNeedsUpdate(boolean needsUpdate) {
        this.needsUpdate = needsUpdate;
    }

    protected void update() {
        this.styleSheetSets.clear();
        this.clear();
    }

    class MyDOMStringList
    implements DOMStringList {
        private TreeSet<String> titleSet = new TreeSet();

        MyDOMStringList() {
        }

        @Override
        public String item(int index) {
            if (DOMStyleSheetList.this.needsUpdate) {
                DOMStyleSheetList.this.update();
            }
            if (index >= this.titleSet.size() || index < 0) {
                return null;
            }
            Iterator<String> it = this.titleSet.iterator();
            String title = null;
            int i = 0;
            while (it.hasNext()) {
                String s = it.next();
                if (i == index) {
                    title = s;
                    break;
                }
                ++i;
            }
            return title;
        }

        @Override
        public int getLength() {
            if (DOMStyleSheetList.this.needsUpdate) {
                DOMStyleSheetList.this.update();
            }
            return this.titleSet.size();
        }

        @Override
        public boolean contains(String str) {
            return this.titleSet.contains(str);
        }

        private void add(String title) {
            this.titleSet.add(title);
        }

        private void clear() {
            this.titleSet.clear();
        }
    }
}

