/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.dom;

import io.sf.carte.doc.style.css.dom.DOMCSSStyleRule;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;

public abstract class SelectorMatcher {
    private String tagname = null;
    private String parentTagName = null;
    private String classAttr = "";
    private String pseudoElt = null;

    public String getTagName() {
        return this.tagname;
    }

    protected void setClassAttribute(String classAttr) {
        this.classAttr = classAttr;
    }

    protected void setTagname(String tagname) {
        this.tagname = tagname;
    }

    protected void setParentTagname(String parentTagname) {
        this.parentTagName = parentTagname;
    }

    public String getPseudoElement() {
        return this.pseudoElt;
    }

    public void setPseudoElement(String pseudoElt) {
        this.pseudoElt = pseudoElt;
    }

    public int match(SelectorList selist) {
        int sz = selist.getLength();
        DOMCSSStyleRule.Specifity matchedsp = null;
        int matchedIdx = -1;
        for (int i = 0; i < sz; ++i) {
            if (!this.match(selist.item(i))) continue;
            DOMCSSStyleRule.Specifity sp = new DOMCSSStyleRule.Specifity(selist.item(i));
            if (matchedsp != null && DOMCSSStyleRule.Specifity.selectorCompare(matchedsp, sp) >= 0) continue;
            matchedsp = sp;
            matchedIdx = i;
        }
        return matchedIdx;
    }

    public boolean match(Selector selector) {
        switch (selector.getSelectorType()) {
            case 4: {
                String elname = ((ElementSelector)selector).getLocalName();
                if (elname != null && !elname.equals("*") && !this.tagname.equals(elname.toLowerCase(Locale.US))) break;
                return true;
            }
            case 0: {
                return this.matchConditional((ConditionalSelector)selector);
            }
            case 11: {
                SimpleSelector desc = ((DescendantSelector)selector).getSimpleSelector();
                if (!this.match((Selector)desc)) break;
                Selector ancestor = ((DescendantSelector)selector).getAncestorSelector();
                SelectorMatcher parentSM = this.getParentSelectorMatcher();
                if (parentSM == null || !parentSM.match(ancestor)) break;
                return true;
            }
            case 10: {
                SimpleSelector desc = ((DescendantSelector)selector).getSimpleSelector();
                if (!this.match((Selector)desc)) break;
                Selector ancestor = ((DescendantSelector)selector).getAncestorSelector();
                for (SelectorMatcher parentSM = this.getParentSelectorMatcher(); parentSM != null; parentSM = parentSM.getParentSelectorMatcher()) {
                    if (!parentSM.match(ancestor)) continue;
                    return true;
                }
                break;
            }
            case 9: {
                if (this.pseudoElt == null || !this.pseudoElt.equalsIgnoreCase(((ElementSelector)selector).getLocalName())) break;
                return true;
            }
            case 12: {
                if (!this.match((Selector)((SiblingSelector)selector).getSiblingSelector())) break;
                Selector sel = ((SiblingSelector)selector).getSelector();
                SelectorMatcher siblingSM = this.getPreviousSiblingSelectorMatcher();
                return siblingSM.match(sel);
            }
        }
        return false;
    }

    boolean matchConditional(ConditionalSelector selector) {
        Condition cond = selector.getCondition();
        switch (cond.getConditionType()) {
            case 9: {
                String cond_value = ((AttributeCondition)cond).getValue();
                if (this.classAttr.length() == 0 || !this.match((Selector)selector.getSimpleSelector())) break;
                return this.matchesClass(cond_value);
            }
            case 5: {
                String idAttr = this.getId();
                if (!((AttributeCondition)cond).getValue().equals(idAttr)) break;
                return true;
            }
            case 10: {
                String cond_value = ((AttributeCondition)cond).getValue();
                if (!"first-child".equalsIgnoreCase(cond_value) || !this.isFirstChild()) break;
                SimpleSelector simple = selector.getSimpleSelector();
                return this.match((Selector)simple);
            }
            case 4: {
                String attrName = ((AttributeCondition)cond).getLocalName();
                if (!this.hasAttribute(attrName)) break;
                if (((AttributeCondition)cond).getSpecified()) {
                    String attribValue = this.getAttributeValue(attrName);
                    String cond_value = ((AttributeCondition)cond).getValue();
                    if (cond_value == null) {
                        return true;
                    }
                    return attribValue.equals(cond_value);
                }
                return true;
            }
            case 7: {
                String attrName = ((AttributeCondition)cond).getLocalName();
                if (!this.hasAttribute(attrName)) break;
                String attrValue = this.getAttributeValue(attrName);
                StringTokenizer tok = new StringTokenizer(attrValue, " ");
                while (tok.hasMoreElements()) {
                    String token = tok.nextToken();
                    if (!token.equals(((AttributeCondition)cond).getValue())) continue;
                    return true;
                }
                break;
            }
            case 8: {
                String attrName = ((AttributeCondition)cond).getLocalName();
                if (!this.hasAttribute(attrName)) break;
                String attrValue = this.getAttributeValue(attrName);
                return attrValue.startsWith(((AttributeCondition)cond).getValue());
            }
            case 6: {
                String attrName = ((LangCondition)cond).getLang();
                String lang = this.getLanguage();
                return lang.startsWith(attrName);
            }
        }
        return false;
    }

    private boolean matchesClass(String cond_value) {
        int iws;
        int oiws = 0;
        while ((iws = this.classAttr.indexOf(32, oiws)) >= 0) {
            if (this.classAttr.substring(oiws, iws).equalsIgnoreCase(cond_value)) {
                return true;
            }
            oiws = iws + 1;
        }
        if (oiws == 0) {
            return this.classAttr.equalsIgnoreCase(cond_value);
        }
        if (oiws < this.classAttr.length()) {
            return this.classAttr.substring(oiws).equalsIgnoreCase(cond_value);
        }
        return false;
    }

    public abstract SelectorMatcher getParentSelectorMatcher();

    public abstract SelectorMatcher getPreviousSiblingSelectorMatcher();

    public abstract boolean isFirstChild();

    public abstract String getAttributeValue(String var1);

    public abstract boolean hasAttribute(String var1);

    public abstract String getId();

    public abstract String getLanguage();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.parentTagName != null) {
            sb.append(this.parentTagName).append(' ').append('>').append(' ');
        }
        if (this.tagname != null) {
            sb.append(this.tagname);
        }
        if (this.classAttr.length() != 0) {
            sb.append('.').append(this.classAttr);
        } else if (this.getId().length() != 0) {
            sb.append('#').append(this.getId());
        }
        if (this.pseudoElt != null) {
            sb.append(':').append(this.pseudoElt);
        }
        return sb.toString();
    }
}

