/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.dom;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSNode;
import io.sf.carte.doc.style.css.CSSRuleListener;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.dom.AbstractCSSRule;
import io.sf.carte.doc.style.css.dom.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.dom.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.CSSRuleArrayList;
import io.sf.carte.doc.style.css.dom.ComputedCSSStyle;
import io.sf.carte.doc.style.css.dom.DOMCSSFontFaceRule;
import io.sf.carte.doc.style.css.dom.DOMCSSMediaRule;
import io.sf.carte.doc.style.css.dom.DOMCSSPageRule;
import io.sf.carte.doc.style.css.dom.DOMCSSStyleDeclaration;
import io.sf.carte.doc.style.css.dom.DOMCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.DOMCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.dom.DOMDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.DOMMediaList;
import io.sf.carte.doc.style.css.dom.DOMNode;
import io.sf.carte.doc.style.css.dom.DOMStyleSheetList;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ElementCSSInlineStyle;
import org.w3c.dom.stylesheets.LinkStyle;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public abstract class StylableDocumentWrapper
extends DOMNode
implements CSSDocument,
CSSRuleListener {
    private Document document;
    private Map<Node, CSSNode> nodemap = new HashMap<Node, CSSNode>();
    private DOMDocumentCSSStyleSheet defStyleSheet = null;
    private DOMDocumentCSSStyleSheet mergedStyleSheet = null;
    Set<LinkElement> linkedStyle = new LinkedHashSet<LinkElement>(4);
    Set<StyleElement> embeddedStyle = new LinkedHashSet<StyleElement>(3);
    private MyDOMStyleSheetList sheets = new MyDOMStyleSheetList(7);
    private String metaDefaultStyleSet = "";
    private String lastStyleSheetSet = null;
    private String targetMedium = null;
    private Map<String, CSSCanvas> canvases = new HashMap<String, CSSCanvas>(3);

    public StylableDocumentWrapper(Document document) {
        super(document);
        this.document = document;
    }

    protected abstract DOMCSSStyleSheetFactory getStyleSheetFactory();

    @Override
    public CSSDocument getOwnerDocument() {
        return null;
    }

    @Override
    protected CSSNode getMappedCSSNode(Node node) {
        return this.nodemap.get(node);
    }

    @Override
    protected CSSNode getCSSNode(Node node) {
        CSSNode mynode = this.getMappedCSSNode(node);
        if (mynode == null) {
            switch (node.getNodeType()) {
                case 2: {
                    mynode = new MyAttr((Attr)node);
                    break;
                }
                case 1: {
                    Element el = (Element)node;
                    String name = el.getNodeName();
                    if (name != null) {
                        if ("link".equals(name = name.toLowerCase(Locale.US))) {
                            mynode = new LinkElement((Element)node);
                            this.onStyleModify();
                            break;
                        }
                        if ("style".equals(name)) {
                            mynode = new StyleElement((Element)node);
                            this.onStyleModify();
                            break;
                        }
                    }
                    mynode = new MyElement((Element)node);
                    break;
                }
                case 3: {
                    mynode = new MyText((Text)node);
                    break;
                }
                case 4: {
                    mynode = new MyCDATASection((CDATASection)node);
                    break;
                }
                case 8: {
                    mynode = new MyComment((Comment)node);
                    break;
                }
                case 5: {
                    mynode = new MyEntityReference((EntityReference)node);
                    break;
                }
                default: {
                    mynode = new MyNode(node);
                }
            }
            this.nodemap.put(node, mynode);
        }
        return mynode;
    }

    @Override
    public DocumentType getDoctype() {
        return this.document.getDoctype();
    }

    @Override
    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    public abstract void setLoadingTime(long var1);

    @Override
    public CSSElement getDocumentElement() {
        return (CSSElement)this.getCSSNode(this.document.getDocumentElement());
    }

    @Override
    public CSSElement createElement(String tagName) throws DOMException {
        return (CSSElement)this.getCSSNode(this.document.createElement(tagName));
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public MyText createTextNode(String data) {
        return (MyText)this.getCSSNode(this.document.createTextNode(data));
    }

    @Override
    public MyComment createComment(String data) {
        return (MyComment)this.getCSSNode(this.document.createComment(data));
    }

    @Override
    public MyCDATASection createCDATASection(String data) throws DOMException {
        return (MyCDATASection)this.getCSSNode(this.document.createCDATASection(data));
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public MyAttr createAttribute(String name) throws DOMException {
        return (MyAttr)this.getCSSNode(this.document.createAttribute(name));
    }

    @Override
    public MyEntityReference createEntityReference(String name) throws DOMException {
        return (MyEntityReference)this.getCSSNode(this.document.createEntityReference(name));
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        return new DOMNode.MyNodeList(this.document.getElementsByTagName(tagname));
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public CSSElement createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return (CSSElement)this.getCSSNode(this.document.createElementNS(namespaceURI, qualifiedName));
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return (MyAttr)this.getCSSNode(this.document.createAttributeNS(namespaceURI, qualifiedName));
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new DOMNode.MyNodeList(this.document.getElementsByTagNameNS(namespaceURI, localName));
    }

    @Override
    public CSSElement getElementById(String elementId) {
        return (CSSElement)this.getCSSNode(this.document.getElementById(elementId));
    }

    @Override
    public String getInputEncoding() {
        return this.document.getInputEncoding();
    }

    @Override
    public String getXmlEncoding() {
        return this.document.getXmlEncoding();
    }

    @Override
    public boolean getXmlStandalone() {
        return this.document.getXmlStandalone();
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public String getXmlVersion() {
        return this.document.getXmlVersion();
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.document.getStrictErrorChecking();
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public String getDocumentURI() {
        return this.document.getDocumentURI();
    }

    @Override
    public void setDocumentURI(String documentURI) {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.document.getDomConfig();
    }

    @Override
    public void normalizeDocument() {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public StyleSheetList getStyleSheets() {
        if (this.sheets.needsUpdate()) {
            this.updateStyleLists();
        }
        return this.sheets;
    }

    protected void updateStyleLists() {
        CSSNode mynode;
        Node n;
        int i;
        this.linkedStyle.clear();
        NodeList nl = this.document.getElementsByTagName("link");
        int len = nl.getLength();
        for (i = 0; i < len; ++i) {
            n = nl.item(i);
            mynode = this.getMappedCSSNode(n);
            if (mynode == null) {
                mynode = new LinkElement((Element)n);
                this.nodemap.put(n, mynode);
            }
            this.linkedStyle.add((LinkElement)mynode);
        }
        this.embeddedStyle.clear();
        nl = this.document.getElementsByTagName("style");
        len = nl.getLength();
        for (i = 0; i < len; ++i) {
            n = nl.item(i);
            mynode = this.getMappedCSSNode(n);
            if (mynode == null) {
                mynode = new StyleElement((Element)n);
                this.nodemap.put(n, mynode);
            }
            this.embeddedStyle.add((StyleElement)mynode);
        }
        Iterator<LinkElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            this.addLinkedSheet(links.next().getSheet());
        }
        Iterator<StyleElement> embd = this.embeddedStyle.iterator();
        while (embd.hasNext()) {
            this.addLinkedSheet(embd.next().getSheet());
        }
        this.sheets.setNeedsUpdate(false);
        if (this.lastStyleSheetSet != null) {
            this.setSelectedStyleSheetSet(this.lastStyleSheetSet);
        } else if (this.metaDefaultStyleSet.length() > 0) {
            this.setSelectedStyleSheetSet(this.metaDefaultStyleSet);
        } else {
            this.setSelectedStyleSheetSet(this.sheets.getPreferredStyleSheetSet());
        }
    }

    private void addLinkedSheet(StyleSheet linkedSheet) {
        if (linkedSheet != null) {
            this.sheets.add(linkedSheet);
        }
    }

    @Override
    public DOMDocumentCSSStyleSheet getStyleSheet() {
        if (this.mergedStyleSheet == null) {
            this.mergeStyleSheets();
        }
        return this.mergedStyleSheet;
    }

    private void mergeStyleSheets() {
        this.mergedStyleSheet = this.targetMedium == null ? this.defStyleSheet.clone() : this.defStyleSheet.clone(this.targetMedium);
        this.mergedStyleSheet.setOwnerDocument(this);
        this.getStyleSheets();
        Iterator<StyleSheet> it = this.sheets.iterator();
        while (it.hasNext()) {
            this.getStyleSheet().addStyleSheet((AbstractCSSStyleSheet)it.next());
        }
    }

    public boolean addStyleSheet(InputSource cssSrc) throws DOMException, IOException, CSSException {
        String media = cssSrc.getMedia();
        if (media != null && !"all".equals(media)) {
            AbstractCSSStyleSheet sheet = this.getStyleSheetFactory().createStyleSheet(cssSrc.getTitle(), cssSrc.getMedia());
            ((DOMDocumentCSSStyleSheet)sheet).setOwnerDocument(this);
            boolean result = sheet.parseCSSStyleSheet(cssSrc);
            DOMCSSMediaRule mrule = this.getStyleSheet().createCSSMediaRule(DOMMediaList.create(media));
            CSSRuleArrayList otherRules = sheet.getCssRules();
            int orl = otherRules.getLength();
            for (int i = 0; i < orl; ++i) {
                AbstractCSSRule orule = (AbstractCSSRule)otherRules.item(i);
                orule.setParentRule(mrule);
                mrule.addRule(orule);
            }
            this.getStyleSheet().addRule(mrule);
            return result;
        }
        return this.getStyleSheet().parseCSSStyleSheet(cssSrc);
    }

    @Override
    public DOMStringList getStyleSheetSets() {
        if (this.sheets.needsUpdate()) {
            this.updateStyleLists();
        }
        return this.sheets.getStyleSheetSets();
    }

    @Override
    public String getSelectedStyleSheetSet() {
        String selectedSetName = "";
        Iterator<LinkElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            DOMCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || sheet.getDisabled()) continue;
            if (selectedSetName.length() > 0) {
                if (selectedSetName.equals(title)) continue;
                return null;
            }
            selectedSetName = title;
        }
        return selectedSetName;
    }

    @Override
    public void setSelectedStyleSheetSet(String name) {
        if (name == null || name.length() > 0 && !this.getStyleSheetSets().contains(name)) {
            return;
        }
        Iterator<LinkElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            DOMCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0) continue;
            if (title.equals(name)) {
                sheet.setDisabled(false);
                this.lastStyleSheetSet = name;
                continue;
            }
            sheet.setDisabled(true);
        }
    }

    @Override
    public String getLastStyleSheetSet() {
        return this.lastStyleSheetSet;
    }

    @Override
    public void enableStyleSheetsForSet(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        Iterator<LinkElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            DOMCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || !title.equals(name)) continue;
            sheet.setDisabled(false);
        }
    }

    void onEmbeddedStyleAdd(LinkStyle element) {
        if (element instanceof LinkElement) {
            this.linkedStyle.add((LinkElement)element);
        } else if (element instanceof StyleElement) {
            this.embeddedStyle.add((StyleElement)element);
        }
        this.onStyleModify();
    }

    void onEmbeddedStyleRemove(LinkStyle element) {
        String title;
        if (element instanceof LinkElement) {
            this.linkedStyle.remove(element);
        } else if (element instanceof StyleElement) {
            this.embeddedStyle.remove(element);
        }
        StyleSheet sheet = element.getSheet();
        if (sheet != null && (title = sheet.getTitle()) != null) {
            this.sheets.remove(title);
        }
        this.onStyleModify();
    }

    void onStyleModify() {
        if (this.mergedStyleSheet != null) {
            this.mergedStyleSheet = null;
            this.sheets.setNeedsUpdate(true);
        } else if (this.sheets != null) {
            this.sheets.setNeedsUpdate(true);
        }
    }

    @Override
    public DocumentCSSStyleSheet getDefaultStyleSheet() {
        return this.defStyleSheet;
    }

    public void setDefaultStyleSheet(DOMDocumentCSSStyleSheet styleSheet) {
        this.defStyleSheet = styleSheet;
        this.onStyleModify();
    }

    @Override
    public CSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt) {
        if (elt instanceof MyElement) {
            return ((MyElement)elt).getOverrideStyle(pseudoElt);
        }
        return null;
    }

    @Override
    public StyleDatabase getStyleDatabase() {
        StyleDatabase sdb = null;
        if (this.targetMedium != null) {
            sdb = this.getStyleSheetFactory().getDeviceFactory().getStyleDatabase(this.targetMedium);
        }
        return sdb;
    }

    @Override
    public void setTargetMedium(String medium) throws CSSMediaException {
        this.targetMedium = "all".equals(medium = medium.intern()) ? null : medium;
        this.onStyleModify();
    }

    @Override
    public CSSCanvas getCanvas() {
        if (this.targetMedium == null) {
            return null;
        }
        if (this.canvases.containsKey(this.targetMedium)) {
            return this.canvases.get(this.targetMedium);
        }
        CSSCanvas canvas = this.getStyleSheetFactory().getDeviceFactory().createCanvas(this.targetMedium, this);
        this.canvases.put(this.targetMedium, canvas);
        return canvas;
    }

    @Override
    public void onFontFaceRule(DOMCSSFontFaceRule rule) {
        for (CSSCanvas canvas : this.canvases.values()) {
            if (canvas == null) continue;
            canvas.loadFontFace(rule);
        }
    }

    @Override
    public void onPageRule(DOMCSSPageRule rule) {
    }

    public void onMetaAdded(String name, String attribute) {
        if ("Default-Style".equals(name)) {
            this.metaDefaultStyleSet = attribute;
        }
    }

    public void onMetaRemoved(String name, String attribute) {
        if ("Default-Style".equals(name)) {
            this.metaDefaultStyleSet = "";
        }
    }

    @Override
    public URL getBaseURL() {
        String buri = this.getBaseURI();
        if (buri == null) {
            return null;
        }
        try {
            return new URL(buri);
        }
        catch (MalformedURLException e) {
            try {
                return new URL(this.document.getDocumentURI());
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
    }

    @Override
    public String getBaseURI() {
        Element elm;
        String s;
        NodeList nl;
        String buri = this.document.getBaseURI();
        if (!this.document.isSupported("HTML", "1.0") && (nl = this.document.getElementsByTagName("base")).getLength() > 0 && (s = (elm = (Element)nl.item(0)).getAttribute("href")).length() > 0) {
            buri = s;
        }
        return buri;
    }

    @Override
    public URL getURL(String uri) throws MalformedURLException {
        if (uri.length() == 0) {
            throw new MalformedURLException("Empty URI");
        }
        URL url = uri.indexOf("://") < 0 ? new URL(this.getBaseURL(), uri) : new URL(uri);
        return url;
    }

    @Override
    public boolean isSafeOrigin(URL linkedURL) {
        URL base = this.getBaseURL();
        String docHost = base.getHost();
        int docPort = base.getPort();
        if (docPort == -1) {
            docPort = base.getDefaultPort();
        }
        String linkedHost = linkedURL.getHost();
        int linkedPort = linkedURL.getPort();
        if (linkedPort == -1) {
            linkedPort = linkedURL.getDefaultPort();
        }
        return (docHost.equalsIgnoreCase(linkedHost) || linkedHost.endsWith(docHost)) && docPort == linkedPort;
    }

    public InputStream openStream(String uri) throws IOException {
        return this.openConnection(this.getURL(uri)).getInputStream();
    }

    static class MyDOMCSSStyleDeclaration
    extends DOMCSSStyleDeclaration {
        public MyDOMCSSStyleDeclaration() {
        }

        public MyDOMCSSStyleDeclaration(BaseCSSStyleSheet parentSheet) {
            super(parentSheet);
        }

        public MyDOMCSSStyleDeclaration(BaseCSSStyleDeclaration copiedObject) {
            super(copiedObject);
        }

        @Override
        public boolean hasOverrideStyle(String pseudoElt) {
            Node node = this.getOwnerNode();
            if (node != null) {
                return ((MyElement)node).hasOverrideStyle(pseudoElt);
            }
            return false;
        }

        @Override
        public ComputedCSSStyle clone() {
            MyDOMCSSStyleDeclaration styleClone = new MyDOMCSSStyleDeclaration(this);
            styleClone.setOwnerNode(this.getOwnerNode());
            return styleClone;
        }
    }

    class MyDOMStyleSheetList
    extends DOMStyleSheetList {
        protected MyDOMStyleSheetList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected Iterator<StyleSheet> iterator() {
            return super.iterator();
        }

        @Override
        protected void clear() {
            super.clear();
        }

        @Override
        protected boolean needsUpdate() {
            return super.needsUpdate();
        }

        @Override
        protected void setNeedsUpdate(boolean needsUpdate) {
            super.setNeedsUpdate(needsUpdate);
        }

        @Override
        protected void update() {
            super.update();
            StylableDocumentWrapper.this.updateStyleLists();
        }
    }

    class StyleElement
    extends MyElement
    implements LinkStyle {
        private DOMCSSStyleSheet linkedSheet;

        StyleElement(Element element) {
            super(element);
            this.linkedSheet = null;
        }

        @Override
        public DOMCSSStyleSheet getSheet() {
            if (this.linkedSheet == null) {
                String type = this.getAttribute("type");
                if (!"text/css".equals(type)) {
                    return null;
                }
                String media = this.getAttribute("media");
                DOMMediaList mediaList = media == null || media.trim().length() == 0 ? DOMMediaList.create() : DOMMediaList.create(media);
                DOMCSSStyleSheet sheet = StylableDocumentWrapper.this.getStyleSheetFactory().createLinkedStyleSheet(this, this.getAttribute("title"), mediaList);
                String styleText = this.getTextContent().trim();
                if (styleText.length() > 0) {
                    sheet.setHref(this.getBaseURI());
                    InputSource source = new InputSource();
                    StringReader re = new StringReader(styleText);
                    source.setCharacterStream((Reader)re);
                    try {
                        sheet.parseCSSStyleSheet(source);
                        this.linkedSheet = sheet;
                    }
                    catch (DOMException e) {
                        StylableDocumentWrapper.this.getStyleSheetFactory().getErrorHandler().onException((Exception)e, sheet);
                    }
                    catch (IOException e) {
                        StylableDocumentWrapper.this.getStyleSheetFactory().getErrorHandler().onException((Exception)e, sheet);
                    }
                }
            }
            return this.linkedSheet;
        }
    }

    class LinkElement
    extends MyElement
    implements LinkStyle {
        private DOMCSSStyleSheet linkedSheet;

        LinkElement(Element element) {
            super(element);
            this.linkedSheet = null;
        }

        @Override
        public DOMCSSStyleSheet getSheet() {
            if (this.linkedSheet == null) {
                String type = this.getAttribute("type");
                if (!"text/css".equals(type)) {
                    return null;
                }
                String rel = this.getAttribute("rel");
                if (rel.length() > 0) {
                    String href;
                    String title = this.getAttribute("title");
                    if (title.length() == 0) {
                        title = null;
                    }
                    if (rel.equalsIgnoreCase("stylesheet")) {
                        String href2 = this.getAttribute("href");
                        if (href2.length() > 0) {
                            this.loadStyleSheet(href2, title);
                        }
                    } else if (rel.equalsIgnoreCase("alternate stylesheet") && (href = this.getAttribute("href")).length() > 0) {
                        this.loadStyleSheet(href, title);
                        if (this.linkedSheet != null) {
                            this.linkedSheet.setDisabled(true);
                        }
                    }
                }
            }
            return this.linkedSheet;
        }

        private void loadStyleSheet(String href, String title) {
            String media = this.getAttribute("media");
            DOMMediaList mediaList = media == null || media.trim().length() == 0 ? DOMMediaList.create() : DOMMediaList.create(media);
            DOMCSSStyleSheet sheet = StylableDocumentWrapper.this.getStyleSheetFactory().createLinkedStyleSheet(this, title, mediaList);
            try {
                sheet.loadStyleSheet(this.getOwnerDocument().getURL(href));
                this.linkedSheet = sheet;
            }
            catch (CSSException e) {
                StylableDocumentWrapper.this.getStyleSheetFactory().getErrorHandler().onException((Exception)((Object)e), sheet);
            }
            catch (IOException e) {
                StylableDocumentWrapper.this.getStyleSheetFactory().getErrorHandler().onException((Exception)e, sheet);
            }
        }
    }

    class MyElement
    extends MyNode
    implements CSSElement,
    ElementCSSInlineStyle {
        private Element element;
        private Map<String, DOMCSSStyleDeclaration> overrideStyleSet;

        MyElement(Element element) {
            super(element);
            this.overrideStyleSet = null;
            this.element = element;
        }

        @Override
        public String getTagName() {
            return this.element.getTagName();
        }

        @Override
        public String getAttribute(String name) {
            return this.element.getAttribute(name);
        }

        @Override
        public void setAttribute(String name, String value) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public void removeAttribute(String name) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public MyAttr getAttributeNode(String name) {
            Attr anode = this.element.getAttributeNode(name);
            if (anode == null) {
                return null;
            }
            return (MyAttr)this.getCSSNode(anode);
        }

        @Override
        public Attr setAttributeNode(Attr newAttr) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public NodeList getElementsByTagName(String name) {
            return new DOMNode.MyNodeList(this.element.getElementsByTagName(name));
        }

        @Override
        public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
            return this.element.getAttributeNS(namespaceURI, localName);
        }

        @Override
        public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
            return this.element.getAttributeNodeNS(namespaceURI, localName);
        }

        @Override
        public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
            return new DOMNode.MyNodeList(this.element.getElementsByTagNameNS(namespaceURI, localName));
        }

        @Override
        public boolean hasAttribute(String name) {
            return this.element.hasAttribute(name);
        }

        @Override
        public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
            return this.element.hasAttributeNS(namespaceURI, localName);
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            return this.element.getSchemaTypeInfo();
        }

        @Override
        public void setIdAttribute(String name, boolean isId) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public CSSStyleDeclaration getStyle() {
            MyDOMCSSStyleDeclaration styledecl = new MyDOMCSSStyleDeclaration();
            styledecl.setOwnerNode(this);
            String st = this.getAttribute("style");
            if (st.length() > 0) {
                try {
                    styledecl.setCssText(st);
                }
                catch (DOMException e) {
                    StylableDocumentWrapper.this.getStyleSheetFactory().getErrorHandler().onException((Exception)e, st);
                }
            }
            return styledecl;
        }

        boolean hasOverrideStyle(String pseudoElt) {
            if (this.overrideStyleSet == null) {
                return false;
            }
            return this.overrideStyleSet.containsKey(pseudoElt);
        }

        CSSStyleDeclaration getOverrideStyle(String pseudoElt) {
            DOMCSSStyleDeclaration overrideStyle = null;
            if (this.overrideStyleSet == null) {
                this.overrideStyleSet = new HashMap<String, DOMCSSStyleDeclaration>(1);
            } else {
                overrideStyle = this.overrideStyleSet.get(pseudoElt);
            }
            if (overrideStyle == null) {
                overrideStyle = new MyDOMCSSStyleDeclaration();
                overrideStyle.setOwnerNode(this);
                this.overrideStyleSet.put(pseudoElt, overrideStyle);
            }
            return overrideStyle;
        }
    }

    class MyAttr
    extends MyNode
    implements Attr {
        MyAttr(Attr attr) {
            super(attr);
        }

        @Override
        public String getName() {
            return ((Attr)this.rawnode).getName();
        }

        @Override
        public boolean getSpecified() {
            return ((Attr)this.rawnode).getSpecified();
        }

        @Override
        public String getValue() {
            return ((Attr)this.rawnode).getValue();
        }

        @Override
        public void setValue(String value) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public CSSElement getOwnerElement() {
            Element elm = ((Attr)this.rawnode).getOwnerElement();
            if (elm == null) {
                return null;
            }
            return (CSSElement)this.getCSSNode(elm);
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            return ((Attr)this.rawnode).getSchemaTypeInfo();
        }

        @Override
        public boolean isId() {
            return ((Attr)this.rawnode).isId();
        }
    }

    class MyCDATASection
    extends MyText
    implements CDATASection {
        MyCDATASection(CDATASection cdata) {
            super(cdata);
        }
    }

    class MyText
    extends MyCharacterData
    implements Text {
        MyText(Text text) {
            super(text);
        }

        @Override
        public Text splitText(int offset) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public boolean isElementContentWhitespace() {
            return ((Text)this.rawnode).isElementContentWhitespace();
        }

        @Override
        public String getWholeText() {
            return ((Text)this.rawnode).getWholeText();
        }

        @Override
        public Text replaceWholeText(String content) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }
    }

    class MyComment
    extends MyCharacterData
    implements Comment {
        MyComment(Comment cdata) {
            super(cdata);
        }
    }

    class MyCharacterData
    extends MyNode
    implements CharacterData {
        MyCharacterData(CharacterData cdata) {
            super(cdata);
        }

        @Override
        public String getData() throws DOMException {
            return ((CharacterData)this.rawnode).getData();
        }

        @Override
        public void setData(String data) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public int getLength() {
            return ((CharacterData)this.rawnode).getLength();
        }

        @Override
        public String substringData(int offset, int count) throws DOMException {
            return ((CharacterData)this.rawnode).substringData(offset, count);
        }

        @Override
        public void appendData(String arg) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public void insertData(int offset, String arg) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public void deleteData(int offset, int count) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }

        @Override
        public void replaceData(int offset, int count, String arg) throws DOMException {
            throw new DOMException(9, "This is a readonly wrapper.");
        }
    }

    class MyEntityReference
    extends MyNode
    implements EntityReference {
        MyEntityReference(EntityReference node) {
            super(node);
        }
    }

    class MyNode
    extends DOMNode {
        MyNode(Node node) {
            super(node);
        }

        @Override
        public CSSDocument getOwnerDocument() {
            return StylableDocumentWrapper.this;
        }

        @Override
        protected CSSNode getCSSNode(Node node) {
            return StylableDocumentWrapper.this.getCSSNode(node);
        }

        @Override
        protected CSSNode getMappedCSSNode(Node node) {
            return StylableDocumentWrapper.this.getMappedCSSNode(node);
        }
    }
}

