/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.SACParserFactory;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.CSSInheritedValue;
import io.sf.carte.doc.style.css.property.CSSUnknownValue;
import io.sf.carte.doc.style.css.property.DOMCSSValueList;
import io.sf.carte.doc.style.css.property.ExtendedCSSValue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class AbstractCSSValue
implements ExtendedCSSValue {
    private final short valueType;
    private String cssText = null;

    protected AbstractCSSValue(short valueType) {
        this.valueType = valueType;
    }

    protected AbstractCSSValue(AbstractCSSValue copied) {
        this(copied.valueType);
        this.cssText = copied.cssText;
    }

    @Override
    public String getCssText() {
        return this.cssText;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        if (this.isSubproperty()) {
            throw new DOMException(7, "This property was set with a shorthand. Must modify at the style-declaration level.");
        }
        this.setPlainCssText(cssText);
    }

    void setPlainCssText(String cssText) {
        this.cssText = cssText;
    }

    @Override
    public short getCssValueType() {
        return this.valueType;
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        return this.getCssText();
    }

    public boolean isSubproperty() {
        return false;
    }

    public boolean isSystemDefault() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.valueType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractCSSValue)) {
            return false;
        }
        AbstractCSSValue other = (AbstractCSSValue)obj;
        return this.valueType == other.valueType;
    }

    public static AbstractCSSValue parseProperty(String value) throws DOMException {
        return AbstractCSSValue.parseProperty(value, SACParserFactory.createSACParser());
    }

    public static AbstractCSSValue parseProperty(String value, Parser parser) throws DOMException {
        InputSource source = new InputSource();
        StringReader re = new StringReader(value);
        source.setCharacterStream((Reader)re);
        LexicalUnit lunit = null;
        try {
            lunit = parser.parsePropertyValue(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        AbstractCSSValue css = AbstractCSSValue.createCSSValue(lunit);
        if (css == null) {
            switch (lunit.getLexicalUnitType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    css = new CSSUnknownValue();
                    css.setCssText(value);
                    ((AbstractCSSPrimitiveValue)css).setLexicalUnit(lunit, false);
                }
            }
        }
        return css;
    }

    public static AbstractCSSValue createCSSValue(LexicalUnit lunit) {
        if (lunit.getNextLexicalUnit() != null) {
            AbstractCSSValue value;
            DOMCSSValueList superlist = null;
            DOMCSSValueList list = DOMCSSValueList.createWSValueList();
            LexicalUnit nlu = lunit;
            while ((value = AbstractCSSValue.createCSSValueItem(nlu, false)) != null) {
                nlu = value.getCssValueType() == 1 ? ((AbstractCSSPrimitiveValue)value).getNextLexicalUnit() : nlu.getNextLexicalUnit();
                if (nlu != null) {
                    if (nlu.getLexicalUnitType() == 0) {
                        nlu = nlu.getNextLexicalUnit();
                        if (superlist == null) {
                            superlist = DOMCSSValueList.createCSValueList();
                        }
                        if (list.getLength() > 0) {
                            list.add(value);
                            superlist.add(list);
                            list = DOMCSSValueList.createWSValueList();
                        } else {
                            superlist.add(value);
                        }
                    } else {
                        list.add(value);
                    }
                } else {
                    if (superlist == null || list.getLength() > 0) {
                        list.add(value);
                        break;
                    }
                    superlist.add(value);
                    break;
                }
                if (nlu != null) continue;
            }
            if (superlist != null) {
                if (list.getLength() > 0 && !superlist.item(superlist.getLength() - 1).equals(list)) {
                    superlist.add(list);
                }
                if ((value = AbstractCSSValue.listOrFirstItem(superlist)).getCssValueType() == 2) {
                    return AbstractCSSValue.listOrFirstItem((DOMCSSValueList)value);
                }
                return value;
            }
            return AbstractCSSValue.listOrFirstItem(list);
        }
        return AbstractCSSValue.createCSSValueItem(lunit, false);
    }

    private static AbstractCSSValue listOrFirstItem(DOMCSSValueList list) {
        int ll = list.getLength();
        if (ll > 1) {
            return list;
        }
        if (ll == 1) {
            return list.item(0);
        }
        return null;
    }

    public static AbstractCSSValue createCSSValueItem(LexicalUnit lunit, boolean subproperty) {
        switch (lunit.getLexicalUnitType()) {
            case 12: {
                CSSInheritedValue value = CSSInheritedValue.getValue();
                if (subproperty) {
                    value = value.asSubproperty();
                }
                return value;
            }
        }
        return AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lunit, subproperty);
    }

    public String toString() {
        return this.getCssText();
    }
}

