/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class CSSNumberValue
extends AbstractCSSPrimitiveValue {
    protected float realvalue = 0.0f;
    private String dimensionUnitText = "";
    private boolean asInteger = false;

    CSSNumberValue() {
    }

    protected CSSNumberValue(CSSNumberValue copied) {
        super(copied);
        this.realvalue = copied.realvalue;
        this.asInteger = copied.asInteger;
        this.dimensionUnitText = copied.dimensionUnitText;
    }

    @Override
    public String getCssText() {
        boolean notaNumber;
        boolean bl = notaNumber = this.getPrimitiveType() != 1;
        if (this.realvalue == 0.0f && notaNumber && this.getPrimitiveType() != 2) {
            return "0";
        }
        double rintValue = Math.rint(this.realvalue);
        if (this.asInteger) {
            return Integer.toString((int)rintValue);
        }
        if ((double)this.realvalue == rintValue ? notaNumber : this.getPrimitiveType() == 2) {
            return Integer.toString((int)rintValue) + this.dimensionUnitText;
        }
        return Float.toString(this.realvalue) + this.dimensionUnitText;
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        if (this.isSubproperty()) {
            throw new DOMException(7, "This property was set with a shorthand. Must modify the whole style declaration.");
        }
        this.setCSSUnitType(unitType);
        this.realvalue = floatValue;
        this.dimensionUnitText = CSSNumberValue.dimensionUnitString(unitType);
        this.asInteger = false;
    }

    public void setFloatValuePt(float floatValue) {
        this.setCSSUnitType((short)9);
        this.realvalue = floatValue;
        this.dimensionUnitText = "pt";
        this.asInteger = (double)Math.abs(this.realvalue - (float)Math.floor(this.realvalue)) < 0.01;
    }

    public void setIntegerValue(int intValue) {
        this.realvalue = intValue;
        this.setCSSUnitType((short)1);
        this.asInteger = true;
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        if (unitType == this.getPrimitiveType() || unitType == 1) {
            return this.realvalue;
        }
        return CSSNumberValue.floatValueConversion(this.realvalue, this.getPrimitiveType(), unitType);
    }

    public static float floatValueConversion(float fvalue, short declType, short unitType) throws DOMException {
        if (fvalue == 0.0f) {
            return 0.0f;
        }
        switch (declType) {
            case 9: {
                if (unitType == 5) {
                    return fvalue / 0.75f;
                }
                if (unitType == 8) {
                    return fvalue / 72.0f;
                }
                if (unitType == 10) {
                    return fvalue / 12.0f;
                }
                if (unitType == 6) {
                    return fvalue / 28.34646f;
                }
                if (unitType != 7) break;
                return fvalue / 2.834646f;
            }
            case 5: {
                if (unitType == 9) {
                    return fvalue * 0.75f;
                }
                if (unitType == 8) {
                    return fvalue / 96.0f;
                }
                if (unitType == 10) {
                    return fvalue / 16.0f;
                }
                if (unitType == 6) {
                    return fvalue / 37.795f;
                }
                if (unitType != 7) break;
                return fvalue / 3.7795f;
            }
            case 10: {
                if (unitType == 9) {
                    return fvalue * 12.0f;
                }
                if (unitType == 8) {
                    return fvalue / 6.0f;
                }
                if (unitType == 5) {
                    return fvalue * 16.0f;
                }
                if (unitType == 6) {
                    return fvalue / 2.3622f;
                }
                if (unitType != 7) break;
                return fvalue * 4.2333f;
            }
            case 8: {
                if (unitType == 5) {
                    return fvalue * 96.0f;
                }
                if (unitType == 9) {
                    return fvalue * 72.0f;
                }
                if (unitType == 10) {
                    return fvalue * 6.0f;
                }
                if (unitType == 6) {
                    return fvalue * 2.54f;
                }
                if (unitType != 7) break;
                return fvalue * 25.4f;
            }
            case 6: {
                if (unitType == 9) {
                    return fvalue * 28.34646f;
                }
                if (unitType == 8) {
                    return fvalue / 2.54f;
                }
                if (unitType == 5) {
                    return fvalue * 37.795f;
                }
                if (unitType == 10) {
                    return fvalue * 2.3622f;
                }
                if (unitType != 7) break;
                return fvalue * 10.0f;
            }
            case 7: {
                if (unitType == 9) {
                    return fvalue * 2.834646f;
                }
                if (unitType == 8) {
                    return fvalue * 3.937f;
                }
                if (unitType == 5) {
                    return fvalue * 3.7795f;
                }
                if (unitType == 10) {
                    return fvalue * 0.23622f;
                }
                if (unitType != 6) break;
                return fvalue * 0.1f;
            }
            case 14: {
                if (unitType != 15) break;
                return fvalue * 1000.0f;
            }
            case 15: {
                if (unitType != 14) break;
                return fvalue * 0.001f;
            }
            case 11: {
                if (unitType == 12) {
                    return (float)Math.toRadians(fvalue);
                }
                if (unitType != 13) break;
                return fvalue * 1.1111112f;
            }
            case 12: {
                if (unitType == 11) {
                    return (float)Math.toDegrees(fvalue);
                }
                if (unitType != 13) break;
                return fvalue * 63.661976f;
            }
        }
        throw new DOMException(15, "Cannot transform unit " + CSSNumberValue.dimensionUnitString(declType) + " to " + CSSNumberValue.dimensionUnitString(unitType));
    }

    public String getDimensionUnitText() {
        return this.dimensionUnitText;
    }

    @Override
    void setLexicalUnit(LexicalUnit lunit, boolean subp) {
        super.setLexicalUnit(lunit, subp);
        this.nextLexicalUnit = lunit.getNextLexicalUnit();
        switch (lunit.getLexicalUnitType()) {
            case 13: {
                this.realvalue = lunit.getIntegerValue();
                this.asInteger = true;
                break;
            }
            default: {
                this.realvalue = lunit.getFloatValue();
                this.asInteger = false;
                this.dimensionUnitText = lunit.getDimensionUnitText();
            }
        }
        this.setSubproperty(subp);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Float.floatToIntBits(this.realvalue);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CSSNumberValue)) {
            return false;
        }
        CSSNumberValue other = (CSSNumberValue)obj;
        return Float.floatToIntBits(this.realvalue) == Float.floatToIntBits(other.realvalue);
    }

    @Override
    public CSSNumberValue clone() {
        return new CSSNumberValue(this);
    }

    static String dimensionUnitString(short unitType) {
        switch (unitType) {
            case 3: {
                return "em";
            }
            case 4: {
                return "ex";
            }
            case 5: {
                return "px";
            }
            case 8: {
                return "in";
            }
            case 6: {
                return "cm";
            }
            case 7: {
                return "mm";
            }
            case 9: {
                return "pt";
            }
            case 10: {
                return "pc";
            }
            case 2: {
                return "%";
            }
            case 11: {
                return "deg";
            }
            case 13: {
                return "grad";
            }
            case 12: {
                return "rad";
            }
            case 14: {
                return "ms";
            }
            case 15: {
                return "s";
            }
            case 16: {
                return "Hz";
            }
            case 17: {
                return "kHz";
            }
        }
        return "";
    }
}

