/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import java.util.LinkedList;
import java.util.List;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public class DOMCSSFunctionValue
extends AbstractCSSPrimitiveValue {
    private String functionName = null;
    private List<CSSPrimitiveValue> arguments = new LinkedList<CSSPrimitiveValue>();

    public DOMCSSFunctionValue() {
    }

    protected DOMCSSFunctionValue(DOMCSSFunctionValue copied) {
        super(copied);
        this.functionName = copied.functionName;
        this.arguments = copied.arguments;
    }

    public List<CSSPrimitiveValue> getArguments() {
        return this.arguments;
    }

    @Override
    void setLexicalUnit(LexicalUnit lunit, boolean subp) {
        super.setLexicalUnit(lunit, subp);
        this.functionName = lunit.getFunctionName();
        LexicalUnit lu = lunit.getParameters();
        while (lu != null) {
            this.arguments.add(AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lu, subp));
            if ((lu = lu.getNextLexicalUnit()) == null) continue;
            if (lu.getLexicalUnitType() != 0) {
                throw new DOMException(12, "Bad function " + this.functionName);
            }
            lu = lu.getNextLexicalUnit();
        }
        this.nextLexicalUnit = null;
        this.setSubproperty(subp);
    }

    @Override
    public String getCssText() {
        StringBuilder buf = new StringBuilder(this.functionName.length() + this.arguments.size() * 6 + 8);
        buf.append(this.functionName).append('(');
        int sz = this.arguments.size();
        if (sz > 0) {
            buf.append(this.arguments.get(0));
            for (int i = 1; i < sz; ++i) {
                buf.append(',').append(' ').append(this.arguments.get(i).getCssText());
            }
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText(String pname) {
        StringBuilder buf = new StringBuilder(this.functionName.length() + this.arguments.size() * 6 + 8);
        buf.append(this.functionName).append('(');
        int sz = this.arguments.size();
        if (sz > 0) {
            buf.append(this.arguments.get(0));
            for (int i = 0; i < sz; ++i) {
                buf.append(',').append(((AbstractCSSPrimitiveValue)this.arguments.get(i)).getMinifiedCssText(pname));
            }
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String getStringValue() throws DOMException {
        return this.functionName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = 31 * result + (this.functionName == null ? 0 : this.functionName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DOMCSSFunctionValue other = (DOMCSSFunctionValue)obj;
        if (this.arguments == null ? other.arguments != null : !this.arguments.equals(other.arguments)) {
            return false;
        }
        return !(this.functionName == null ? other.functionName != null : !this.functionName.equals(other.functionName));
    }

    @Override
    public DOMCSSFunctionValue clone() {
        return new DOMCSSFunctionValue(this);
    }
}

