/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSURIValue;
import io.sf.carte.doc.style.css.property.CSSURIValueWrapper;
import io.sf.carte.doc.style.css.property.ExtendedCSSValue;
import io.sf.carte.doc.style.css.property.WrappedValue;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public abstract class DOMCSSValueList
extends AbstractCSSValue
implements CSSValueList {
    protected List<AbstractCSSValue> valueList;
    private boolean subproperty = false;

    private DOMCSSValueList() {
        super((short)2);
        this.valueList = new ArrayList<AbstractCSSValue>();
    }

    private DOMCSSValueList(DOMCSSValueList copy) {
        super((short)2);
        this.valueList = new ArrayList<AbstractCSSValue>(copy.valueList);
    }

    @Override
    public int getLength() {
        return this.valueList.size();
    }

    @Override
    public AbstractCSSValue item(int index) {
        return this.valueList.get(index);
    }

    public void add(AbstractCSSValue value) {
        this.valueList.add(value);
    }

    public ExtendedCSSValue remove(int index) {
        return this.valueList.remove(index);
    }

    public void set(int index, AbstractCSSValue value) {
        this.valueList.set(index, value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode() * 31;
        if (this.valueList != null) {
            for (ExtendedCSSValue extendedCSSValue : this.valueList) {
                result = 31 * result + (extendedCSSValue == null ? 0 : extendedCSSValue.hashCode());
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DOMCSSValueList other = (DOMCSSValueList)obj;
        if (this.valueList.isEmpty()) {
            if (!other.valueList.isEmpty()) {
                return false;
            }
        } else {
            if (this.valueList.size() != other.valueList.size()) {
                return false;
            }
            int sz = this.valueList.size();
            for (int i = 0; i < sz; ++i) {
                ExtendedCSSValue item = this.valueList.get(i);
                ExtendedCSSValue oitem = other.valueList.get(i);
                if (!(item == null ? oitem != null : !item.equals(oitem))) continue;
                return false;
            }
        }
        return true;
    }

    public void setSubproperty(boolean subp) {
        this.subproperty = subp;
    }

    @Override
    public boolean isSubproperty() {
        return this.subproperty;
    }

    public abstract boolean isCommaSeparated();

    public abstract DOMCSSValueList clone();

    public static DOMCSSValueList createCSValueList() {
        return new CSValueList();
    }

    public static DOMCSSValueList createWSValueList() {
        return new WSValueList();
    }

    public abstract DOMCSSValueList wrap(String var1);

    private static class WSValueList
    extends DOMCSSValueList {
        private WSValueList() {
        }

        private WSValueList(DOMCSSValueList copy) {
            super(copy);
        }

        @Override
        public String getCssText() {
            if (this.valueList.isEmpty()) {
                return "";
            }
            StringBuilder buf = new StringBuilder(this.valueList.size() * 24 + 16);
            buf.append(((AbstractCSSValue)this.item(0)).getCssText());
            int sz = this.valueList.size();
            for (int i = 1; i < sz; ++i) {
                buf.append(' ').append(((AbstractCSSValue)this.item(i)).getCssText());
            }
            return buf.toString();
        }

        @Override
        public String getMinifiedCssText(String propertyName) {
            if (this.valueList.isEmpty()) {
                return "";
            }
            StringBuilder buf = new StringBuilder(this.valueList.size() * 24 + 16);
            buf.append(((AbstractCSSValue)this.item(0)).getCssText());
            int sz = this.valueList.size();
            for (int i = 1; i < sz; ++i) {
                buf.append(' ').append(((AbstractCSSValue)this.item(i)).getMinifiedCssText(propertyName));
            }
            return buf.toString();
        }

        @Override
        public boolean isCommaSeparated() {
            return false;
        }

        @Override
        public DOMCSSValueList clone() {
            return new WSValueList(this);
        }

        @Override
        public DOMCSSValueList wrap(String parentSheetHref) {
            return new WSValueListWrapper(this, parentSheetHref);
        }

        public class WSValueListWrapper
        extends WSValueList
        implements WrappedValue {
            private String parentSheetHref;

            WSValueListWrapper(DOMCSSValueList copy, String parentSheetHref) {
                super(copy);
                this.parentSheetHref = parentSheetHref;
            }

            @Override
            public String getParentSheetHref() {
                return this.parentSheetHref;
            }

            @Override
            public AbstractCSSValue item(int index) {
                CSSValue val = super.item(index);
                if (val != null && ((AbstractCSSValue)val).getCssValueType() == 1 && ((CSSPrimitiveValue)val).getPrimitiveType() == 20) {
                    return new CSSURIValueWrapper((CSSURIValue)val, this.parentSheetHref);
                }
                return val;
            }

            @Override
            public DOMCSSValueList clone() {
                return new WSValueListWrapper(super.clone(), this.parentSheetHref);
            }
        }
    }

    private static class CSValueList
    extends DOMCSSValueList {
        private CSValueList() {
        }

        private CSValueList(DOMCSSValueList copy) {
            super(copy);
        }

        @Override
        public String getCssText() {
            if (this.valueList.isEmpty()) {
                return "";
            }
            StringBuilder buf = new StringBuilder(this.valueList.size() * 24 + 16);
            buf.append(((AbstractCSSValue)this.item(0)).getCssText());
            int sz = this.valueList.size();
            for (int i = 1; i < sz; ++i) {
                buf.append(',').append(' ').append(((AbstractCSSValue)this.item(i)).getCssText());
            }
            return buf.toString();
        }

        @Override
        public String getMinifiedCssText(String propertyName) {
            if (this.valueList.isEmpty()) {
                return "";
            }
            StringBuilder buf = new StringBuilder(this.valueList.size() * 24 + 16);
            buf.append(((AbstractCSSValue)this.item(0)).getCssText());
            int sz = this.valueList.size();
            for (int i = 1; i < sz; ++i) {
                buf.append(',').append(((AbstractCSSValue)this.item(i)).getMinifiedCssText(propertyName));
            }
            return buf.toString();
        }

        @Override
        public boolean isCommaSeparated() {
            return true;
        }

        @Override
        public DOMCSSValueList clone() {
            return new CSValueList(this);
        }

        @Override
        public DOMCSSValueList wrap(String parentSheetHref) {
            return new CSValueListWrapper(this, parentSheetHref);
        }

        public class CSValueListWrapper
        extends CSValueList
        implements WrappedValue {
            private String parentSheetHref;

            CSValueListWrapper(DOMCSSValueList copy, String parentSheetHref) {
                super(copy);
                this.parentSheetHref = parentSheetHref;
            }

            @Override
            public String getParentSheetHref() {
                return this.parentSheetHref;
            }

            @Override
            public AbstractCSSValue item(int index) {
                CSSValue val = super.item(index);
                if (val != null && ((AbstractCSSValue)val).getCssValueType() == 1 && ((CSSPrimitiveValue)val).getPrimitiveType() == 20) {
                    return new CSSURIValueWrapper((CSSURIValue)val, this.parentSheetHref);
                }
                return val;
            }

            @Override
            public DOMCSSValueList clone() {
                return new CSValueListWrapper(super.clone(), this.parentSheetHref);
            }
        }
    }
}

