/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.xml.dtd;

import io.sf.jclf.text.TokenParser;
import org.xml.sax.SAXException;

public class DocumentTypeDeclaration {
    private String name;
    private String publicId;
    private String systemId;
    public static final String XHTML1_TRA_DTDECL = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";
    public static final String XHTML1_TRA_PUBLICID = "-//W3C//DTD XHTML 1.0 Transitional//EN";

    public DocumentTypeDeclaration(String publicId) {
        this(null, publicId, null);
    }

    public DocumentTypeDeclaration(String name, String publicId, String systemId) {
        this.name = name;
        this.publicId = publicId;
        this.systemId = systemId;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static DocumentTypeDeclaration parse(String documentTypeDeclaration) throws SAXException {
        int i = documentTypeDeclaration.indexOf(60);
        int j = documentTypeDeclaration.lastIndexOf(62, documentTypeDeclaration.length() - 1);
        if (j < i || j <= 0) {
            throw new SAXException("Not a Document Type Declaration: " + documentTypeDeclaration);
        }
        TokenParser tp = new TokenParser(documentTypeDeclaration.substring(i + 1, j), " ");
        if (!(tp.hasNext() && tp.nextToken().equals("!DOCTYPE") && tp.hasNext())) {
            throw new SAXException("Not a Document Type Declaration: " + documentTypeDeclaration);
        }
        String name = tp.nextToken();
        if (!tp.hasNext()) {
            throw new SAXException("Unparseable Document Type Declaration: " + documentTypeDeclaration);
        }
        String idtype = tp.nextToken();
        if (!tp.hasNext()) {
            throw new SAXException("Unparseable Document Type Declaration: " + documentTypeDeclaration);
        }
        String id = tp.nextToken();
        String publicId = null;
        String systemId = null;
        if (idtype.equals("PUBLIC")) {
            publicId = id;
            if (tp.hasNext()) {
                systemId = tp.nextToken();
            }
        } else if (idtype.equals("SYSTEM")) {
            systemId = id;
        }
        return new DocumentTypeDeclaration(name, publicId, systemId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("<!DOCTYPE ").append(this.name);
        if (this.publicId != null) {
            buf.append(" PUBLIC \"").append(this.publicId).append('\"');
        }
        if (this.systemId != null) {
            buf.append(" \"").append(this.systemId).append('\"');
        }
        buf.append('>');
        return buf.toString();
    }
}

