/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.agent;

import io.sf.carte.doc.agent.AuthenticationCredentials;
import io.sf.carte.doc.agent.Cookie;
import io.sf.carte.doc.agent.CookieConfig;
import io.sf.carte.doc.agent.DefaultCookie;
import io.sf.carte.doc.agent.LogUserAgentErrorHandler;
import io.sf.carte.doc.agent.OriginPolicy;
import io.sf.carte.doc.agent.UserAgent;
import io.sf.carte.doc.agent.UserAgentErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;

public abstract class AbstractUserAgent
implements UserAgent,
UserAgent.AgentControl {
    private static final String HEADER_COOKIE = "Cookie";
    private static final String HEADER_SET_COOKIE = "Set-Cookie";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_AGENT = "User-agent";
    private OriginPolicy originPolicy = null;
    private UserAgentErrorHandler errorHandler = new LogUserAgentErrorHandler();
    private Map<String, Set<Cookie>> cookieMap = new HashMap<String, Set<Cookie>>();
    private SimpleDateFormat cookieDateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz", Locale.US);
    private CookieConfig globalConfig = new GlobalCookieConfig();
    private Map<String, Set<AuthenticationCredentials>> credentialMap = new HashMap<String, Set<AuthenticationCredentials>>();
    private String userAgentId = "Mozilla/4.0 (compatible; CSS4J)";
    private int timeout = 100000;

    protected AbstractUserAgent() {
    }

    protected OriginPolicy getOriginPolicy() {
        return this.originPolicy;
    }

    public void setOriginPolicy(OriginPolicy originPolicy) {
        this.originPolicy = originPolicy;
    }

    @Override
    public UserAgent.AgentControl getAgentControl() {
        return this;
    }

    @Override
    public CookieConfig getCookieConfig() {
        return this.globalConfig;
    }

    @Override
    public String getProperty(String propertyName) {
        return null;
    }

    @Override
    public void setProperty(String propertyName, String value) {
    }

    @Override
    public AuthenticationCredentials getAuthenticationCredentials(URL url, String realm) {
        Set<AuthenticationCredentials> credset = this.credentialMap.get(url.getHost());
        if (credset != null) {
            for (AuthenticationCredentials cred : credset) {
                String orealm = cred.getRealm();
                if (realm != null && !realm.equals(orealm)) continue;
                return cred;
            }
        }
        return null;
    }

    @Override
    public AuthenticationCredentials authenticationCredentials(String host, String realm) {
        if (realm == null) {
            throw new NullPointerException("Attempt to create a null realm.");
        }
        Set<AuthenticationCredentials> credset = this.credentialMap.get(host);
        if (credset == null) {
            credset = new HashSet<AuthenticationCredentials>();
        } else {
            for (AuthenticationCredentials cred : credset) {
                if (!realm.equals(cred.getRealm())) continue;
                return cred;
            }
        }
        MyAuthenticationCredentials creds = new MyAuthenticationCredentials(realm);
        credset.add(creds);
        return creds;
    }

    @Override
    public void setConnectionTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean isVisitedURL(URL url) {
        return false;
    }

    public void setUseragentId(String userAgentId) {
        this.userAgentId = userAgentId;
    }

    protected Reader inputStreamToReader(InputStream is, String conType) throws IOException {
        PushbackReader re;
        int iread;
        int idx;
        String charset = null;
        if (conType == null) {
            conType = URLConnection.guessContentTypeFromStream(is);
        }
        if (conType != null && (idx = conType.indexOf("charset=")) >= 0) {
            charset = conType.substring(idx + 8).replace('\"', ' ').replace('\'', ' ').trim().toUpperCase(Locale.US);
        }
        if ((iread = (re = charset != null ? new PushbackReader(new InputStreamReader(is, charset), 1) : new PushbackReader(new InputStreamReader(is, "utf-8"), 1)).read()) != -1 && iread == 0xEFBBBF) {
            charset = "utf-8";
        } else {
            re.unread(iread);
        }
        return re;
    }

    protected URLConnection openConnection(URL url, long creationDate) throws IOException {
        URLConnection con = this.createConnection(url);
        con.setConnectTimeout(this.timeout);
        if (con instanceof HttpURLConnection) {
            HttpURLConnection hcon = (HttpURLConnection)con;
            this.setCookies(hcon, url, creationDate);
            this.setCredentials(hcon, url, null, creationDate);
            if (this.userAgentId != null) {
                hcon.setRequestProperty(HEADER_AGENT, this.userAgentId);
            }
        }
        con.setAllowUserInteraction(false);
        return con;
    }

    protected URLConnection createConnection(URL url) throws IOException {
        return url.openConnection();
    }

    private void setCredentials(HttpURLConnection hcon, URL url, String realm, long creationDate) {
        AuthenticationCredentials creds = this.getAuthenticationCredentials(url, realm);
        if (creds != null && creds.getAuthType() == 1) {
            hcon.setRequestProperty(HEADER_AUTHORIZATION, AbstractUserAgent.basicToken(creds));
        }
    }

    private static String basicToken(AuthenticationCredentials creds) {
        StringBuffer sb = new StringBuffer(64);
        sb.append("Basic ").append(creds.getLoginPrincipal().getName()).append(':');
        if (creds.getPassword() != null) {
            sb.append(creds.getPassword());
        }
        String s = null;
        try {
            s = new String(Base64.encodeBase64((byte[])sb.toString().getBytes()), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int i = s.indexOf(61);
        if (i != -1) {
            return s.substring(0, i);
        }
        return s;
    }

    private void setCookies(HttpURLConnection hcon, URL url, long creationDate) {
        String domain;
        HashSet<Cookie> matchingCookies = new HashSet<Cookie>(8);
        String host = url.getHost().toLowerCase(Locale.US);
        Set<Cookie> cookies = this.cookieMap.get(host);
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!AbstractUserAgent.match(cookie, url, host, creationDate)) continue;
                matchingCookies.add(cookie);
            }
            AbstractUserAgent.setCookies(hcon, matchingCookies);
        }
        if ((domain = this.originPolicy.domainFromHostname(host)) != host && (cookies = this.cookieMap.get(host)) != null) {
            for (Cookie cookie : cookies) {
                if (!AbstractUserAgent.match(cookie, url, host, creationDate)) continue;
                matchingCookies.add(cookie);
            }
            AbstractUserAgent.setCookies(hcon, matchingCookies);
        }
    }

    protected void readCookies(HttpURLConnection hcon, long creationDate) {
        if (this.globalConfig.acceptsAllCookies() || this.globalConfig.acceptsSessionCookies()) {
            String s = hcon.getHeaderField(HEADER_SET_COOKIE);
            if (s == null) {
                return;
            }
            URL url = hcon.getURL();
            String host = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                Cookie ck = this.parseCookie(st.nextToken().trim(), host, port, creationDate);
                if (ck == null) continue;
                if (this.originPolicy.isTopLevelSuffix(ck.getDomain())) {
                    this.errorHandler.onSuperCookie(url, ck.getDomain());
                    continue;
                }
                Set<Cookie> set = this.cookieMap.get(ck.getDomain());
                if (set == null) {
                    set = new HashSet<Cookie>(8);
                    this.cookieMap.put(ck.getDomain(), set);
                }
                set.add(ck);
            }
        }
    }

    Cookie parseCookie(String ckhdr, String host, int port, long creationDate) {
        StringTokenizer st = new StringTokenizer(ckhdr, ";");
        if (!st.hasMoreTokens()) {
            return null;
        }
        String valor = st.nextToken().trim();
        int i = valor.indexOf(61);
        if (i == -1) {
            return null;
        }
        String clave = valor.substring(0, i).trim();
        valor = valor.substring(i + 1).trim();
        DefaultCookie ck = new DefaultCookie(port, clave, valor);
        while (st.hasMoreTokens()) {
            valor = st.nextToken().trim();
            i = valor.indexOf(61);
            if (i == -1) {
                if ("Secure".equalsIgnoreCase(valor)) {
                    ck.setSecure();
                    continue;
                }
                if (!"HttpOnly".equalsIgnoreCase(valor)) continue;
                ck.setHttpOnly();
                continue;
            }
            clave = valor.substring(0, i).trim();
            valor = valor.substring(i + 1).trim();
            if ("path".equalsIgnoreCase(clave)) {
                ck.setPath(valor);
                continue;
            }
            if ("max-age".equalsIgnoreCase(clave)) {
                ck.setExpiryTime(Long.parseLong(valor) + creationDate);
                continue;
            }
            if ("Expires".equalsIgnoreCase(clave)) {
                try {
                    ck.setExpiryTime(this.cookieDateFormat.parse(valor).getTime());
                }
                catch (ParseException parseException) {}
                continue;
            }
            if (!"domain".equalsIgnoreCase(clave)) continue;
            ck.setDomain(valor.toLowerCase(Locale.US));
        }
        if (!this.globalConfig.acceptsAllCookies() && ck.isPersistent()) {
            return null;
        }
        if (ck.getDomain() == null) {
            ck.setDomain(host);
        } else if (!host.endsWith(ck.getDomain())) {
            return null;
        }
        return ck;
    }

    static void setCookies(HttpURLConnection hcon, Set<Cookie> matchingCookies) {
        Iterator<Cookie> it = matchingCookies.iterator();
        StringBuffer sb = new StringBuffer(256);
        if (it.hasNext()) {
            AbstractUserAgent.formatCookie(sb, it.next());
        }
        while (it.hasNext()) {
            sb.append(',');
            AbstractUserAgent.formatCookie(sb, it.next());
        }
        hcon.setRequestProperty(HEADER_COOKIE, sb.toString());
    }

    private static void formatCookie(StringBuffer sb, Cookie ck) {
        sb.append(ck.getName()).append('=').append(ck.getValue());
        String s = ck.getPath();
        if (s != null) {
            sb.append(';').append("Path=").append(s);
        }
    }

    static boolean match(Cookie cookie, URL url, String host, long creationDate) {
        return !(!host.endsWith(cookie.getDomain()) || !AbstractUserAgent.matchPath(url.getPath(), cookie.getPath()) || cookie.isSecure() && !"https".equals(url.getProtocol()) || !AbstractUserAgent.matchPort(url, cookie.getPorts()) || cookie.isPersistent() && creationDate >= cookie.getExpiryTime());
    }

    static boolean matchPath(String uPath, String cPath) {
        if (uPath == cPath) {
            return true;
        }
        return uPath != null && uPath.startsWith(cPath);
    }

    private static boolean matchPort(URL url, int[] ports) {
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        if (ports[0] == port) {
            return true;
        }
        int pl = ports.length;
        for (int i = 1; i < pl; ++i) {
            if (ports[i] != port) continue;
            return true;
        }
        return false;
    }

    static class MyAuthenticationCredentials
    implements AuthenticationCredentials {
        private Principal loginPrincipal = null;
        private String password = null;
        private final String realm;
        private byte authtype = 1;

        MyAuthenticationCredentials(String realm) {
            this.realm = realm;
        }

        @Override
        public Principal getLoginPrincipal() {
            return this.loginPrincipal;
        }

        @Override
        public void setLoginPrincipal(Principal loginPrincipal) {
            this.loginPrincipal = loginPrincipal;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        @Override
        public void setPassword(String password) {
            this.password = password;
        }

        @Override
        public String getRealm() {
            return this.realm;
        }

        @Override
        public void setAuthType(byte authtype) {
            this.authtype = authtype;
        }

        @Override
        public byte getAuthType() {
            return this.authtype;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.authtype;
            result = 31 * result + (this.loginPrincipal == null ? 0 : this.loginPrincipal.hashCode());
            result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
            result = 31 * result + (this.realm == null ? 0 : this.realm.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MyAuthenticationCredentials other = (MyAuthenticationCredentials)obj;
            if (this.authtype != other.authtype) {
                return false;
            }
            if (this.loginPrincipal == null ? other.loginPrincipal != null : !this.loginPrincipal.equals(other.loginPrincipal)) {
                return false;
            }
            if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
                return false;
            }
            return !(this.realm == null ? other.realm != null : !this.realm.equals(other.realm));
        }

        public String toString() {
            return "[loginPrincipal=" + this.loginPrincipal + ", password=" + this.password + ", realm=" + this.realm + "]";
        }
    }

    static class GlobalCookieConfig
    implements CookieConfig {
        private boolean acceptAllCookies = false;
        private boolean acceptSessionCookies = false;

        GlobalCookieConfig() {
        }

        @Override
        public boolean acceptsAllCookies() {
            return this.acceptAllCookies;
        }

        @Override
        public void setAcceptAllCookies(boolean acceptAllCookies) {
            if (acceptAllCookies) {
                this.acceptSessionCookies = true;
            }
            this.acceptAllCookies = acceptAllCookies;
        }

        @Override
        public boolean acceptsSessionCookies() {
            return this.acceptSessionCookies;
        }

        @Override
        public void setAcceptSessionCookies(boolean acceptSessionCookies) {
            if (!acceptSessionCookies) {
                this.acceptAllCookies = false;
            }
            this.acceptSessionCookies = acceptSessionCookies;
        }
    }
}

