/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.html;

import io.sf.carte.doc.DOMStringListImpl;
import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.agent.OriginPolicy;
import io.sf.carte.doc.html.CSSDOMImplementation;
import io.sf.carte.doc.html.DOMNode;
import io.sf.carte.doc.html.ElementList;
import io.sf.carte.doc.html.HTMLElement;
import io.sf.carte.doc.html.ParentNode;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSNode;
import io.sf.carte.doc.style.css.CSSRuleListener;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.MediaQueryFactory;
import io.sf.carte.doc.style.css.om.OMMediaList;
import io.sf.carte.doc.style.css.om.OMStyleSheetList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.stylesheets.LinkStyle;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public abstract class HTMLDocument
extends DOMNode
implements CSSDocument,
ParentNode,
CSSRuleListener {
    public static final String HTML_NAMESPACE_URI = "http://www.w3.org/1999/xhtml";
    private String idAttrName = "id";
    private DOMConfiguration domConfig = new MyDOMConfiguration();
    private DocumentType documentType = null;
    private boolean xmlStandalone = false;
    private boolean strictErrorChecking = true;
    public DOMErrorHandler errorHandler = null;
    private String inputEncoding = null;
    private String documentURI = null;
    private static final DOMNode.DOMNodeList nvemptyNodeList = new DOMNode.NVEmptyNodeList();
    private BaseDocumentCSSStyleSheet mergedStyleSheet = null;
    private URL baseURL = null;
    Set<LinkElement> linkedStyle = new LinkedHashSet<LinkElement>(4);
    Set<StyleElement> embeddedStyle = new LinkedHashSet<StyleElement>(3);
    private MyOMStyleSheetList sheets = new MyOMStyleSheetList(7);
    private String metaDefaultStyleSet = "";
    private String lastStyleSheetSet = null;
    private String targetMedium = null;
    private Map<String, CSSCanvas> canvases = new HashMap<String, CSSCanvas>(3);

    public HTMLDocument(DocumentType documentType) {
        super((short)9);
        this.documentType = documentType;
    }

    @Override
    protected DOMNode.DOMNodeList createChildNodeList() {
        return new DOMNode.ChildNodeList();
    }

    protected abstract CSSDOMImplementation getStyleSheetFactory();

    @Override
    public HTMLDocument getOwnerDocument() {
        return null;
    }

    @Override
    public DocumentType getDoctype() {
        return this.documentType;
    }

    @Override
    public CSSDocument cloneNode(boolean deep) {
        CSSDocument doc = (CSSDocument)this.getImplementation().createDocument(HTML_NAMESPACE_URI, "html", this.getDoctype());
        if (deep) {
            doc.appendChild(doc.adoptNode(this.getDocumentElement()));
        }
        this.callUserHandlers((short)1, this, doc);
        return doc;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    Node cloneNode(HTMLDocument ownerDocument) {
        return ownerDocument.getImplementation().createDocument(HTML_NAMESPACE_URI, "html", this.getDoctype());
    }

    @Override
    public boolean isVisitedURI(String href) {
        return false;
    }

    @Override
    public HTMLElement getDocumentElement() {
        int sz = this.child.getLength();
        for (int i = 0; i < sz; ++i) {
            Node node = this.child.get(i);
            if (node.getNodeType() != 1) continue;
            return (HTMLElement)node;
        }
        return null;
    }

    @Override
    public CSSNode getParentNode() {
        return null;
    }

    @Override
    public HTMLElement createElement(String tagName) throws DOMException {
        if (tagName == null) {
            throw new DOMException(5, "null tag name");
        }
        return this.createElementNS(HTML_NAMESPACE_URI, tagName.toLowerCase(Locale.US));
    }

    @Override
    public HTMLElement createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        String localName;
        String prefix;
        if (qualifiedName == null) {
            throw new DOMException(5, "null qualified name");
        }
        if (namespaceURI != null && !namespaceURI.equals(HTML_NAMESPACE_URI)) {
            namespaceURI = namespaceURI.intern();
            int idx = qualifiedName.indexOf(58);
            if (idx == -1) {
                prefix = this.lookupNamespacePrefix(namespaceURI);
                localName = qualifiedName;
            } else {
                if (idx == qualifiedName.length() - 1) {
                    throw new DOMException(5, "Empty local name");
                }
                prefix = qualifiedName.substring(0, idx).intern();
                localName = qualifiedName.substring(idx);
            }
        } else {
            namespaceURI = HTML_NAMESPACE_URI;
            localName = qualifiedName;
            prefix = null;
        }
        localName = localName.intern();
        MyElement myelem = namespaceURI == HTML_NAMESPACE_URI ? ("link" == localName ? new LinkElement() : ("style" == localName ? new StyleElement() : ("meta" == localName ? new MetaElement() : ("base" == localName ? new BaseElement() : ("title" == localName ? new MetacontentElement(localName) : ("html" == localName ? new HtmlRootElement() : new MyElement(localName, namespaceURI))))))) : new MyElement(localName, namespaceURI);
        if (prefix != null) {
            myelem.setPrefix(prefix);
        }
        return myelem;
    }

    @Override
    public HTMLDocumentFragment createDocumentFragment() {
        return new HTMLDocumentFragment();
    }

    @Override
    public Text createTextNode(String data) {
        if (data == null) {
            throw new DOMException(5, "null data");
        }
        MyText text = new MyText();
        text.setData(data);
        return text;
    }

    @Override
    public Comment createComment(String data) {
        if (data == null) {
            throw new DOMException(5, "null data");
        }
        MyComment my = new MyComment();
        my.setData(data);
        return my;
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        if (data == null) {
            throw new DOMException(5, "null data");
        }
        MyCDATASection my = new MyCDATASection();
        my.setData(data);
        return my;
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        if (target == null) {
            throw new DOMException(5, "null target");
        }
        return new MyProcessingInstruction(target, data);
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        if (name == null) {
            throw new DOMException(5, "null entity reference name");
        }
        return new MyEntityReference(name);
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        if (name == null) {
            throw new DOMException(5, "null name");
        }
        return this.createAttributeNS(HTML_NAMESPACE_URI, name.toLowerCase(Locale.US));
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        String localName;
        String prefix;
        if (qualifiedName == null) {
            throw new DOMException(5, "null name");
        }
        if (namespaceURI != null && !namespaceURI.equals(HTML_NAMESPACE_URI)) {
            namespaceURI = namespaceURI.intern();
            int idx = qualifiedName.indexOf(58);
            if (idx == -1) {
                prefix = this.lookupNamespacePrefix(namespaceURI);
                localName = qualifiedName;
            } else {
                if (idx == qualifiedName.length() - 1) {
                    throw new DOMException(5, "Empty local name");
                }
                prefix = qualifiedName.substring(0, idx).intern();
                localName = qualifiedName.substring(idx);
            }
        } else {
            namespaceURI = HTML_NAMESPACE_URI;
            localName = qualifiedName;
            prefix = null;
        }
        localName = localName.intern();
        MyAttr my = namespaceURI == HTML_NAMESPACE_URI ? (localName == "class" ? new ClassAttr() : (localName == "href" ? new HrefEventAttr() : (localName == "media" ? new StyleEventAttr("media") : new MyAttr(localName, namespaceURI)))) : (localName == "xmlns" ? new XmlnsAttr() : new MyAttr(localName, namespaceURI));
        if (prefix != null) {
            my.setPrefix(prefix);
        }
        return my;
    }

    @Override
    public ElementList getElementsByTagName(String tagname) {
        return this.getDocumentElement().getElementsByTagName(tagname);
    }

    public ElementList getElementsByClassName(String names) {
        return this.getDocumentElement().getElementsByClassName(names);
    }

    @Override
    public ElementList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.getDocumentElement().getElementsByTagNameNS(namespaceURI, localName);
    }

    String lookupNamespacePrefix(String namespaceURI) {
        HTMLElement html = this.getDocumentElement();
        if (html == null) {
            return null;
        }
        return this.lookupPrefix(html, namespaceURI);
    }

    private String lookupPrefix(Node node, String namespaceURI) {
        if (node.getNamespaceURI() == namespaceURI) {
            String prefix = node.getPrefix();
            if (prefix != null) {
                return prefix;
            }
            return null;
        }
        NodeList list = node.getChildNodes();
        int sz = list.getLength();
        for (int i = 0; i < sz; ++i) {
            String prefix;
            Node cnode = list.item(i);
            if (cnode.getNodeType() != 1 || (prefix = this.lookupPrefix(cnode, namespaceURI)) == null) continue;
            return prefix;
        }
        return null;
    }

    @Override
    public HTMLElement getElementById(String elementId) {
        return this.findElementById(this.getChildNodes(), elementId);
    }

    private HTMLElement findElementById(NodeList nl, String elementId) {
        int sz = nl.getLength();
        for (int i = 0; i < sz; ++i) {
            HTMLElement elm;
            String idValue;
            Node node = nl.item(i);
            if (node.getNodeType() == 1 && (idValue = (elm = (HTMLElement)node).getAttribute(this.idAttrName)).equals(elementId)) {
                return elm;
            }
            elm = this.findElementById(node.getChildNodes(), elementId);
            if (elm == null) continue;
            return elm;
        }
        return null;
    }

    @Override
    public ElementList querySelectorAll(String selectors) {
        return HTMLElement.querySelectorAll(selectors, this.getChildNodes());
    }

    @Override
    public String getInputEncoding() {
        return this.inputEncoding;
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return this.xmlStandalone;
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        this.xmlStandalone = xmlStandalone;
    }

    @Override
    public String getXmlVersion() {
        return null;
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        throw new DOMException(9, "This is an HTML document.");
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.strictErrorChecking = strictErrorChecking;
    }

    @Override
    public String getDocumentURI() {
        return this.documentURI;
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this.documentURI = documentURI;
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        switch (importedNode.getNodeType()) {
            case 2: {
                Attr attr = this.createAttribute(importedNode.getNodeName());
                attr.setNodeValue(importedNode.getNodeValue());
                NodeList list = importedNode.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    attr.appendChild(this.importNode(list.item(i), true));
                }
                return attr;
            }
            case 1: {
                int i;
                HTMLElement elm = this.createElement(importedNode.getNodeName());
                NamedNodeMap attributes = ((Element)importedNode).getAttributes();
                int count = attributes.getLength();
                for (i = 0; i < count; ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    if (!attr.getSpecified()) continue;
                    elm.setAttributeNode(attr);
                }
                if (deep) {
                    NodeList list = importedNode.getChildNodes();
                    for (i = 0; i < list.getLength(); ++i) {
                        elm.appendChild(this.importNode(list.item(i), true));
                    }
                }
                return elm;
            }
            case 3: {
                return this.createTextNode(importedNode.getNodeValue());
            }
            case 4: {
                return this.createCDATASection(importedNode.getNodeValue());
            }
            case 8: {
                return this.createComment(importedNode.getNodeValue());
            }
            case 11: {
                HTMLDocumentFragment df = this.createDocumentFragment();
                if (deep) {
                    NodeList list = importedNode.getChildNodes();
                    for (int i = 0; i < list.getLength(); ++i) {
                        df.appendChild(this.importNode(list.item(i), true));
                    }
                }
            }
            case 5: {
                return this.createEntityReference(importedNode.getNodeName());
            }
            case 7: {
                return this.createProcessingInstruction(importedNode.getNodeName(), importedNode.getNodeValue());
            }
        }
        throw new DOMException(9, "Cannot import this node type.");
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        switch (source.getNodeType()) {
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                throw new DOMException(9, "Adopting this node is not supported.");
            }
        }
        if (source.getOwnerDocument() == this) {
            return this.appendChild(source);
        }
        return this.adoptNode((DOMNode)source, true);
    }

    private DOMNode adoptNode(DOMNode source, boolean callHandler) {
        DOMNode adopted = (DOMNode)source.cloneNode(this);
        NodeList list = source.getChildNodes();
        block3: for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            switch (node.getNodeType()) {
                case 6: 
                case 9: 
                case 10: 
                case 12: {
                    continue block3;
                }
                default: {
                    adopted.appendChild(this.adoptNode((DOMNode)node, false));
                }
            }
        }
        if (callHandler && !source.userDataHandler.isEmpty()) {
            for (Map.Entry<String, UserDataHandler> entry : source.userDataHandler.entrySet()) {
                String key = entry.getKey();
                UserDataHandler handler = entry.getValue();
                handler.handle((short)5, key, source.getUserData(key), source, adopted);
            }
        }
        return adopted;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild.getNodeType() != refChild.getNodeType()) {
            if (newChild.getNodeType() == 1) {
                int sz = this.child.getLength();
                for (int i = 0; i < sz; ++i) {
                    if (this.child.get(i).getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
            } else if (newChild.getNodeType() == 10) {
                int sz = this.child.getLength();
                for (int i = 0; i < sz; ++i) {
                    if (this.child.get(i).getNodeType() != 10) continue;
                    throw new DOMException(3, "Document already has a doctype.");
                }
                this.documentType = (DocumentType)newChild;
            }
        }
        return super.insertBefore(newChild, refChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (newChild.getNodeType() != oldChild.getNodeType()) {
            if (newChild.getNodeType() == 1) {
                int sz = this.child.getLength();
                for (int i = 0; i < sz; ++i) {
                    if (this.child.get(i).getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
            } else if (newChild.getNodeType() == 10) {
                int sz = this.child.getLength();
                for (int i = 0; i < sz; ++i) {
                    if (this.child.get(i).getNodeType() != 10) continue;
                    throw new DOMException(3, "Document already has a doctype.");
                }
                this.documentType = (DocumentType)newChild;
            }
        }
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() == 1) {
            int sz = this.child.getLength();
            for (int i = 0; i < sz; ++i) {
                if (this.child.get(i).getNodeType() != 1) continue;
                throw new DOMException(3, "Document already has a root element.");
            }
        } else if (newChild.getNodeType() == 10) {
            int sz = this.child.getLength();
            for (int i = 0; i < sz; ++i) {
                if (this.child.get(i).getNodeType() != 10) continue;
                throw new DOMException(3, "Document already has a doctype.");
            }
            this.documentType = (DocumentType)newChild;
        }
        return super.appendChild(newChild);
    }

    @Override
    protected boolean checkDocumentOwner(Node newChild) {
        return newChild.getNodeType() == 10 || newChild.getOwnerDocument() == this;
    }

    @Override
    public ElementList getChildren() {
        return this.getDocumentElement().getChildren();
    }

    @Override
    public HTMLElement getFirstElementChild() {
        return this.getDocumentElement().getFirstElementChild();
    }

    @Override
    public HTMLElement getLastElementChild() {
        return this.getDocumentElement().getLastElementChild();
    }

    @Override
    public int getChildElementCount() {
        return this.getDocumentElement().getChildElementCount();
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.domConfig;
    }

    @Override
    public void normalizeDocument() {
        this.getDocumentElement().normalize();
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "This operation is not supported.");
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return this.getDocumentElement().lookupNamespaceURI(prefix);
    }

    @Override
    public StyleSheetList getStyleSheets() {
        if (this.sheets.needsUpdate()) {
            this.updateStyleLists();
        }
        return this.sheets;
    }

    protected void updateStyleLists() {
        int i;
        this.linkedStyle.clear();
        ElementList nl = this.getElementsByTagName("link");
        int len = nl.getLength();
        for (i = 0; i < len; ++i) {
            LinkElement link = (LinkElement)nl.item(i);
            if (link.getSheet() == null) continue;
            this.linkedStyle.add(link);
        }
        this.embeddedStyle.clear();
        nl = this.getElementsByTagName("style");
        len = nl.getLength();
        for (i = 0; i < len; ++i) {
            this.embeddedStyle.add((StyleElement)nl.item(i));
        }
        Iterator<LinkElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            this.addLinkedSheet(links.next().getSheet());
        }
        Iterator<StyleElement> embd = this.embeddedStyle.iterator();
        while (embd.hasNext()) {
            this.addLinkedSheet(embd.next().getSheet());
        }
        this.sheets.setNeedsUpdate(false);
        if (this.lastStyleSheetSet != null) {
            this.setSelectedStyleSheetSet(this.lastStyleSheetSet);
        } else if (this.metaDefaultStyleSet.length() > 0) {
            this.setSelectedStyleSheetSet(this.metaDefaultStyleSet);
        } else {
            this.setSelectedStyleSheetSet(this.sheets.getPreferredStyleSheetSet());
        }
        if (this.getCanvas() != null) {
            this.getCanvas().reloadStyleState();
        }
    }

    private void addLinkedSheet(StyleSheet linkedSheet) {
        if (linkedSheet != null) {
            this.sheets.add(linkedSheet);
        }
    }

    @Override
    public DocumentCSSStyleSheet getStyleSheet() {
        if (this.mergedStyleSheet == null) {
            this.mergeStyleSheets();
        }
        return this.mergedStyleSheet;
    }

    private void mergeStyleSheets() {
        this.mergedStyleSheet = this.targetMedium == null ? this.getStyleSheetFactory().getDefaultStyleSheet().clone() : this.getStyleSheetFactory().getDefaultStyleSheet().clone(this.targetMedium);
        this.mergedStyleSheet.setOwnerDocument(this);
        this.getStyleSheets();
        Iterator<StyleSheet> it = this.sheets.iterator();
        while (it.hasNext()) {
            this.getStyleSheet().addStyleSheet((AbstractCSSStyleSheet)it.next());
        }
    }

    @Override
    public DOMStringList getStyleSheetSets() {
        if (this.sheets.needsUpdate()) {
            this.updateStyleLists();
        }
        return this.sheets.getStyleSheetSets();
    }

    @Override
    public String getSelectedStyleSheetSet() {
        String selectedSetName = "";
        Iterator<LinkElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || sheet.getDisabled()) continue;
            if (selectedSetName.length() > 0) {
                if (selectedSetName.equals(title)) continue;
                return null;
            }
            selectedSetName = title;
        }
        return selectedSetName;
    }

    @Override
    public void setSelectedStyleSheetSet(String name) {
        if (name == null || name.length() > 0 && !this.getStyleSheetSets().contains(name)) {
            return;
        }
        Iterator<LinkElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0) continue;
            if (title.equals(name)) {
                sheet.setDisabled(false);
                this.lastStyleSheetSet = name;
                continue;
            }
            sheet.setDisabled(true);
        }
    }

    @Override
    public String getLastStyleSheetSet() {
        return this.lastStyleSheetSet;
    }

    @Override
    public void enableStyleSheetsForSet(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        Iterator<LinkElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || !title.equals(name)) continue;
            sheet.setDisabled(false);
        }
    }

    void onEmbeddedStyleAdd(LinkStyle element) {
        if (element instanceof LinkElement) {
            this.linkedStyle.add((LinkElement)element);
        } else if (element instanceof StyleElement) {
            this.embeddedStyle.add((StyleElement)element);
        }
        this.onStyleModify();
    }

    void onEmbeddedStyleRemove(LinkStyle element) {
        String title;
        if (element instanceof LinkElement) {
            this.linkedStyle.remove(element);
        } else if (element instanceof StyleElement) {
            this.embeddedStyle.remove(element);
        }
        StyleSheet sheet = element.getSheet();
        if (sheet != null && (title = sheet.getTitle()) != null) {
            this.sheets.remove(title);
        }
        this.onStyleModify();
    }

    void onStyleModify() {
        if (this.mergedStyleSheet != null) {
            this.mergedStyleSheet = null;
            this.sheets.setNeedsUpdate(true);
        } else if (this.sheets != null) {
            this.sheets.setNeedsUpdate(true);
        }
    }

    @Override
    public CSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt) {
        if (elt instanceof MyElement) {
            return ((MyElement)elt).getOverrideStyle(pseudoElt);
        }
        return null;
    }

    @Override
    public StyleDatabase getStyleDatabase() {
        StyleDatabase sdb = null;
        if (this.targetMedium != null) {
            sdb = this.getStyleSheetFactory().getDeviceFactory().getStyleDatabase(this.targetMedium);
        }
        return sdb;
    }

    @Override
    public String getTargetMedium() {
        return this.targetMedium;
    }

    @Override
    public void setTargetMedium(String medium) throws CSSMediaException {
        this.targetMedium = "all".equals(medium = medium.intern()) ? null : medium;
        this.onStyleModify();
    }

    @Override
    public CSSCanvas getCanvas() {
        if (this.targetMedium == null) {
            return null;
        }
        if (this.canvases.containsKey(this.targetMedium)) {
            return this.canvases.get(this.targetMedium);
        }
        CSSCanvas canvas = this.getStyleSheetFactory().getDeviceFactory().createCanvas(this.targetMedium, this);
        this.canvases.put(this.targetMedium, canvas);
        return canvas;
    }

    @Override
    public boolean hasStyleIssues() {
        return this.sheets.hasErrorsOrWarnings();
    }

    @Override
    public void onFontFaceRule(CSSFontFaceRule rule) {
        for (CSSCanvas canvas : this.canvases.values()) {
            if (canvas == null) continue;
            canvas.loadFontFace(rule);
        }
    }

    @Override
    public void onPageRule(CSSPageRule rule) {
    }

    public void onMetaAdded(String name, String attribute) {
        if ("Default-Style".equals(name)) {
            this.metaDefaultStyleSet = attribute;
        }
    }

    public void onMetaRemoved(String name, String attribute) {
        if ("Default-Style".equals(name)) {
            this.metaDefaultStyleSet = "";
        }
    }

    @Override
    public URL getBaseURL() {
        if (this.baseURL == null) {
            Element elm;
            String s;
            String buri = this.getDocumentURI();
            ElementList nl = this.getElementsByTagName("base");
            if (nl.getLength() > 0 && (s = (elm = (Element)nl.item(0)).getAttribute("href")).length() > 0) {
                if (buri != null && s.startsWith("//")) {
                    try {
                        URL url = new URL(buri);
                        url = new URL(url, s);
                        buri = url.toExternalForm();
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else {
                    buri = s;
                }
            }
            try {
                this.baseURL = new URL(buri);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.baseURL;
    }

    @Override
    public String getBaseURI() {
        URL url = this.getBaseURL();
        if (url != null) {
            return url.toExternalForm();
        }
        return null;
    }

    @Override
    public URL getURL(String uri) throws MalformedURLException {
        if (uri.length() == 0) {
            throw new MalformedURLException("Empty URI");
        }
        URL url = uri.indexOf("://") < 0 ? new URL(this.getBaseURL(), uri) : new URL(uri);
        return url;
    }

    public String toString() {
        return this.getChildNodes().toString();
    }

    @Override
    public boolean isSafeOrigin(URL linkedURL) {
        URL base = this.getBaseURL();
        String docHost = base.getHost();
        int docPort = base.getPort();
        if (docPort == -1) {
            docPort = base.getDefaultPort();
        }
        String linkedHost = linkedURL.getHost();
        int linkedPort = linkedURL.getPort();
        if (linkedPort == -1) {
            linkedPort = linkedURL.getDefaultPort();
        }
        return (docHost.equalsIgnoreCase(linkedHost) || linkedHost.endsWith(docHost)) && docPort == linkedPort;
    }

    public InputStream openStream(String uri) throws IOException {
        return this.openConnection(this.getURL(uri)).getInputStream();
    }

    private static InputStream openResourceStream(final String fileName) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return OriginPolicy.class.getResourceAsStream(fileName);
            }
        });
    }

    class MyOMStyleSheetList
    extends OMStyleSheetList {
        protected MyOMStyleSheetList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected boolean hasErrorsOrWarnings() {
            boolean hasRuleErrors = false;
            Iterator<StyleSheet> it = this.iterator();
            while (it.hasNext()) {
                AbstractCSSStyleSheet sheet = (AbstractCSSStyleSheet)it.next();
                SheetErrorHandler eh = sheet.getErrorHandler();
                if (!sheet.hasRuleErrorsOrWarnings() && !eh.hasSacErrors() && !eh.hasSacWarnings()) continue;
                hasRuleErrors = true;
                break;
            }
            return hasRuleErrors;
        }

        @Override
        protected Iterator<StyleSheet> iterator() {
            return super.iterator();
        }

        @Override
        protected void clear() {
            super.clear();
        }

        @Override
        protected boolean needsUpdate() {
            return super.needsUpdate();
        }

        @Override
        protected void setNeedsUpdate(boolean needsUpdate) {
            super.setNeedsUpdate(needsUpdate);
        }

        @Override
        protected void update() {
            super.update();
            HTMLDocument.this.updateStyleLists();
        }
    }

    class MyDOMConfiguration
    implements DOMConfiguration {
        Properties parameters = new Properties();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MyDOMConfiguration() {
            BufferedReader re = null;
            try {
                re = new BufferedReader(new InputStreamReader(HTMLDocument.openResourceStream("/io/sf/carte/doc/html/domconfig.properties"), "utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            try {
                this.parameters.load(re);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    re.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public boolean canSetParameter(String name, Object value) {
            return name.equals("error-handler") && value instanceof DOMErrorHandler;
        }

        @Override
        public Object getParameter(String name) throws DOMException {
            return this.parameters.getProperty(name);
        }

        @Override
        public DOMStringList getParameterNames() {
            String[] names = this.parameters.keySet().toArray(new String[0]);
            return new DOMStringListImpl(names);
        }

        @Override
        public void setParameter(String name, Object value) throws DOMException {
            if (name.equals("error-handler") && value instanceof DOMErrorHandler) {
                HTMLDocument.this.errorHandler = (DOMErrorHandler)value;
            } else if (this.canSetParameter(name, value)) {
                this.parameters.setProperty(name, value.toString());
            }
        }
    }

    class MetaElement
    extends MyElement {
        MetaElement() {
            super("meta");
        }

        @Override
        protected DOMNode.DOMNodeList createChildNodeList() {
            return nvemptyNodeList;
        }

        @Override
        void setParentNode(CSSNode parentNode) throws DOMException {
            if (parentNode == null) {
                String name = this.getAttribute("http-equiv");
                if (name.length() == 0) {
                    name = this.getAttribute("name");
                }
                this.getOwnerDocument().onMetaRemoved(name, this.getAttribute("content"));
                super.setParentNode(null);
            } else {
                short type = parentNode.getNodeType();
                if (type != 11 && (type != 1 || parentNode.getNodeName() != "head" && parentNode.getNodeName() != "noscript" && this.hasAttributes() && (this.hasAttribute("charset") || this.hasAttribute("http-equiv")))) {
                    String msg = "A <meta> tag can occur only in the head or noscript element, not in " + parentNode.getNodeName();
                    throw new DOMException(3, msg);
                }
                super.setParentNode(parentNode);
                String name = this.getAttribute("http-equiv");
                if (name.length() == 0) {
                    name = this.getAttribute("name");
                }
                this.getOwnerDocument().onMetaAdded(name, this.getAttribute("content"));
            }
        }
    }

    class StyleElement
    extends MyElement
    implements StyleDefinerElement {
        private AbstractCSSStyleSheet containedSheet;

        StyleElement() {
            super("style");
            this.containedSheet = null;
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.containedSheet == null) {
                MediaQueryList mediaList;
                String type = this.getAttribute("type");
                if (!"text/css".equals(type)) {
                    return null;
                }
                String media = this.getAttribute("media");
                if ((media = media.trim()).length() == 0) {
                    mediaList = OMMediaList.createMediaList();
                } else {
                    mediaList = MediaQueryFactory.createMediaList(media);
                    if (mediaList.isNotAllMedia() && mediaList.hasErrors()) {
                        this.getStyleSheetFactory().getErrorHandler().mediaQueryError(media);
                    }
                }
                AbstractCSSStyleSheet sheet = this.getStyleSheetFactory().createLinkedStyleSheet(this, this.getAttribute("title"), mediaList);
                String styleText = this.getTextContent().trim();
                if (styleText.length() > 0) {
                    sheet.setHref(this.getBaseURI());
                    InputSource source = new InputSource();
                    StringReader re = new StringReader(styleText);
                    source.setCharacterStream((Reader)re);
                    try {
                        sheet.parseCSSStyleSheet(source);
                    }
                    catch (Exception e) {
                        this.getStyleSheetFactory().getErrorHandler().onException(e, sheet);
                    }
                }
                this.containedSheet = sheet;
            }
            return this.containedSheet;
        }

        @Override
        public void resetLinkedSheet() {
            this.containedSheet = null;
            this.getOwnerDocument().onStyleModify();
        }

        @Override
        void setParentNode(CSSNode parentNode) throws DOMException {
            super.setParentNode(parentNode);
            HTMLDocument.this.onStyleModify();
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            Node retChild = super.appendChild(newChild);
            this.resetLinkedSheet();
            return retChild;
        }

        @Override
        public Node insertBefore(Node newChild, Node refChild) throws DOMException {
            Node retChild = super.insertBefore(newChild, refChild);
            this.resetLinkedSheet();
            return retChild;
        }

        @Override
        public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
            Node retChild = super.replaceChild(newChild, oldChild);
            this.resetLinkedSheet();
            return retChild;
        }

        @Override
        public Node removeChild(Node oldChild) throws DOMException {
            Node retChild = super.removeChild(oldChild);
            this.resetLinkedSheet();
            return retChild;
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            super.setTextContent(textContent);
            this.resetLinkedSheet();
        }

        @Override
        public HTMLElement cloneNode(boolean deep) {
            return this.cloneElementNode(new StyleElement(), deep);
        }
    }

    class LinkElement
    extends MyElement
    implements StyleDefinerElement {
        private AbstractCSSStyleSheet linkedSheet;

        LinkElement() {
            super("link");
            this.linkedSheet = null;
        }

        @Override
        protected DOMNode.DOMNodeList createChildNodeList() {
            return nvemptyNodeList;
        }

        @Override
        void setParentNode(CSSNode parentNode) throws DOMException {
            short type;
            if (parentNode != null && (type = parentNode.getNodeType()) != 11 && (type != 1 || parentNode.getNodeName() != "head" && parentNode.getNodeName() != "noscript" && this.hasAttributes() && this.failAttributeCheck())) {
                String msg = "A <link> tag without the allowed attributes can occur only in the head or noscript element, not in " + parentNode.getNodeName();
                throw new DOMException(3, msg);
            }
            super.setParentNode(parentNode);
            HTMLDocument.this.onStyleModify();
        }

        private boolean failAttributeCheck() {
            NamedNodeMap attributes = this.getAttributes();
            int sz = attributes.getLength();
            for (int i = 0; i < sz; ++i) {
                String value;
                Attr attr = (Attr)attributes.item(i);
                String name = attr.getName();
                if ("itemprop".equals(name)) {
                    return false;
                }
                if (!"rel".equals(name) || (value = attr.getValue()) == null || !value.equals("stylesheet") && !value.equals("pingback") && !value.equals("preconnect") && !value.equals("preload") && !value.equals("prerender") && !value.endsWith("prefetch")) continue;
                return false;
            }
            return true;
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.linkedSheet == null) {
                String type = this.getAttribute("type");
                if (type.length() != 0 && !"text/css".equals(type)) {
                    return null;
                }
                String rel = this.getAttribute("rel");
                if (rel.length() > 0) {
                    String href;
                    String lcrel;
                    String title = this.getAttribute("title");
                    if (title.length() == 0) {
                        title = null;
                    }
                    if ((lcrel = rel.toLowerCase(Locale.US)).equals("stylesheet")) {
                        String href2 = this.getAttribute("href");
                        if (href2.length() > 0) {
                            this.loadStyleSheet(href2, title);
                        }
                    } else if (lcrel.equals("alternate stylesheet") && title != null && (href = this.getAttribute("href")).length() > 0) {
                        this.loadStyleSheet(href, title);
                        if (this.linkedSheet != null) {
                            this.linkedSheet.setDisabled(true);
                        }
                    }
                }
            }
            return this.linkedSheet;
        }

        private void loadStyleSheet(String href, String title) {
            MediaQueryList mediaList;
            String media = this.getAttribute("media");
            if ((media = media.trim()).length() == 0) {
                mediaList = OMMediaList.createMediaList();
            } else {
                mediaList = MediaQueryFactory.createMediaList(media);
                if (mediaList.isNotAllMedia() && mediaList.hasErrors()) {
                    this.getStyleSheetFactory().getErrorHandler().mediaQueryError(media);
                }
            }
            BaseCSSStyleSheet sheet = (BaseCSSStyleSheet)this.getStyleSheetFactory().createLinkedStyleSheet(this, title, mediaList);
            try {
                URL url = this.getOwnerDocument().getURL(href);
                sheet.setHref(url.toExternalForm());
                sheet.loadStyleSheet(url);
            }
            catch (Exception e) {
                this.getStyleSheetFactory().getErrorHandler().onException(e, sheet);
            }
            this.linkedSheet = sheet;
        }

        @Override
        public void resetLinkedSheet() {
            this.linkedSheet = null;
            this.getOwnerDocument().onStyleModify();
        }

        @Override
        public HTMLElement cloneNode(boolean deep) {
            return this.cloneElementNode(new LinkElement(), deep);
        }
    }

    static interface StyleDefinerElement
    extends LinkStyle {
        @Override
        public AbstractCSSStyleSheet getSheet();

        public void resetLinkedSheet();
    }

    class BaseElement
    extends MetacontentElement {
        BaseElement() {
            super("base");
        }

        @Override
        protected DOMNode.DOMNodeList createChildNodeList() {
            return nvemptyNodeList;
        }

        @Override
        void setParentNode(CSSNode parentNode) throws DOMException {
            if (parentNode != null) {
                super.setParentNode(parentNode);
                if (parentNode.getNodeType() == 1) {
                    NodeList nl = parentNode.getChildNodes();
                    int sz = nl.getLength();
                    for (int i = 0; i < sz; ++i) {
                        Node node = nl.item(i);
                        if (node.getNodeType() != 1 || node.getNodeName() != "base" || node == this) continue;
                        throw new DOMException(3, "A document can have only one base element.");
                    }
                }
            }
            super.setParentNode(parentNode);
        }
    }

    class MetacontentElement
    extends MyElement {
        MetacontentElement(String tagName) {
            super(tagName);
        }

        @Override
        void setParentNode(CSSNode parentNode) throws DOMException {
            short type;
            if (parentNode != null && (type = parentNode.getNodeType()) != 11 && (type != 1 || parentNode.getNodeName() != "head" && parentNode.getNodeName() != "noscript")) {
                String msg = "A <" + this.getNodeName() + "> tag can occur only in a head or noscript element, not in " + parentNode.toString();
                throw new DOMException(3, msg);
            }
            super.setParentNode(parentNode);
        }
    }

    class HtmlRootElement
    extends MyElement {
        HtmlRootElement() {
            super("html");
        }

        @Override
        void setParentNode(CSSNode parentNode) throws DOMException {
            short type;
            if (parentNode != null && (type = parentNode.getNodeType()) != 9 && type != 11) {
                throw new DOMException(3, "A <html> tag cannot be added here.");
            }
            super.setParentNode(parentNode);
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            String nname;
            if (newChild.getNodeType() == 1 && ((nname = newChild.getNodeName()) == "head" || nname == "body")) {
                int sz = this.child.getLength();
                for (int i = 0; i < sz; ++i) {
                    Node node = this.child.get(i);
                    if (node.getNodeType() != 1 || node.getNodeName() != nname) continue;
                    throw new DOMException(3, "<html> already has a " + nname + " child.");
                }
            }
            return super.appendChild(newChild);
        }
    }

    class MyElement
    extends HTMLElement {
        MyElement(String localName) {
            this(localName, HTMLDocument.HTML_NAMESPACE_URI);
        }

        MyElement(String localName, String namespaceURI) {
            super(localName, namespaceURI);
        }

        @Override
        public void setIdAttribute(String name, boolean isId) throws DOMException {
            if (!isId || !"id".equalsIgnoreCase(name)) {
                throw new DOMException(7, "Id attribute is always 'id'");
            }
            HTMLDocument.this.idAttrName = name;
        }

        @Override
        public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
            if (namespaceURI != null && namespaceURI.length() > 0 && !namespaceURI.equals(HTMLDocument.HTML_NAMESPACE_URI)) {
                return;
            }
            if (!isId || !"id".equalsIgnoreCase(localName)) {
                throw new DOMException(7, "Id attribute is always 'id'");
            }
            HTMLDocument.this.idAttrName = localName;
        }

        @Override
        public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
            if (!isId || idAttr == null || !"id".equalsIgnoreCase(idAttr.getName())) {
                throw new DOMException(7, "Id attribute is always 'id'");
            }
            HTMLDocument.this.idAttrName = idAttr.getName();
        }

        @Override
        public String getId() {
            return this.getAttribute(HTMLDocument.this.idAttrName);
        }

        @Override
        public HTMLDocument getOwnerDocument() {
            return HTMLDocument.this;
        }

        @Override
        protected BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return HTMLDocument.this.getStyleSheetFactory();
        }

        @Override
        public String getBaseURI() {
            return HTMLDocument.this.getBaseURI();
        }

        @Override
        public HTMLElement cloneNode(boolean deep) {
            return this.cloneElementNode(new MyElement(this.getLocalName(), this.getNamespaceURI()), deep);
        }

        HTMLElement cloneElementNode(MyElement my, boolean deep) {
            for (Attr attr : this.nodeMap.attributes.values()) {
                MyAttr myattr = new MyAttr(attr.getName(), attr.getNamespaceURI());
                myattr.setValue(attr.getValue());
                myattr.specified = false;
                my.setAttributeNode(myattr);
            }
            if (deep && this.hasChildNodes()) {
                NodeList list = this.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    my.appendChild(list.item(i).cloneNode(true));
                }
            }
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        CSSElement cloneNode(HTMLDocument ownerDocument) {
            HTMLElement my = ownerDocument.createElementNS(this.getLocalName(), this.getNamespaceURI());
            for (MyAttr attr : this.nodeMap.attributes.values()) {
                if (!attr.getSpecified()) continue;
                attr = (MyAttr)attr.cloneNode(ownerDocument);
                my.setAttributeNode(attr);
            }
            return my;
        }
    }

    class ClassAttr
    extends MyAttr {
        ClassAttr() {
            super("class");
        }

        @Override
        void setParentNode(CSSNode parentNode) throws DOMException {
            CSSNode parent;
            HTMLElement owner;
            if (parentNode == null && (owner = this.getOwnerElement()) != null) {
                parent = owner.getParentNode();
                if (parent != null && parent.getNodeType() == 1) {
                    ((HTMLElement)parent).updateClasslistsOnRemove(owner);
                }
                if (owner.classList != null) {
                    this.value = owner.classList.getValue();
                    owner.classList.clear();
                }
            }
            super.setParentNode(parentNode);
            if (parentNode != null) {
                owner = (HTMLElement)parentNode;
                if (owner.classList != null) {
                    owner.classList.setValue(this.value);
                }
                if ((parent = owner.getParentNode()) != null && parent.getNodeType() == 1) {
                    ((HTMLElement)parent).updateClasslists(owner);
                }
            }
        }

        @Override
        public String getValue() {
            HTMLElement.ClassList list = this.getListValue();
            if (list == null) {
                return super.getValue();
            }
            return list.getValue();
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            HTMLElement.ClassList list = this.getListValue();
            if (list != null) {
                list.setValue(value);
            }
        }

        HTMLElement.ClassList getListValue() {
            HTMLElement owner = this.getOwnerElement();
            if (owner == null) {
                return null;
            }
            return (HTMLElement.ClassList)owner.getClassList();
        }
    }

    class HrefEventAttr
    extends MyAttr {
        HrefEventAttr() {
            super("href");
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            HTMLElement parent = this.getOwnerElement();
            if (parent != null) {
                String tagname = parent.getTagName();
                if (tagname == "link") {
                    ((LinkElement)parent).resetLinkedSheet();
                } else if (tagname == "base") {
                    HTMLDocument doc = this.getOwnerDocument();
                    if (value != null) {
                        URL base;
                        try {
                            base = new URL(value);
                        }
                        catch (MalformedURLException e) {
                            if (doc != null) {
                                doc.baseURL = null;
                            }
                            return;
                        }
                        if (doc != null) {
                            doc.baseURL = base;
                        }
                    } else if (doc != null) {
                        doc.baseURL = null;
                    }
                }
            }
        }
    }

    class StyleEventAttr
    extends MyAttr {
        StyleEventAttr(String name) {
            super(name);
        }

        @Override
        void setParentNode(CSSNode parentNode) {
            super.setParentNode(parentNode);
            if (parentNode != null && parentNode instanceof StyleDefinerElement) {
                ((StyleDefinerElement)((Object)parentNode)).resetLinkedSheet();
            }
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            HTMLElement parent = this.getOwnerElement();
            if (parent != null && parent instanceof StyleDefinerElement) {
                ((StyleDefinerElement)((Object)parent)).resetLinkedSheet();
            }
        }
    }

    class XmlnsAttr
    extends MyAttr {
        XmlnsAttr() {
            super("xmlns", null);
        }

        @Override
        public void setPrefix(String prefix) throws DOMException {
            throw new DOMException(14, "Cannot set prefix for xmlns attribute");
        }
    }

    class MyAttr
    extends MyNode
    implements Attr {
        boolean specified;
        String name;
        String value;

        MyAttr(String name) {
            this(name, HTMLDocument.HTML_NAMESPACE_URI);
        }

        MyAttr(String name, String namespaceURI) {
            super((short)2, namespaceURI);
            this.specified = true;
            this.value = null;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getLocalName() {
            return this.getName();
        }

        @Override
        public boolean getSpecified() {
            return this.specified;
        }

        @Override
        public void setPrefix(String prefix) throws DOMException {
            if ("xmlns".equals(this.getName()) || "xmlns".equals(prefix) && !"http://www.w3.org/2000/xmlns/".equals(this.getNamespaceURI())) {
                throw new DOMException(14, "Cannot set prefix to this node");
            }
            super.setPrefix(prefix);
        }

        @Override
        public HTMLElement getOwnerElement() {
            return (HTMLElement)super.getParentNode();
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            return null;
        }

        @Override
        public boolean isId() {
            return HTMLDocument.this.idAttrName.equals(this.name);
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) throws DOMException {
            this.value = value;
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.getValue();
        }

        @Override
        void setParentNode(CSSNode parentNode) throws DOMException {
            if (parentNode != null && parentNode.getNodeType() != 1) {
                throw new DOMException(3, "Attributes can only pertain to elements");
            }
            super.setParentNode(parentNode);
        }

        @Override
        public CSSNode getParentNode() throws DOMException {
            return null;
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            throw new DOMException(3, "Cannot append to attribute node");
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            HTMLElement parent = this.getOwnerElement();
            if (parent != null) {
                return parent.lookupNamespaceURI(prefix);
            }
            return null;
        }

        @Override
        public Attr cloneNode(boolean deep) {
            MyAttr my = (MyAttr)this.getOwnerDocument().createAttributeNS(this.getName(), this.getNamespaceURI());
            my.setValue(this.getValue());
            my.specified = true;
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        Attr cloneNode(HTMLDocument ownerDocument) {
            MyAttr attr = (MyAttr)ownerDocument.createAttributeNS(this.name, this.getNamespaceURI());
            attr.setValue(this.getValue());
            attr.specified = false;
            return attr;
        }

        public String toString() {
            return this.name + "=\"" + this.getValue() + '\"';
        }
    }

    class MyCDATASection
    extends MyText
    implements CDATASection {
        MyCDATASection() {
            super((short)4);
        }

        @Override
        public String getNodeName() {
            return "#cdata-section";
        }

        @Override
        public CDATASection cloneNode(boolean deep) {
            MyCDATASection my = new MyCDATASection();
            my.setData(this.getData());
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        Node cloneNode(HTMLDocument ownerDocument) {
            return ownerDocument.createCDATASection(this.getData());
        }

        @Override
        public String toString() {
            return "<![CDATA[\n" + this.getData() + "\n]]>";
        }
    }

    class MyText
    extends MyCharacterData
    implements Text {
        boolean elementContentWhitespace;

        MyText() {
            super((short)3);
            this.elementContentWhitespace = false;
        }

        MyText(short nodeType) {
            super(nodeType);
            this.elementContentWhitespace = false;
        }

        @Override
        public void setData(String data) throws DOMException {
            super.setData(data);
            CSSNode parent = this.getParentNode();
            if (parent != null && parent.getNodeName() == "style") {
                ((StyleDefinerElement)((Object)parent)).resetLinkedSheet();
            }
        }

        @Override
        public Text splitText(int offset) throws DOMException {
            Text newnode;
            CSSNode parent = this.getParentNode();
            try {
                String newdata = this.data.substring(0, offset);
                if (parent != null) {
                    newnode = this.getOwnerDocument().createTextNode(this.data.substring(offset, this.data.length()));
                    parent.insertBefore(newnode, this.getNextSibling());
                } else {
                    newnode = this;
                }
                this.setData(newdata);
            }
            catch (IndexOutOfBoundsException e) {
                throw new DOMException(1, e.getMessage());
            }
            return newnode;
        }

        @Override
        public boolean isElementContentWhitespace() {
            if (this.data != null) {
                int dl = this.data.length();
                for (int i = 0; i < dl; ++i) {
                    if (Character.isWhitespace(this.data.charAt(i))) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public String getWholeText() {
            short type;
            short type2;
            Node node;
            Node firstnode = this;
            for (node = this.getPreviousSibling(); node != null && ((type2 = node.getNodeType()) == 3 || type2 == 5); node = node.getPreviousSibling()) {
                firstnode = node;
            }
            Node lastnode = this;
            for (node = this.getNextSibling(); node != null && ((type = node.getNodeType()) == 3 || type == 5); node = node.getNextSibling()) {
                lastnode = node;
            }
            if (firstnode == lastnode) {
                return this.getData();
            }
            StringBuilder buf = new StringBuilder(this.data.length() * 2);
            for (node = firstnode; node != lastnode; node = node.getNextSibling()) {
                buf.append(node.toString());
            }
            buf.append(lastnode.toString());
            return buf.toString();
        }

        @Override
        public Text replaceWholeText(String content) throws DOMException {
            if (content == null) {
                throw new DOMException(5, "null content (use empty string instead)");
            }
            CSSNode parent = this.getParentNode();
            if (parent != null) {
                Node sibling;
                short type;
                Node node = this.getPreviousSibling();
                while (node != null && ((type = node.getNodeType()) == 5 || type == 3)) {
                    sibling = node.getPreviousSibling();
                    parent.removeChild(node);
                    node = sibling;
                }
                node = this.getNextSibling();
                while (node != null && ((type = node.getNodeType()) == 5 || type == 3)) {
                    sibling = node.getNextSibling();
                    parent.removeChild(node);
                    node = sibling;
                }
            }
            this.setData(content);
            if (content.length() == 0) {
                if (parent != null) {
                    parent.removeChild(this);
                }
                return null;
            }
            return this;
        }

        @Override
        public String getNodeName() {
            return "#text";
        }

        @Override
        public Text cloneNode(boolean deep) {
            MyText my = new MyText();
            my.setData(this.getData());
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        Node cloneNode(HTMLDocument ownerDocument) {
            return ownerDocument.createTextNode(this.getData());
        }

        public String toString() {
            return this.getData();
        }
    }

    class MyComment
    extends MyCharacterData
    implements Comment {
        MyComment() {
            super((short)8);
        }

        @Override
        public String getNodeName() {
            return "#comment";
        }

        @Override
        public Comment cloneNode(boolean deep) {
            MyComment my = new MyComment();
            my.setData(this.getData());
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        Node cloneNode(HTMLDocument ownerDocument) {
            return ownerDocument.createComment(this.getData());
        }

        public String toString() {
            return "<!-- " + this.getData() + " -->";
        }
    }

    abstract class MyCharacterData
    extends MyNode
    implements CharacterData {
        String data;

        MyCharacterData(short nodeType) {
            super(nodeType);
            this.data = null;
        }

        @Override
        public String getData() throws DOMException {
            return this.data;
        }

        @Override
        public void setData(String data) throws DOMException {
            this.data = data;
        }

        @Override
        public int getLength() {
            return this.data.length();
        }

        @Override
        public String substringData(int offset, int count) throws DOMException {
            try {
                return this.data.substring(offset, offset + count);
            }
            catch (IndexOutOfBoundsException e) {
                throw new DOMException(1, e.getMessage());
            }
        }

        @Override
        public void appendData(String arg) throws DOMException {
            StringBuilder buf = new StringBuilder(this.data.length() + arg.length());
            buf.append(this.data).append(arg);
            this.setData(buf.toString());
        }

        @Override
        public void insertData(int offset, String arg) throws DOMException {
            int dl = this.data.length();
            StringBuilder buf = new StringBuilder(dl + arg.length());
            try {
                buf.append(this.data.subSequence(0, offset)).append(arg).append(this.data.subSequence(offset, dl));
            }
            catch (IndexOutOfBoundsException e) {
                throw new DOMException(1, e.getMessage());
            }
            this.setData(buf.toString());
        }

        @Override
        public void deleteData(int offset, int count) throws DOMException {
            int dl = this.data.length();
            StringBuilder buf = new StringBuilder(dl - count);
            try {
                buf.append(this.data.subSequence(0, offset)).append(this.data.subSequence(offset + count, dl));
            }
            catch (IndexOutOfBoundsException e) {
                throw new DOMException(1, e.getMessage());
            }
            this.setData(buf.toString());
        }

        @Override
        public void replaceData(int offset, int count, String arg) throws DOMException {
            int dl = this.data.length();
            StringBuilder buf = new StringBuilder(dl + arg.length() - count);
            try {
                buf.append(this.data.subSequence(0, offset)).append(arg).append(this.data.subSequence(offset + count, dl));
            }
            catch (IndexOutOfBoundsException e) {
                throw new DOMException(1, e.getMessage());
            }
            this.setData(buf.toString());
        }

        @Override
        public String getNodeValue() {
            return this.getData();
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            throw new DOMException(3, "Cannot append the node to text/comment/cdatasection");
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            CSSNode parent = this.getParentNode();
            if (parent != null) {
                return parent.lookupNamespaceURI(prefix);
            }
            return null;
        }
    }

    class MyProcessingInstruction
    extends MyNode
    implements ProcessingInstruction {
        String data;
        String target;

        MyProcessingInstruction(String target, String data) {
            super((short)7);
            this.target = target;
            this.data = data;
        }

        @Override
        public String getNodeName() {
            return this.getTarget();
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public String getTarget() {
            return this.target;
        }

        @Override
        public void setData(String data) throws DOMException {
            this.data = data;
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.getData();
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            CSSNode parent = this.getParentNode();
            if (parent != null) {
                return parent.lookupNamespaceURI(prefix);
            }
            return null;
        }

        @Override
        public ProcessingInstruction cloneNode(boolean deep) {
            MyProcessingInstruction my = new MyProcessingInstruction(this.getTarget(), this.getData());
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        Node cloneNode(HTMLDocument ownerDocument) {
            return ownerDocument.createProcessingInstruction(this.getTarget(), this.getData());
        }

        public String toString() {
            return "<?" + this.getTarget() + " " + this.getData() + " ?>";
        }
    }

    class MyEntityReference
    extends MyNode
    implements EntityReference {
        private String name;

        MyEntityReference(String name) {
            super((short)5);
            this.name = name;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            this.checkAppendNode(newChild);
            throw new DOMException(9, "This implementation does not support appending nodes to an entity reference.");
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            return null;
        }

        @Override
        EntityReference cloneNode(HTMLDocument ownerDocument) {
            EntityReference my = ownerDocument.createEntityReference(this.name);
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        public String toString() {
            return '&' + this.name + ';';
        }
    }

    public class HTMLDocumentFragment
    extends MyNode
    implements DocumentFragment,
    ParentNode {
        WeakReference<ElementList> childElementRef;

        HTMLDocumentFragment() {
            super((short)11);
            this.childElementRef = null;
        }

        @Override
        protected DOMNode.DOMNodeList createChildNodeList() {
            return new DOMNode.ChildNodeList();
        }

        @Override
        public String getNodeName() {
            return "#document-fragment";
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            return null;
        }

        @Override
        public ElementList getChildren() {
            ElementList list = null;
            if (this.childElementRef != null) {
                list = (ElementList)this.childElementRef.get();
            }
            if (list == null) {
                list = new DOMNode.ChildElementList();
                this.childElementRef = new WeakReference<ElementList>(list);
            }
            return list;
        }

        @Override
        public HTMLElement getFirstElementChild() {
            return super.getFirstElementChild();
        }

        @Override
        public HTMLElement getLastElementChild() {
            return super.getLastElementChild();
        }

        @Override
        public int getChildElementCount() {
            return super.getChildElementCount();
        }

        @Override
        public ElementList querySelectorAll(String selectors) {
            return HTMLElement.querySelectorAll(selectors, this.getChildNodes());
        }

        @Override
        public HTMLDocumentFragment cloneNode(boolean deep) {
            HTMLDocumentFragment my = new HTMLDocumentFragment();
            if (deep && my.hasChildNodes()) {
                NodeList list = my.getChildNodes();
                int sz = list.getLength();
                for (int i = 0; i < sz; ++i) {
                    my.appendChild(list.item(i).cloneNode(true));
                }
            }
            this.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        DocumentFragment cloneNode(HTMLDocument ownerDocument) {
            return ownerDocument.createDocumentFragment();
        }

        public String toString() {
            NodeList list = this.getChildNodes();
            int sz = list.getLength();
            StringBuilder buf = new StringBuilder(64 + sz * 32);
            for (int i = 0; i < sz; ++i) {
                buf.append(list.item(i).toString());
            }
            return buf.toString();
        }
    }

    abstract class MyNode
    extends DOMNode {
        MyNode(short nodeType) {
            this(nodeType, HTMLDocument.HTML_NAMESPACE_URI);
        }

        MyNode(short nodeType, String namespaceURI) {
            super(nodeType, namespaceURI);
        }

        @Override
        public HTMLDocument getOwnerDocument() {
            return HTMLDocument.this;
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            if (newChild.getNodeType() == 10) {
                throw new DOMException(3, "Doctype must be added to document.");
            }
            return super.appendChild(newChild);
        }

        @Override
        public String getBaseURI() {
            return HTMLDocument.this.getBaseURI();
        }

        @Override
        public Node cloneNode(boolean deep) {
            return this;
        }
    }
}

